/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.factory;

import com.alibaba.citrus.service.moduleloader.ModuleFactory;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderException;
import com.alibaba.citrus.service.moduleloader.impl.factory.ModuleInfo;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;

abstract class AbstractBeanFactoryBasedModuleFactory
implements InitializingBean,
BeanFactoryAware,
ModuleFactory {
    private BeanFactory beans;
    private Map<String, Map<String, ModuleInfo>> modules;

    AbstractBeanFactoryBasedModuleFactory() {
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beans = beanFactory;
    }

    public void setModules(ModuleInfo[] modules) {
        this.modules = CollectionUtil.createHashMap();
        if (modules != null) {
            for (ModuleInfo module : modules) {
                Map<String, ModuleInfo> typedModules = this.modules.get(module.getKey().getModuleType());
                if (typedModules == null) {
                    typedModules = CollectionUtil.createHashMap();
                    this.modules.put(module.getKey().getModuleType(), typedModules);
                }
                typedModules.put(module.getKey().getModuleName(), module);
            }
        }
    }

    public void afterPropertiesSet() {
        Assert.assertNotNull(this.beans, "beans", new Object[0]);
        Assert.assertNotNull(this.modules, "modules", new Object[0]);
    }

    @Override
    public Set<String> getModuleTypes() {
        return Collections.unmodifiableSet(this.modules.keySet());
    }

    @Override
    public Set<String> getModuleNames(String moduleType) {
        Map<String, ModuleInfo> typedModules = this.modules.get(moduleType);
        if (typedModules == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(typedModules.keySet());
    }

    @Override
    public Object getModule(String moduleType, String moduleName) throws ModuleLoaderException {
        Map<String, ModuleInfo> typedModules = this.modules.get(moduleType);
        if (typedModules == null) {
            return null;
        }
        ModuleInfo module = typedModules.get(moduleName);
        if (module == null) {
            return null;
        }
        if (!this.beans.containsBean(module.getBeanName())) {
            return null;
        }
        try {
            return this.beans.getBean(module.getBeanName());
        }
        catch (Exception e) {
            throw new ModuleLoaderException("Failure loading module: " + moduleType + ":" + moduleName, e);
        }
    }
}

