/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.locale.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextInfo;
import com.alibaba.citrus.service.requestcontext.locale.SetLocaleRequestContext;
import com.alibaba.citrus.service.requestcontext.locale.impl.SetLocaleOverrider;
import com.alibaba.citrus.service.requestcontext.locale.impl.SetLocaleRequestContextImpl;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextFactory;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.i18n.LocaleUtil;
import java.util.Locale;
import java.util.regex.Pattern;

public class SetLocaleRequestContextFactoryImpl
extends AbstractRequestContextFactory<SetLocaleRequestContext> {
    private String inputCharsetParam;
    private Pattern inputCharsetPattern;
    private String outputCharsetParam;
    private Pattern outputCharsetPattern;
    private SetLocaleOverrider[] overriders;
    private String defaultLocaleName;
    private Locale defaultLocale;
    private String defaultCharset;
    private String sessionKey;
    private String paramKey;

    public void setInputCharsetParam(String inputCharsetParam) {
        this.inputCharsetParam = StringUtil.trimToNull(inputCharsetParam);
    }

    public void setOutputCharsetParam(String outputCharsetParam) {
        this.outputCharsetParam = StringUtil.trimToNull(outputCharsetParam);
    }

    public void setOverriders(SetLocaleOverrider[] overriders) {
        this.overriders = overriders;
    }

    public void setDefaultLocale(String defaultLocaleName) {
        this.defaultLocaleName = StringUtil.trimToNull(defaultLocaleName);
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = StringUtil.trimToNull(defaultCharset);
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = StringUtil.trimToNull(sessionKey);
    }

    public void setParamKey(String paramKey) {
        this.paramKey = StringUtil.trimToNull(paramKey);
    }

    @Override
    protected void init() {
        this.inputCharsetParam = ObjectUtil.defaultIfNull(this.inputCharsetParam, "_input_charset");
        this.inputCharsetPattern = Pattern.compile("(" + this.inputCharsetParam + ")=([\\w-]+)");
        this.outputCharsetParam = ObjectUtil.defaultIfNull(this.outputCharsetParam, "_output_charset");
        this.outputCharsetPattern = Pattern.compile("(" + this.outputCharsetParam + ")=([\\w-]+)");
        this.sessionKey = ObjectUtil.defaultIfNull(this.sessionKey, "_lang");
        this.paramKey = ObjectUtil.defaultIfNull(this.paramKey, "_lang");
        this.defaultLocaleName = ObjectUtil.defaultIfNull(this.defaultLocaleName, "en_US");
        this.defaultLocale = LocaleUtil.parseLocale(this.defaultLocaleName);
        Assert.assertTrue(LocaleUtil.isLocaleSupported(this.defaultLocale), "Locale %s is not supported", this.defaultLocale);
        this.defaultCharset = ObjectUtil.defaultIfNull(this.defaultCharset, "UTF-8");
        Assert.assertTrue(LocaleUtil.isCharsetSupported(this.defaultCharset), "Charset %s is not supported", this.defaultCharset);
    }

    @Override
    public SetLocaleRequestContext getRequestContextWrapper(RequestContext wrappedContext) {
        SetLocaleRequestContextImpl requestContext = new SetLocaleRequestContextImpl(wrappedContext);
        requestContext.setInputCharsetPattern(this.inputCharsetPattern);
        requestContext.setOutputCharsetPattern(this.outputCharsetPattern);
        requestContext.setOverriders(this.overriders);
        requestContext.setDefaultLocale(this.defaultLocale);
        requestContext.setDefaultCharset(this.defaultCharset);
        requestContext.setSessionKey(this.sessionKey);
        requestContext.setParamKey(this.paramKey);
        return requestContext;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"setLocaleAndCharset"};
    }

    @Override
    public RequestContextInfo.FeatureOrder[] featureOrders() {
        return new RequestContextInfo.FeatureOrder[]{new RequestContextInfo.AfterFeature("session")};
    }

    @Override
    protected Object dumpConfiguration() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("Input Charset Pattern", this.inputCharsetParam);
        mb.append("Output Charset Pattern", this.outputCharsetParam);
        mb.append("Default Locale", this.defaultLocaleName);
        mb.append("Default Charset", this.defaultCharset);
        mb.append("Session Key", this.sessionKey);
        mb.append("Parameter Key", this.paramKey);
        return mb;
    }
}

