/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.uri;

import com.alibaba.citrus.service.uribroker.uri.ServletURIBroker;
import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.Map;

public class TurbineClassicURIBroker
extends ServletURIBroker {
    private static final int TEMPLATE_INDEX = 2;
    private static final int SCREEN_INDEX = 3;
    private static final int ACTION_INDEX = 4;
    private static final int PATH_INFO_PARAM_INDEX = 5;
    private boolean hasTemplate;
    private boolean hasScreen;
    private boolean hasAction;

    public String getPage() {
        if (this.hasTemplate) {
            return this.getPathSegment(2).get(1);
        }
        return null;
    }

    public TurbineClassicURIBroker setPage(String page) {
        this.setPathInfo(2, "template", page, false);
        this.hasTemplate = true;
        return this;
    }

    public String getScreen() {
        if (this.hasScreen) {
            return this.getPathSegment(3).get(1);
        }
        return null;
    }

    public TurbineClassicURIBroker setScreen(String screen) {
        this.setPathInfo(3, "screen", screen, false);
        this.hasScreen = true;
        return this;
    }

    public String getAction() {
        if (this.hasAction) {
            return this.getPathSegment(4).get(1);
        }
        return null;
    }

    public TurbineClassicURIBroker setAction(String action) {
        this.setPathInfo(4, "action", action, false);
        this.hasAction = true;
        return this;
    }

    public TurbineClassicURIBroker addPathInfo(String id, Object value) {
        this.setPathInfo(5, id, value, true);
        return this;
    }

    public void setPathInfoParams(Map<String, Object> values) {
        this.clearPathInfoParams();
        if (values != null) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                this.addPathInfo(entry.getKey(), entry.getValue());
            }
        }
    }

    public TurbineClassicURIBroker clearPathInfoParams() {
        this.clearPathSegment(5);
        return this;
    }

    private void setPathInfo(int index, String id, Object value, boolean add) {
        id = Assert.assertNotNull(StringUtil.trimToNull(id), "empty pathInfo id", new Object[0]);
        String strValue = StringUtil.trimToNull(String.valueOf(value).replaceAll("/", ","));
        if (add) {
            this.addPathSegment(index, id);
        } else {
            this.setPathSegment(index, id);
        }
        this.addPathSegment(index, String.valueOf(strValue));
    }

    @Override
    protected URIBroker newInstance() {
        return new TurbineClassicURIBroker();
    }

    @Override
    protected void initDefaults(URIBroker parent) {
        super.initDefaults(parent);
        if (parent instanceof TurbineClassicURIBroker) {
            TurbineClassicURIBroker parentTurbine = (TurbineClassicURIBroker)parent;
            if (!this.hasTemplate) {
                this.hasTemplate = parentTurbine.hasTemplate;
                this.setPathSegment(2, parentTurbine.getPathSegment(2));
            }
            if (!this.hasScreen) {
                this.hasScreen = parentTurbine.hasScreen;
                this.setPathSegment(3, parentTurbine.getPathSegment(3));
            }
            if (!this.hasAction) {
                this.hasAction = parentTurbine.hasAction;
                this.setPathSegment(4, parentTurbine.getPathSegment(4));
            }
            this.setPathSegment(5, parent.getPathSegment(5), this.getPathSegment(5));
        }
    }

    @Override
    protected void copyFrom(URIBroker parent) {
        super.copyFrom(parent);
        if (parent instanceof TurbineClassicURIBroker) {
            TurbineClassicURIBroker parentTurbine = (TurbineClassicURIBroker)parent;
            this.hasTemplate = parentTurbine.hasTemplate;
            this.setPathSegment(2, parentTurbine.getPathSegment(2));
            this.hasScreen = parentTurbine.hasScreen;
            this.setPathSegment(3, parentTurbine.getPathSegment(3));
            this.hasAction = parentTurbine.hasAction;
            this.setPathSegment(4, parentTurbine.getPathSegment(4));
            this.setPathSegment(5, parentTurbine.getPathSegment(5));
        }
    }

    @Override
    protected int getPathSegmentCount() {
        return 6;
    }
}

