/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.uri;

import com.alibaba.citrus.service.requestcontext.util.QueryStringParser;
import com.alibaba.citrus.service.uribroker.interceptor.URIBrokerInterceptor;
import com.alibaba.citrus.service.uribroker.interceptor.URIBrokerPathInterceptor;
import com.alibaba.citrus.service.uribroker.uri.URIBrokerFeatures;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public abstract class URIBroker
extends URIBrokerFeatures {
    public static final String SERVER_SCHEME_HTTP = "http";
    public static final String SERVER_SCHEME_HTTPS = "https";
    public static final Integer SERVER_PORT_HTTP = 80;
    public static final Integer SERVER_PORT_HTTPS = 443;
    protected static final int PATH_INDEX = 0;
    private static final Pattern pathPattern = Pattern.compile("(^/*|/+)(^[^/]+|[^/]*)");
    private final int[] pathSegmentIndexes = new int[this.getPathSegmentCount()];
    private URIType type;
    private URI baseURI;
    private String serverScheme;
    private String serverName;
    private int serverPort = -1;
    private String loginUser;
    private String loginPassword;
    private String reference;
    private final List<String> path = CollectionUtil.createLinkedList();
    private final Map<String, Object> query = CollectionUtil.createLinkedHashMap();

    public URIType getURIType() {
        return this.type;
    }

    public URIBroker setURIType(URIType type) {
        this.type = type;
        return this;
    }

    public URIBroker autoURI() {
        return this.setURIType(URIType.auto);
    }

    public URIBroker fullURI() {
        return this.setURIType(URIType.full);
    }

    public URIBroker absoluteURI() {
        return this.setURIType(URIType.absolute);
    }

    public URIBroker relativeURI() {
        return this.setURIType(URIType.relative);
    }

    public String getBaseURI() {
        return this.baseURI == null ? null : this.baseURI.toString();
    }

    public URIBroker setBaseURI(String baseURI) {
        this.baseURI = (baseURI = StringUtil.trimToNull(baseURI)) == null ? null : URI.create(baseURI).normalize();
        return this;
    }

    public String getServerURI() {
        this.processInterceptors();
        StringBuilder buf = new StringBuilder();
        this.render(buf, true);
        return buf.toString();
    }

    public final URIBroker setServerURI(String uriString) {
        URL uri;
        try {
            uri = new URL(Assert.assertNotNull(StringUtil.trimToNull(uriString), "serverURI", new Object[0]));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        String serverScheme = uri.getProtocol();
        String[] userInfo = StringUtil.split(uri.getUserInfo(), ":");
        String serverName = uri.getHost();
        int serverPort = uri.getPort();
        if (serverScheme != null) {
            this.setServerScheme(serverScheme);
        }
        if (!ArrayUtil.isEmptyArray(userInfo)) {
            if (userInfo.length > 0) {
                this.setLoginUser(userInfo[0]);
            }
            if (userInfo.length > 1) {
                this.setLoginPassword(userInfo[1]);
            }
        }
        if (serverName != null) {
            this.setServerName(serverName);
        }
        if (serverPort > 0) {
            this.setServerPort(serverPort);
        }
        this.setServerURI(uri);
        new URIBrokerQueryStringParser().parse(uri.getQuery());
        this.setReference(uri.getRef());
        return this;
    }

    protected void setServerURI(URL uri) {
    }

    public String getServerScheme() {
        return this.serverScheme;
    }

    public URIBroker setServerScheme(String serverScheme) {
        this.serverScheme = StringUtil.trim(serverScheme);
        this.renderer.clearServerBuffer();
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public URIBroker setServerName(String serverName) {
        this.serverName = StringUtil.trim(serverName);
        this.renderer.clearServerBuffer();
        return this;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public URIBroker setServerPort(int serverPort) {
        this.serverPort = serverPort <= 0 ? -1 : serverPort;
        this.renderer.clearServerBuffer();
        return this;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public URIBroker setLoginUser(String loginUser) {
        this.loginUser = StringUtil.trim(loginUser);
        this.renderer.clearServerBuffer();
        return this;
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public URIBroker setLoginPassword(String loginPassword) {
        this.loginPassword = StringUtil.trim(loginPassword);
        this.renderer.clearServerBuffer();
        return this;
    }

    public String getReference() {
        return this.reference;
    }

    public URIBroker setReference(String reference) {
        this.reference = StringUtil.trim(reference);
        return this;
    }

    public String getPath() {
        return this.getAllPathSegmentsAsString(0);
    }

    public List<String> getPathElements() {
        return this.getAllPathSegments(0);
    }

    protected abstract int getPathSegmentCount();

    protected final List<String> getAllPathSegments(int segment) {
        return this.subPath(segment, true);
    }

    protected final List<String> getPathSegment(int segment) {
        return this.subPath(segment, false);
    }

    private List<String> subPath(int segment, boolean multi) {
        int beginIndex;
        this.assertSegment(segment);
        int size = this.path.size();
        int endIndex = multi ? size : this.pathSegmentIndexes[segment];
        int n = beginIndex = segment > 0 ? this.pathSegmentIndexes[segment - 1] : 0;
        if (beginIndex == 0 && endIndex == size) {
            return this.path;
        }
        return this.path.subList(beginIndex, endIndex);
    }

    protected final String getAllPathSegmentsAsString(int segment) {
        return this.getSubPathAsString(segment, true);
    }

    protected final String getPathSegmentAsString(int segment) {
        return this.getSubPathAsString(segment, false);
    }

    private String getSubPathAsString(int segment, boolean multi) {
        int beginIndex;
        this.assertSegment(segment);
        StringBuilder buf = new StringBuilder();
        int endIndex = multi ? this.path.size() : this.pathSegmentIndexes[segment];
        for (int i = beginIndex = segment > 0 ? this.pathSegmentIndexes[segment - 1] : 0; i < endIndex; ++i) {
            buf.append("/").append(this.path.get(i));
        }
        return buf.toString();
    }

    protected final void setPathSegment(int segment, List<?> ... lists) {
        LinkedList<String> mergedList = CollectionUtil.createLinkedList();
        if (lists != null) {
            for (List<?> list : lists) {
                mergedList.addAll(list);
            }
        }
        this.clearPathSegment(segment);
        if (!mergedList.isEmpty()) {
            for (String element : mergedList) {
                this.addPathSegment(segment, element, false);
            }
        }
    }

    protected final void setPathSegment(int segment, String path) {
        this.clearPathSegment(segment);
        this.addPathSegment(segment, path);
    }

    protected final void addPathSegment(int segment, String path) {
        this.addPathSegment(segment, path, true);
    }

    private void addPathSegment(int segment, String path, boolean split) {
        this.assertSegment(segment);
        if (path != null) {
            int newAdded;
            boolean isAppend;
            int index = this.pathSegmentIndexes[segment];
            boolean bl = isAppend = index == this.pathSegmentIndexes[this.pathSegmentIndexes.length - 1];
            if (split) {
                for (String element : StringUtil.split(path, " /\\")) {
                    index = this.addPathElement(element, index, isAppend);
                }
            } else {
                index = this.addPathElement(path, index, isAppend);
            }
            if ((newAdded = index - this.pathSegmentIndexes[segment]) > 0) {
                int i = segment;
                while (i < this.pathSegmentIndexes.length) {
                    int n = i++;
                    this.pathSegmentIndexes[n] = this.pathSegmentIndexes[n] + newAdded;
                }
            }
        }
    }

    private int addPathElement(String element, int elementIndex, boolean isAppend) {
        if (!StringUtil.isEmpty(element)) {
            this.path.add(elementIndex, element);
            if (isAppend) {
                this.renderer.updatePathBuffer(element);
            } else {
                this.renderer.clearPathBuffer();
            }
            return elementIndex + 1;
        }
        return elementIndex;
    }

    protected final void clearPathSegment(int segment) {
        boolean isTruncate;
        this.assertSegment(segment);
        int index = this.pathSegmentIndexes[segment];
        int previousIndex = segment > 0 ? this.pathSegmentIndexes[segment - 1] : 0;
        int removedCount = index - previousIndex;
        boolean bl = isTruncate = index == this.pathSegmentIndexes[this.pathSegmentIndexes.length - 1];
        if (removedCount > 0) {
            int j;
            ListIterator<String> i = this.path.listIterator(index);
            for (j = 0; j < removedCount; ++j) {
                i.previous();
                i.remove();
            }
            j = segment;
            while (j < this.pathSegmentIndexes.length) {
                int n = j++;
                this.pathSegmentIndexes[n] = this.pathSegmentIndexes[n] - removedCount;
            }
            if (isTruncate) {
                this.renderer.truncatePathBuffer(removedCount);
            } else {
                this.renderer.clearPathBuffer();
            }
        }
    }

    private void assertSegment(int segment) {
        if (segment < 0 || segment >= this.pathSegmentIndexes.length) {
            throw new IllegalArgumentException("segment index " + segment + " out of bound [0, " + this.pathSegmentIndexes.length + ")");
        }
    }

    public Map<String, Object> getQuery() {
        return this.query;
    }

    public void setQuery(Map<String, Object> query) {
        this.getQuery().clear();
        if (query != null && !query.isEmpty()) {
            for (Map.Entry<String, Object> entry : query.entrySet()) {
                this.setQueryData(entry.getKey(), entry.getValue());
            }
        }
        this.renderer.clearQueryBuffer();
    }

    public URIBroker clearQuery() {
        if (this.query != null) {
            this.query.clear();
        }
        this.renderer.clearQueryBuffer();
        return this;
    }

    public String getQueryData(String id) {
        String[] values;
        Object value = this.getQuery().get(id);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof String[] && (values = (String[])value).length > 0) {
            return values[0];
        }
        return null;
    }

    public URIBroker setQueryData(String id, Object values) {
        id = Assert.assertNotNull(StringUtil.trimToNull(id), "empty query id", new Object[0]);
        Map<String, Object> query = this.getQuery();
        if (values == null) {
            query.put(id, "");
        } else if (values instanceof String[]) {
            String[] strArray = (String[])values;
            for (int i = 0; i < strArray.length; ++i) {
                if (strArray[i] != null) continue;
                strArray[i] = "";
            }
            query.put(id, strArray);
        } else if (values.getClass().isArray()) {
            String[] strArray = new String[Array.getLength(values)];
            for (int i = 0; i < strArray.length; ++i) {
                Object value = Array.get(values, i);
                strArray[i] = value == null ? "" : String.valueOf(value);
            }
            query.put(id, strArray);
        } else {
            query.put(id, String.valueOf(values));
        }
        this.renderer.clearQueryBuffer();
        return this;
    }

    public URIBroker addQueryData(String id, Object value) {
        String strValue;
        id = Assert.assertNotNull(StringUtil.trimToNull(id), "empty query id", new Object[0]);
        if (value == null) {
            strValue = "";
        } else {
            Assert.assertTrue(!value.getClass().isArray(), "use setQueryData(array) instead", new Object[0]);
            strValue = String.valueOf(value);
        }
        String[] values = this.getQuery().get(id);
        if (values == null) {
            values = strValue;
        } else if (values instanceof String) {
            values = new String[]{(String)values, strValue};
        } else if (values instanceof String[]) {
            int length = ((String[])values).length;
            String[] tmp = new String[length + 1];
            System.arraycopy(values, 0, tmp, 0, length);
            tmp[length] = strValue;
            values = tmp;
        } else {
            Assert.unreachableCode();
        }
        this.getQuery().put(id, values);
        this.renderer.updateQueryBuffer(id, strValue);
        return this;
    }

    public URIBroker removeQueryData(String id) {
        if (this.query != null) {
            this.query.remove(StringUtil.trimToNull(id));
        }
        this.renderer.clearQueryBuffer();
        return this;
    }

    protected final String setUriAndGetPath(String uri) {
        if (uri != null) {
            int i = uri.indexOf("?");
            int j = uri.indexOf("#", i + 1);
            if (j >= 0) {
                this.setReference(uri.substring(j + 1));
                uri = uri.substring(0, j);
            }
            if (i >= 0) {
                String query = uri.substring(i + 1);
                uri = uri.substring(0, i);
                new URIBrokerQueryStringParser().parse(query);
            }
        }
        return uri;
    }

    @Override
    protected void initDefaults(URIBroker parent) {
        if (this.type == null) {
            this.type = parent.getURIType();
        }
        if (this.baseURI == null) {
            this.baseURI = parent.baseURI;
        }
        if (this.serverScheme == null) {
            this.serverScheme = parent.getServerScheme();
        }
        if (this.serverName == null) {
            this.serverName = parent.getServerName();
        }
        if (this.serverPort <= 0) {
            this.serverPort = parent.getServerPort();
        }
        if (this.loginUser == null) {
            this.loginUser = parent.getLoginUser();
        }
        if (this.loginPassword == null) {
            this.loginPassword = parent.getLoginPassword();
        }
        if (this.reference == null) {
            this.reference = parent.getReference();
        }
        if (!parent.getQuery().isEmpty()) {
            LinkedHashMap<String, Object> queryCopy = CollectionUtil.createLinkedHashMap();
            queryCopy.putAll(this.getQuery());
            this.clearQuery();
            this.getQuery().putAll(parent.getQuery());
            for (Map.Entry entry : queryCopy.entrySet()) {
                String id = (String)entry.getKey();
                Object values = entry.getValue();
                if (values instanceof String) {
                    this.addQueryData(id, values);
                    continue;
                }
                if (!(values instanceof String[])) continue;
                for (String value : (String[])values) {
                    this.addQueryData(id, value);
                }
            }
        }
    }

    @Override
    protected void copyFrom(URIBroker parent) {
        this.baseURI = parent.baseURI;
        this.setURIType(parent.getURIType());
        this.setServerScheme(parent.getServerScheme());
        this.setServerName(parent.getServerName());
        this.setServerPort(parent.getServerPort());
        this.setLoginUser(parent.getLoginUser());
        this.setLoginPassword(parent.getLoginPassword());
        this.setReference(parent.getReference());
        this.clearQuery();
        this.setQuery(parent.getQuery());
    }

    @Override
    protected void populateWithRequest(HttpServletRequest request) {
        if (this.serverScheme == null && this.serverName == null && this.serverPort <= 0) {
            this.setServerScheme(request.getScheme());
            this.setServerName(request.getServerName());
            this.setServerPort(request.getServerPort());
        }
    }

    protected String processPathInterceptors(String path) {
        if (this.hasInterceptors()) {
            for (Map.Entry<URIBrokerInterceptor, Integer> entry : this.getInterceptorStates().entrySet()) {
                if (!(entry.getKey() instanceof URIBrokerPathInterceptor)) continue;
                URIBrokerPathInterceptor interceptor = (URIBrokerPathInterceptor)entry.getKey();
                Integer value = entry.getValue();
                if (value == null || value != 1) continue;
                path = interceptor.perform(this, path);
            }
        }
        return path;
    }

    @Override
    protected final void render(StringBuilder buf) {
        this.render(buf, false);
    }

    private void render(StringBuilder buf, boolean renderServerURIOnly) {
        URIType type = renderServerURIOnly || this.getURIType() == null ? URIType.full : this.getURIType();
        BaseURI baseURI = null;
        boolean renderServer = true;
        switch (type) {
            case auto: 
            case absolute: 
            case relative: {
                baseURI = this.createBaseURI();
                if (baseURI == null) break;
                String scheme = this.getEffectiveServerScheme(this.getServerScheme());
                int port = this.getEffectiveServerPort(scheme, this.getServerPort());
                if (!ObjectUtil.isEquals(scheme, baseURI.serverScheme) || !ObjectUtil.isEquals(this.getServerName(), baseURI.serverName) || port != baseURI.serverPort) break;
                renderServer = false;
                break;
            }
        }
        if (renderServer) {
            if (this.renderer.isServerRendered()) {
                buf.append((CharSequence)this.renderer.serverBuffer);
            } else {
                this.renderServer(buf);
            }
        }
        String path = "";
        if (!this.path.isEmpty()) {
            StringBuilder pathBuf = new StringBuilder();
            if (this.renderer.isPathRendered()) {
                pathBuf.append((CharSequence)this.renderer.pathBuffer);
            } else {
                this.renderPath(pathBuf);
            }
            path = pathBuf.toString();
        }
        path = StringUtil.trimToEmpty(this.processPathInterceptors(path));
        if (!renderServer) {
            switch (type) {
                case relative: {
                    path = this.getRelativePath(baseURI.path, path);
                    break;
                }
                case auto: {
                    String relativePath = this.getRelativePath(baseURI.path, path);
                    if (relativePath.startsWith("../")) break;
                    path = relativePath;
                    break;
                }
            }
        }
        if (renderServer && !path.startsWith("/")) {
            buf.append("/");
        }
        buf.append(path);
        if (!renderServerURIOnly) {
            if (this.renderer.isQueryRendered()) {
                buf.append((CharSequence)this.renderer.queryBuffer);
            } else {
                this.renderQuery(buf);
            }
            String reference = this.getReference();
            if (!StringUtil.isEmpty(reference)) {
                buf.append("#");
                buf.append(reference);
            }
        }
    }

    private BaseURI createBaseURI() {
        BaseURI result = null;
        if (this.baseURI != null) {
            result = new BaseURI();
            result.serverScheme = this.getEffectiveServerScheme(this.baseURI.getScheme());
            result.serverName = StringUtil.trimToNull(this.baseURI.getHost());
            result.serverPort = this.getEffectiveServerPort(result.serverScheme, this.baseURI.getPort());
            result.path = StringUtil.trimToEmpty(this.baseURI.getPath());
        } else {
            HttpServletRequest request = this.getRealRequest();
            if (request != null) {
                result = new BaseURI();
                result.serverScheme = this.getEffectiveServerScheme(request.getScheme());
                result.serverName = StringUtil.trimToNull(request.getServerName());
                result.serverPort = this.getEffectiveServerPort(result.serverScheme, request.getServerPort());
                result.path = StringUtil.trimToEmpty(request.getRequestURI());
            }
        }
        return result;
    }

    private String getRelativePath(String base, String path) {
        boolean pathFound;
        boolean baseFound;
        int index = base.lastIndexOf("/");
        if (index >= 0) {
            base = base.substring(0, index);
        }
        if (StringUtil.isEmpty(base)) {
            if (path.startsWith("/")) {
                return path.replaceFirst("^/+", "");
            }
            return path;
        }
        Matcher baseMatcher = pathPattern.matcher(base);
        Matcher pathMatcher = pathPattern.matcher(path);
        do {
            baseFound = baseMatcher.find();
            pathFound = pathMatcher.find();
        } while (baseFound && pathFound && ObjectUtil.isEquals(baseMatcher.group(2), pathMatcher.group(2)));
        StringBuilder relativePath = new StringBuilder();
        while (baseFound) {
            relativePath.append("../");
            baseFound = baseMatcher.find();
        }
        while (pathFound) {
            relativePath.append(pathMatcher.group(2));
            pathFound = pathMatcher.find();
            if (!pathFound) continue;
            relativePath.append("/");
        }
        return relativePath.toString();
    }

    @Override
    protected final void renderServer(StringBuilder buf) {
        String serverName;
        String serverScheme = this.getEffectiveServerScheme(this.getServerScheme());
        buf.append(serverScheme);
        buf.append("://");
        String loginUser = this.getLoginUser();
        String loginPassword = this.getLoginPassword();
        if (!StringUtil.isEmpty(loginUser)) {
            buf.append(loginUser);
            if (!StringUtil.isEmpty(loginPassword)) {
                buf.append(":").append(loginPassword);
            }
            buf.append("@");
        }
        if (!StringUtil.isEmpty(serverName = this.getServerName())) {
            buf.append(serverName);
            if (!this.isDefaultPort(serverScheme)) {
                buf.append(":");
                buf.append(this.getServerPort());
            }
        }
    }

    private String getEffectiveServerScheme(String serverScheme) {
        return StringUtil.defaultIfEmpty(serverScheme, SERVER_SCHEME_HTTP);
    }

    private int getEffectiveServerPort(String serverScheme, int serverPort) {
        if (serverPort <= 0) {
            if (SERVER_SCHEME_HTTP.equals(serverScheme)) {
                return SERVER_PORT_HTTP;
            }
            if (SERVER_SCHEME_HTTPS.equals(serverScheme)) {
                return SERVER_PORT_HTTPS;
            }
        }
        return serverPort;
    }

    private boolean isDefaultPort(String serverScheme) {
        boolean isDefaultPort;
        int serverPort = this.getServerPort();
        boolean bl = isDefaultPort = serverPort <= 0;
        if (!isDefaultPort) {
            isDefaultPort |= SERVER_SCHEME_HTTP.equals(serverScheme) && serverPort == SERVER_PORT_HTTP;
            isDefaultPort |= SERVER_SCHEME_HTTPS.equals(serverScheme) && serverPort == SERVER_PORT_HTTPS;
        }
        return isDefaultPort;
    }

    @Override
    protected final void renderPath(StringBuilder buf) {
        for (String path : this.path) {
            buf.append("/").append(this.escapeURL(path));
        }
    }

    @Override
    protected final void renderQuery(StringBuilder buf) {
        if (!this.getQuery().isEmpty()) {
            buf.append("?");
            Iterator<Map.Entry<String, Object>> i = this.getQuery().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Object> entry = i.next();
                String id = this.escapeURL(entry.getKey());
                Object value = entry.getValue();
                if (value instanceof String[]) {
                    int length = ((String[])value).length;
                    for (int j = 0; j < length; ++j) {
                        buf.append(id).append("=").append(this.escapeURL(((String[])value)[j]));
                        if (j + 1 >= length) continue;
                        buf.append("&");
                    }
                } else {
                    buf.append(id).append("=").append(this.escapeURL(String.valueOf(value)));
                }
                if (!i.hasNext()) continue;
                buf.append("&");
            }
        }
    }

    private final class URIBrokerQueryStringParser
    extends QueryStringParser {
        public URIBrokerQueryStringParser() {
            super(URIBroker.this.getCharset());
        }

        @Override
        protected void add(String key, String value) {
            URIBroker.this.addQueryData(key, value);
        }
    }

    private class BaseURI {
        String serverScheme;
        String serverName;
        int serverPort;
        String path;

        private BaseURI() {
        }
    }

    public static enum URIType {
        auto,
        full,
        absolute,
        relative;

    }
}

