/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.impl.SchemaImpl;
import com.alibaba.citrus.springext.support.SchemaInternal;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.core.io.InputStreamSource;

public class SchemaSet
implements Schemas {
    private final Map<String, Schema> nameToSchemas = CollectionUtil.createHashMap();
    private final Map<String, Schema> nameToSchemasUnmodifiable = Collections.unmodifiableMap(this.nameToSchemas);
    private final SortedSet<String> names;

    public SchemaSet(Schemas ... schemasList) {
        Assert.assertTrue(!ArrayUtil.isEmptyArray(schemasList), "schemasList", new Object[0]);
        for (Schemas schemas : schemasList) {
            this.nameToSchemas.putAll(schemas.getNamedMappings());
        }
        this.names = CollectionUtil.createTreeSet(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int lengthCompare = o2.length() - o1.length();
                if (lengthCompare == 0) {
                    return o1.compareTo(o2);
                }
                return lengthCompare;
            }
        }, this.nameToSchemas.keySet());
        this.processIncludes();
    }

    private void processIncludes() {
        for (Schema schema : CollectionUtil.createArrayList(this.nameToSchemas.values())) {
            Schema newSchema;
            Map<String, Schema> allIncludes = this.getAllIncludes(schema);
            String[] allElements = this.getAllElements(schema, allIncludes.values());
            boolean withIndirectIncludes = false;
            for (Schema includedSchema : allIncludes.values()) {
                if (includedSchema.getIncludes().length <= 0) continue;
                withIndirectIncludes = true;
                this.overrideSchemaForInclude(includedSchema);
            }
            if (withIndirectIncludes) {
                schema = this.setSchemaWithIncludes(schema, allIncludes);
            }
            if (!((newSchema = this.nameToSchemas.get(schema.getName())) instanceof SchemaInternal)) continue;
            ((SchemaInternal)newSchema).setElements(allElements);
        }
    }

    private String[] getAllElements(Schema schema, Collection<Schema> includes) {
        TreeSet<String> all = CollectionUtil.createTreeSet();
        all.addAll(Arrays.asList(schema.getElements()));
        for (Schema include : includes) {
            all.addAll(Arrays.asList(include.getElements()));
        }
        return all.toArray(new String[all.size()]);
    }

    private void overrideSchemaForInclude(final Schema schema) {
        InputStreamSource sourceWithoutIncludes = new InputStreamSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(SchemaUtil.getSchemaContentWithoutIncludes(schema));
            }
        };
        this.addSchema(new SchemaImpl(schema.getName(), schema.getVersion(), schema.getTargetNamespace(), schema.getPreferredNsPrefix(), schema.getSourceDescription(), sourceWithoutIncludes));
    }

    private Schema setSchemaWithIncludes(final Schema schema, final Map<String, Schema> allIncludes) {
        InputStreamSource sourceWithModifiedIncludes = new InputStreamSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(SchemaUtil.getSchemaContentWithIndirectIncludes(schema, allIncludes));
            }
        };
        SchemaImpl newSchema = new SchemaImpl(schema.getName(), schema.getVersion(), schema.getTargetNamespace(), schema.getPreferredNsPrefix(), schema.getSourceDescription(), sourceWithModifiedIncludes);
        this.addSchema(newSchema);
        return newSchema;
    }

    private Map<String, Schema> getAllIncludes(Schema schema) {
        LinkedHashMap<String, Schema> includes = CollectionUtil.createLinkedHashMap();
        this.getAllIncludesDepthFirst(schema, includes);
        includes.remove(schema.getName());
        return includes;
    }

    private void getAllIncludesDepthFirst(Schema schema, Map<String, Schema> includes) {
        for (String include : schema.getIncludes()) {
            Schema includedSchema = this.findIncludedSchema(include, schema.getName());
            this.getAllIncludesDepthFirst(includedSchema, includes);
        }
        includes.put(schema.getName(), schema);
    }

    private Schema findIncludedSchema(String include, String fromSchema) {
        return Assert.assertNotNull(this.findSchema(include), "Could not include schema \"%s\" in %s", include, fromSchema);
    }

    public void addSchema(Schema schema) {
        this.nameToSchemas.put(schema.getName(), schema);
        this.names.add(schema.getName());
    }

    @Override
    public Map<String, Schema> getNamedMappings() {
        return this.nameToSchemasUnmodifiable;
    }

    public Schema findSchema(String systemId) {
        systemId = Assert.assertNotNull(StringUtil.trimToNull(systemId), "systemId", new Object[0]).replaceAll("\\\\", "/");
        try {
            systemId = URI.create(systemId).normalize().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (String schemaName : this.names) {
            if (!systemId.endsWith(schemaName)) continue;
            return this.nameToSchemas.get(schemaName);
        }
        return null;
    }

    public String toString() {
        return new ToStringBuilder().append("SchemaSet").append(this.names).toString();
    }
}

