/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.citrus.turbine.util.ControlTool;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.Substitution;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ExportControlValve
extends AbstractValve {
    private static final String DEFAULT_CONTROL_TOOL_NAME = "control";
    private static final String DEFAULT_SUBSTITUTION_NAME = "subst";
    @Autowired
    private HttpServletRequest request;
    private String controlToolName;
    private String controlExporterTarget;
    private String substName;
    private String templateName;
    private String moduleName;

    public void setControlTool(String controlToolName) {
        this.controlToolName = StringUtil.trimToNull(controlToolName);
    }

    public void setControlExporterTarget(String controlExporterTarget) {
        this.controlExporterTarget = StringUtil.trimToNull(controlExporterTarget);
    }

    public void setSubst(String substName) {
        this.substName = StringUtil.trimToNull(substName);
    }

    public void setTemplate(String templateName) {
        this.templateName = StringUtil.trimToNull(templateName);
    }

    public void setModule(String moduleName) {
        this.moduleName = StringUtil.trimToNull(moduleName);
    }

    @Override
    protected void init() throws Exception {
        Assert.assertNotNull(this.controlExporterTarget, "no controlExporterTemplate specified", new Object[0]);
        Assert.assertTrue(this.templateName != null || this.moduleName != null, "neither template nor module name was specified", new Object[0]);
        this.controlToolName = ObjectUtil.defaultIfNull(this.controlToolName, DEFAULT_CONTROL_TOOL_NAME);
        this.substName = ObjectUtil.defaultIfNull(this.substName, DEFAULT_SUBSTITUTION_NAME);
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunDataInternal rundata = (TurbineRunDataInternal)TurbineUtil.getTurbineRunData(this.request);
        Substitution subst = this.getSubstitution(pipelineContext);
        String template = StringUtil.trimToNull(subst.substitute(this.templateName));
        String module = StringUtil.trimToNull(subst.substitute(this.moduleName));
        Context context = rundata.getContext();
        ControlTool controlTool = this.getControlTool(context, template, module, rundata);
        rundata.getResponse().getWriter();
        String content = controlTool.render();
        context.put("controlContent", content);
        context.put("controlTarget", template != null ? template : module);
        rundata.setRedirectTarget(this.controlExporterTarget);
        pipelineContext.invokeNext();
    }

    private Substitution getSubstitution(PipelineContext pipelineContext) {
        return Assert.assertNotNull((Substitution)pipelineContext.getAttribute(this.substName), "no Substitution exists in pipelineContext: name=%s", this.substName);
    }

    private ControlTool getControlTool(Context context, String template, String module, TurbineRunData rundata) {
        String toolName = this.controlToolName;
        Object tool = context.get(toolName);
        Assert.assertTrue(tool instanceof ControlTool, "no control tool: %s", toolName);
        ControlTool controlTool = (ControlTool)tool;
        if (template != null) {
            controlTool.setTemplate(template);
        } else if (module != null) {
            controlTool.setModule(module);
        }
        ParameterParser params = rundata.getParameters();
        block4: for (String key : params.keySet()) {
            Object[] values = params.getObjects(key);
            switch (values.length) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    controlTool.setParameter(key, values[0]);
                    continue block4;
                }
            }
            controlTool.setParameter(key, values);
        }
        return controlTool;
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<ExportControlValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "controlTool", "controlExporterTarget", ExportControlValve.DEFAULT_SUBSTITUTION_NAME, "template", "module");
        }
    }
}

