/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.webx.util.SetLoggingContextHelper;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class SetLoggingContextValve
extends AbstractValve
implements ProductionModeAware {
    public static final String MDC_PRODUCTION_MODE = "productionMode";
    @Autowired
    private HttpServletRequest request;
    private Boolean productionMode;

    @Override
    public void setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
    }

    public String getProductionModeDesc() {
        if (this.productionMode == null) {
            return "";
        }
        if (this.productionMode.booleanValue()) {
            return "Production Mode";
        }
        return "Development Mode";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        SetLoggingContextHelper helper = new SetLoggingContextHelper(this.request);
        Map<String, String> extra = Collections.singletonMap(MDC_PRODUCTION_MODE, this.getProductionModeDesc());
        try {
            helper.setLoggingContext(extra);
            pipelineContext.invokeNext();
        }
        finally {
            helper.clearLoggingContext();
        }
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<SetLoggingContextValve> {
    }
}

