/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.context;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.webx.WebxComponent;
import com.alibaba.citrus.webx.context.WebxApplicationContext;
import com.alibaba.citrus.webx.context.WebxComponentsContext;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class WebxComponentContext
extends WebxApplicationContext {
    private final WebxComponent component;

    public WebxComponentContext(WebxComponent component) {
        this.component = Assert.assertNotNull(component, "component", new Object[0]);
        WebApplicationContext parentContext = component.getWebxComponents().getParentApplicationContext();
        this.setParent((ApplicationContext)parentContext);
        if (parentContext instanceof WebxComponentsContext) {
            ((WebxComponentsContext)parentContext).setupComponentContext(this);
        }
    }

    public WebxComponent getWebxComponent() {
        return this.component;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.postProcessBeanFactory(beanFactory);
        beanFactory.registerResolvableDependency(WebxComponent.class, (Object)this.component);
    }
}

