/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.enums;

import com.baomidou.mybatisplus.enums.IEnum;
import com.baomidou.mybatisplus.toolkit.EnumUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class IEnumTypeHandler<E extends Enum<?>>
extends BaseTypeHandler<IEnum> {
    private Class<E> type;

    public IEnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, IEnum parameter, JdbcType jdbcType) throws SQLException {
        if (jdbcType == null) {
            ps.setObject(i, parameter.getValue());
        } else {
            ps.setObject(i, (Object)parameter.getValue(), jdbcType.TYPE_CODE);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        if (null == rs.getString(columnName) && rs.wasNull()) {
            return null;
        }
        return (E)EnumUtils.valueOf(this.type, (Object)rs.getObject(columnName));
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        if (null == rs.getString(columnIndex) && rs.wasNull()) {
            return null;
        }
        return (E)EnumUtils.valueOf(this.type, (Object)rs.getObject(columnIndex));
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        if (null == cs.getString(columnIndex) && cs.wasNull()) {
            return null;
        }
        return (E)EnumUtils.valueOf(this.type, (Object)cs.getObject(columnIndex));
    }
}

