/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate5;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class HibernateProxySerializer
extends JsonSerializer<HibernateProxy> {
    protected final BeanProperty _property;
    protected final boolean _forceLazyLoading;
    protected final boolean _serializeIdentifier;
    protected final Mapping _mapping;
    protected PropertySerializerMap _dynamicSerializers;

    public HibernateProxySerializer(boolean forceLazyLoading) {
        this(forceLazyLoading, false, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier) {
        this(forceLazyLoading, serializeIdentifier, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, Mapping mapping) {
        this._forceLazyLoading = forceLazyLoading;
        this._serializeIdentifier = serializeIdentifier;
        this._mapping = mapping;
        this._dynamicSerializers = PropertySerializerMap.emptyMap();
        this._property = null;
    }

    public boolean isEmpty(HibernateProxy value) {
        return value == null || this.findProxied(value) == null;
    }

    public void serialize(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serialize(proxiedValue, jgen, provider);
    }

    public void serializeWithType(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serializeWithType(proxiedValue, jgen, provider, typeSer);
    }

    protected JsonSerializer<Object> findSerializer(SerializerProvider provider, Object value) throws IOException, JsonProcessingException {
        Class<?> type = value.getClass();
        PropertySerializerMap.SerializerAndMapResult result = this._dynamicSerializers.findAndAddPrimarySerializer(type, provider, this._property);
        if (this._dynamicSerializers != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }

    protected Object findProxied(HibernateProxy proxy) {
        LazyInitializer init = proxy.getHibernateLazyInitializer();
        if (!this._forceLazyLoading && init.isUninitialized()) {
            if (this._serializeIdentifier) {
                SessionImplementor session;
                String idName = this._mapping != null ? this._mapping.getIdentifierPropertyName(init.getEntityName()) : ((session = init.getSession()) != null ? session.getFactory().getIdentifierPropertyName(init.getEntityName()) : init.getEntityName());
                Serializable idValue = init.getIdentifier();
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                map.put(idName, idValue);
                return map;
            }
            return null;
        }
        return init.getImplementation();
    }
}

