/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate5;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import java.io.IOException;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;

public class PersistentCollectionSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    protected final int _features;
    protected final JsonSerializer<Object> _serializer;
    protected final SessionFactory _sessionFactory;

    public PersistentCollectionSerializer(JsonSerializer<?> serializer, int features, SessionFactory sessionFactory) {
        this._serializer = serializer;
        this._features = features;
        this._sessionFactory = sessionFactory;
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer ser = provider.handlePrimaryContextualization(this._serializer, property);
        if (!this.usesLazyLoading(property)) {
            return ser;
        }
        if (ser != this._serializer) {
            return new PersistentCollectionSerializer(ser, this._features, this._sessionFactory);
        }
        return this;
    }

    @Deprecated
    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof PersistentCollection) {
            return this.findLazyValue((PersistentCollection)value) == null;
        }
        return this._serializer.isEmpty(value);
    }

    public boolean isEmpty(SerializerProvider provider, Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof PersistentCollection) {
            return this.findLazyValue((PersistentCollection)value) == null;
        }
        return this._serializer.isEmpty(provider, value);
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value instanceof PersistentCollection && (value = this.findLazyValue((PersistentCollection)value)) == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        if (this._serializer == null) {
            throw new JsonMappingException("PersistentCollection does not have serializer set");
        }
        this._serializer.serialize(value, jgen, provider);
    }

    public void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (value instanceof PersistentCollection && (value = this.findLazyValue((PersistentCollection)value)) == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        if (this._serializer == null) {
            throw new JsonMappingException("PersistentCollection does not have serializer set");
        }
        this._serializer.serializeWithType(value, jgen, provider, typeSer);
    }

    protected Object findLazyValue(PersistentCollection coll) {
        if (!Hibernate5Module.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !coll.wasInitialized()) {
            return null;
        }
        if (this._sessionFactory != null) {
            Session session = this.openTemporarySessionForLoading(coll);
            this.initializeCollection(coll, session);
        }
        return coll.getValue();
    }

    private Session openTemporarySessionForLoading(PersistentCollection coll) {
        SessionFactory sf = this._sessionFactory;
        Session session = sf.openSession();
        PersistenceContext persistenceContext = ((SessionImplementor)session).getPersistenceContext();
        persistenceContext.setDefaultReadOnly(true);
        session.setFlushMode(FlushMode.MANUAL);
        persistenceContext.addUninitializedDetachedCollection(((SessionFactoryImplementor)this._sessionFactory).getCollectionPersister(coll.getRole()), coll);
        return session;
    }

    private void initializeCollection(PersistentCollection coll, Session session) {
        boolean isJTA = ((SessionImplementor)session).getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta();
        if (!isJTA) {
            session.beginTransaction();
        }
        coll.setCurrentSession((SessionImplementor)session);
        Hibernate.initialize((Object)coll);
        if (!isJTA) {
            session.getTransaction().commit();
        }
        session.close();
    }

    protected boolean usesLazyLoading(BeanProperty property) {
        if (property != null) {
            ElementCollection ec = (ElementCollection)property.getAnnotation(ElementCollection.class);
            if (ec != null) {
                return ec.fetch() == FetchType.LAZY;
            }
            OneToMany ann1 = (OneToMany)property.getAnnotation(OneToMany.class);
            if (ann1 != null) {
                return ann1.fetch() == FetchType.LAZY;
            }
            OneToOne ann2 = (OneToOne)property.getAnnotation(OneToOne.class);
            if (ann2 != null) {
                return ann2.fetch() == FetchType.LAZY;
            }
            ManyToOne ann3 = (ManyToOne)property.getAnnotation(ManyToOne.class);
            if (ann3 != null) {
                return ann3.fetch() == FetchType.LAZY;
            }
            ManyToMany ann4 = (ManyToMany)property.getAnnotation(ManyToMany.class);
            if (ann4 != null) {
                return ann4.fetch() == FetchType.LAZY;
            }
            return !Hibernate5Module.Feature.REQUIRE_EXPLICIT_LAZY_LOADING_MARKER.enabledIn(this._features);
        }
        return false;
    }
}

