/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.io.PrintWriter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class BugCollectionBugReporter
extends TextUIBugReporter
implements Debug {
    private final SortedBugCollection bugCollection;
    private final Project project;
    @CheckForNull
    private final PrintWriter writer;

    public BugCollectionBugReporter(Project project) {
        this(project, null);
    }

    public BugCollectionBugReporter(Project project, @CheckForNull PrintWriter writer) {
        this.project = project;
        this.bugCollection = new SortedBugCollection(this.getProjectStats(), project);
        this.bugCollection.setTimestamp(System.currentTimeMillis());
        this.writer = writer;
    }

    public Project getProject() {
        return this.project;
    }

    @Nonnull
    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    public void logError(String message) {
        this.bugCollection.addError(message);
        super.logError(message);
    }

    public void logError(String message, Throwable e) {
        if (e instanceof MissingClassException) {
            MissingClassException e2 = (MissingClassException)e;
            this.reportMissingClass(e2.getClassNotFoundException());
            return;
        }
        if (e instanceof MethodUnprofitableException) {
            return;
        }
        this.bugCollection.addError(message, e);
        super.logError(message, e);
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        String missing = AbstractBugReporter.getMissingClassName(ex);
        if (!BugCollectionBugReporter.isValidMissingClassMessage(missing)) {
            return;
        }
        this.bugCollection.addMissingClass(missing);
        super.reportMissingClass(ex);
    }

    public void doReportBug(BugInstance bugInstance) {
        if (VERIFY_INTEGRITY) {
            this.checkBugInstance(bugInstance);
        }
        if (this.bugCollection.add(bugInstance)) {
            this.notifyObservers(bugInstance);
        }
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    public void finish() {
        this.bugCollection.bugsPopulated();
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    protected void emitLine(String line) {
        if (this.writer == null) {
            super.emitLine(line);
            return;
        }
        line = line.replaceAll("\t", "  ");
        this.writer.println(line);
    }
}

