/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.charsets.UserTextFile;
import edu.umd.cs.findbugs.cloud.Cloud;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineUiCallback
implements IGuiCallback {
    private final CurrentThreadExecutorService bugUpdateExecutor = new CurrentThreadExecutorService();
    BufferedReader br = UserTextFile.bufferedReader(System.in);

    @Override
    public void showMessageDialogAndWait(String message) throws InterruptedException {
        System.out.println(message);
    }

    @Override
    public void showMessageDialog(String message) {
        System.out.println(message);
    }

    @Override
    public int showConfirmDialog(String message, String title, String ok, String cancel) {
        int response;
        String confirmStr = "Yes (Y) or No (N)?";
        System.out.println(String.format("Confirmation required: %s%n\t%s%n\t%s", title, message, confirmStr));
        String answer = null;
        while (true) {
            try {
                answer = this.br.readLine();
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("IO error trying to read System.in!");
            }
            response = this.parseAnswer(answer);
            if (response >= 0) break;
            System.out.println(String.format("\t%s", confirmStr));
        }
        return response;
    }

    private int parseAnswer(String answer) {
        if (null == answer || answer.length() == 0) {
            System.out.println("You entered an empty string");
            return -1;
        }
        char option = answer.toLowerCase(Locale.ENGLISH).charAt(0);
        switch (option) {
            case 'o': {
                return 0;
            }
            case 'y': {
                return 0;
            }
            case 'n': {
                return 1;
            }
            case 'c': {
                return 2;
            }
        }
        System.out.println("You entered '" + option + "'");
        return -1;
    }

    @Override
    public InputStream getProgressMonitorInputStream(InputStream in, int length, String msg) {
        return in;
    }

    @Override
    public void setErrorMessage(String errorMsg) {
        System.err.println(errorMsg);
    }

    @Override
    public void displayNonmodelMessage(String title, String message) {
        System.out.println(String.format("Message: %s%n%s", title, message));
    }

    @Override
    public String showQuestionDialog(String message, String title, String defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> showForm(String message, String title, List<IGuiCallback.FormItem> labels) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean showDocument(URL u) {
        return false;
    }

    @Override
    public void registerCloud(Project project, BugCollection collection, Cloud cloud) {
    }

    @Override
    public ExecutorService getBugUpdateExecutor() {
        return this.bugUpdateExecutor;
    }

    @Override
    public boolean isHeadless() {
        return true;
    }

    @Override
    public void unregisterCloud(Project project, BugCollection collection, Cloud cloud) {
    }

    @Override
    public void invokeInGUIThread(Runnable r) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurrentThreadExecutorService
    extends AbstractExecutorService {
        private CurrentThreadExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

