/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.ComponentPlugin;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.InterproceduralFirstPassDetector;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginDoesntContainMetadataException;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.PropertyBundle;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.classfile.IAnalysisEngineRegistrar;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.CloudFactory;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.cloud.CloudPluginBuilder;
import edu.umd.cs.findbugs.cloud.username.NameLookup;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.plan.ByInterfaceDetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorOrderingConstraint;
import edu.umd.cs.findbugs.plan.ReportingDetectorFactorySelector;
import edu.umd.cs.findbugs.plan.SingleDetectorFactorySelector;
import edu.umd.cs.findbugs.plugins.DuplicatePluginIdError;
import edu.umd.cs.findbugs.plugins.DuplicatePluginIdException;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.JavaWebStart;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private static final String XPATH_PLUGIN_SHORT_DESCRIPTION = "/MessageCollection/Plugin/ShortDescription";
    private static final String XPATH_PLUGIN_WEBSITE = "/FindbugsPlugin/@website";
    private static final String XPATH_PLUGIN_PROVIDER = "/FindbugsPlugin/@provider";
    private static final String XPATH_PLUGIN_PLUGINID = "/FindbugsPlugin/@pluginid";
    private static final boolean DEBUG = SystemProperties.getBoolean("findbugs.debug.PluginLoader");
    private final ClassLoader classLoader;
    private final ClassLoader classLoaderForResources;
    private static int nextUnknownId;
    private Plugin plugin;
    private final boolean corePlugin;
    boolean initialPlugin;
    boolean cannotDisable;
    private boolean optionalPlugin;
    private final URL loadedFrom;
    private final String jarName;
    private final URI loadedFromUri;
    static HashSet<String> loadedPluginIds;

    @Deprecated
    public PluginLoader(URL url) throws PluginException {
        this(url, PluginLoader.toUri(url), null, false, true);
    }

    @Deprecated
    public PluginLoader(URL url, ClassLoader parent) throws PluginException {
        this(url, PluginLoader.toUri(url), parent, false, true);
    }

    private PluginLoader(@Nonnull URL url, URI uri, ClassLoader parent, boolean isInitial, boolean optional) throws PluginException {
        URL[] loaderURLs = this.createClassloaderUrls(url);
        this.classLoader = new URLClassLoader(loaderURLs, parent);
        this.classLoaderForResources = new URLClassLoader(loaderURLs);
        this.loadedFrom = url;
        this.loadedFromUri = uri;
        this.jarName = this.getJarName(url);
        this.corePlugin = false;
        this.initialPlugin = isInitial;
        this.optionalPlugin = optional;
        this.plugin = this.init();
        Plugin.putPlugin(this.loadedFromUri, this.plugin);
    }

    @Nonnull
    private URL[] createClassloaderUrls(@Nonnull URL url) throws PluginException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(url);
        JarInputStream jis = null;
        try {
            String classPath;
            jis = new JarInputStream(url.openStream());
            Manifest mf = jis.getManifest();
            if (mf == null) {
                URL[] uRLArray = urls.toArray(new URL[urls.size()]);
                return uRLArray;
            }
            Attributes atts = mf.getMainAttributes();
            if (atts != null && (classPath = atts.getValue(Attributes.Name.CLASS_PATH)) != null) {
                String[] jars;
                String jarRoot = url.toString();
                jarRoot = jarRoot.substring(0, jarRoot.lastIndexOf("/") + 1);
                for (String jar : jars = classPath.split(",")) {
                    jar = jarRoot + jar.trim();
                    urls.add(new URL(jar));
                }
            }
        }
        catch (IOException ioe) {
            throw new PluginException("Failed loading manifest for plugin jar: " + url, ioe);
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    @Deprecated
    public PluginLoader() throws PluginException {
        this.classLoaderForResources = this.classLoader = this.getClass().getClassLoader();
        this.corePlugin = true;
        this.initialPlugin = true;
        this.optionalPlugin = false;
        this.loadedFrom = this.computeCoreUrl();
        try {
            this.loadedFromUri = this.loadedFrom.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse uri: " + this.loadedFrom);
        }
        this.jarName = this.getJarName(this.loadedFrom);
        this.plugin = this.init();
        Plugin.putPlugin(null, this.plugin);
    }

    @Deprecated
    public PluginLoader(boolean fake, URL url) throws PluginException {
        this.classLoaderForResources = this.classLoader = this.getClass().getClassLoader();
        this.corePlugin = false;
        this.initialPlugin = true;
        this.optionalPlugin = false;
        this.loadedFrom = url;
        try {
            this.loadedFromUri = this.loadedFrom.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse uri: " + this.loadedFrom);
        }
        this.jarName = this.getJarName(this.loadedFrom);
    }

    private URL computeCoreUrl() {
        URL from;
        block7: {
            String findBugsClassFile = ClassName.toSlashedClassName(FindBugs.class) + ".class";
            URL me = FindBugs.class.getClassLoader().getResource(findBugsClassFile);
            if (DEBUG) {
                System.out.println("FindBugs.class loaded from " + me);
            }
            if (me == null) {
                throw new IllegalStateException("Failed to load " + findBugsClassFile);
            }
            try {
                String u = me.toString();
                if (u.startsWith("jar:") && u.endsWith("!/" + findBugsClassFile)) {
                    u = u.substring(4, u.indexOf("!/"));
                    from = new URL(u);
                    break block7;
                }
                if (u.endsWith(findBugsClassFile)) {
                    u = u.substring(0, u.indexOf(findBugsClassFile));
                    from = new URL(u);
                    break block7;
                }
                throw new IllegalArgumentException("Unknown url shema: " + u);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to parse url: " + me);
            }
        }
        if (DEBUG) {
            System.out.println("Core class files loaded from " + from);
        }
        return from;
    }

    public URL getURL() {
        return this.loadedFrom;
    }

    public URI getURI() {
        return this.loadedFromUri;
    }

    private static URI toUri(URL url) throws PluginException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new PluginException("Bad uri: " + url, e);
        }
    }

    private String getJarName(URL url) {
        String location = url.getPath();
        int i = location.lastIndexOf("/");
        location = location.substring(i + 1);
        return location;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Plugin loadPlugin() throws PluginException {
        return this.getPlugin();
    }

    public Plugin getPlugin() {
        if (this.plugin == null) {
            throw new AssertionError((Object)"plugin not already loaded");
        }
        return this.plugin;
    }

    private static URL resourceFromPlugin(URL u, String args) throws MalformedURLException {
        String path = u.getPath();
        if (path.endsWith(".zip") || path.endsWith(".jar")) {
            return new URL("jar:" + u.toString() + "!/" + args);
        }
        if (path.endsWith("/")) {
            return new URL(u.toString() + args);
        }
        return new URL(u.toString() + "/" + args);
    }

    public URL getResource(String name) {
        URL url;
        if (this.isCorePlugin() && (url = PluginLoader.getCoreResource(name)) != null && IO.verifyURL(url)) {
            return url;
        }
        if (this.loadedFrom != null) {
            try {
                url = PluginLoader.resourceFromPlugin(this.loadedFrom, name);
                if (DEBUG) {
                    System.out.println("Trying to load " + name + " from " + url);
                }
                if (IO.verifyURL(url)) {
                    return url;
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (this.classLoaderForResources instanceof URLClassLoader) {
            URL url2;
            URLClassLoader urlClassLoader = (URLClassLoader)this.classLoaderForResources;
            if (DEBUG) {
                System.out.println("Trying to load " + name + " using URLClassLoader.findResource");
                System.out.println("  from urls: " + Arrays.asList(urlClassLoader.getURLs()));
            }
            if ((url2 = urlClassLoader.findResource(name)) == null) {
                url2 = urlClassLoader.findResource("/" + name);
            }
            if (IO.verifyURL(url2)) {
                return url2;
            }
        }
        if (DEBUG) {
            System.out.println("Trying to load " + name + " using ClassLoader.getResource");
        }
        if ((url = this.classLoaderForResources.getResource(name)) == null) {
            url = this.classLoaderForResources.getResource("/" + name);
        }
        if (IO.verifyURL(url)) {
            return url;
        }
        return null;
    }

    @CheckForNull
    static URL getCoreResource(String name) {
        URL u = PluginLoader.loadFromFindBugsPluginDir(name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.loadFromFindBugsEtcDir(name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.class.getResource(name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.class.getResource("/" + name);
        return u;
    }

    @CheckForNull
    public static URL loadFromFindBugsEtcDir(String name) {
        File f;
        String findBugsHome = DetectorFactoryCollection.getFindBugsHome();
        if (findBugsHome != null && (f = new File(new File(new File(findBugsHome), "etc"), name)).canRead()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    public static URL loadFromFindBugsPluginDir(String name) {
        File f;
        String findBugsHome = DetectorFactoryCollection.getFindBugsHome();
        if (findBugsHome != null && (f = new File(new File(new File(findBugsHome), "plugin"), name)).canRead()) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static <T> Class<? extends T> getClass(ClassLoader loader, String className, Class<T> type) throws PluginException {
        try {
            return loader.loadClass(className).asSubclass(type);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Unable to load " + className, e);
        }
        catch (ClassCastException e) {
            throw new PluginException("Cannot cast " + className + " to " + type.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Plugin init() throws PluginException {
        Iterator i$;
        String details;
        boolean disabled;
        String propertiesLocation;
        String updateUrl;
        String website;
        Document pluginDescriptor;
        String name;
        URL findbugsXML_URL;
        if (DEBUG) {
            System.out.println("Loading plugin from " + this.loadedFrom);
        }
        if ((findbugsXML_URL = this.getResource(name = "findbugs.xml")) == null) {
            throw new PluginException("Couldn't find \"" + name + "\" in plugin");
        }
        if (DEBUG) {
            System.out.println("PluginLoader found " + name + " at: " + findbugsXML_URL);
        }
        if (!(this.jarName == null || findbugsXML_URL.toString().contains(this.jarName) || this.corePlugin && findbugsXML_URL.toString().endsWith("etc/findbugs.xml"))) {
            String string;
            String classloaderName = this.classLoader.getClass().getName();
            if (this.classLoader instanceof URLClassLoader) {
                classloaderName = classloaderName + Arrays.asList(((URLClassLoader)this.classLoader).getURLs());
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.corePlugin) {
                string = "Core plugin";
                throw new PluginDoesntContainMetadataException(stringBuilder.append(string).append(this.jarName).append(" doesn't contain findbugs.xml; got ").append(findbugsXML_URL).append(" from ").append(classloaderName).toString());
            }
            string = "Plugin ";
            throw new PluginDoesntContainMetadataException(stringBuilder.append(string).append(this.jarName).append(" doesn't contain findbugs.xml; got ").append(findbugsXML_URL).append(" from ").append(classloaderName).toString());
        }
        SAXReader reader = new SAXReader();
        try {
            BufferedReader r = UTF8.bufferedReader(findbugsXML_URL.openStream());
            pluginDescriptor = reader.read((Reader)r);
        }
        catch (DocumentException e) {
            throw new PluginException("Couldn't parse \"" + findbugsXML_URL + "\" using " + reader.getClass().getName(), e);
        }
        catch (IOException e) {
            throw new PluginException("Couldn't open \"" + findbugsXML_URL + "\"", e);
        }
        String pluginId = pluginDescriptor.valueOf(XPATH_PLUGIN_PLUGINID);
        if (pluginId.equals("")) {
            Class<PluginLoader> e = PluginLoader.class;
            // MONITORENTER : edu.umd.cs.findbugs.PluginLoader.class
            pluginId = "plugin" + nextUnknownId++;
            // MONITOREXIT : e
        }
        this.cannotDisable = Boolean.parseBoolean(pluginDescriptor.valueOf("/FindbugsPlugin/@cannotDisable"));
        String de = pluginDescriptor.valueOf("/FindbugsPlugin/@defaultenabled");
        if (de != null && de.toLowerCase().trim().equals("false")) {
            this.optionalPlugin = true;
        }
        if (this.optionalPlugin) {
            this.cannotDisable = false;
        }
        if (!loadedPluginIds.add(pluginId)) {
            Plugin existingPlugin = Plugin.getByPluginId(pluginId);
            URL u = existingPlugin == null ? null : existingPlugin.getPluginLoader().getURL();
            if (!this.cannotDisable) throw new DuplicatePluginIdException(pluginId, this.loadedFrom, u);
            if (!this.initialPlugin) throw new DuplicatePluginIdException(pluginId, this.loadedFrom, u);
            throw new DuplicatePluginIdError(pluginId, this.loadedFrom, u);
        }
        String version = pluginDescriptor.valueOf("/FindbugsPlugin/@version");
        String releaseDate = pluginDescriptor.valueOf("/FindbugsPlugin/@releaseDate");
        List<Document> messageCollectionList = this.getMessageDocuments();
        if ((releaseDate == null || releaseDate.length() == 0) && this.isCorePlugin()) {
            releaseDate = Version.CORE_PLUGIN_RELEASE_DATE;
        }
        Date parsedDate = this.parseDate(releaseDate);
        Plugin plugin = new Plugin(pluginId, version, parsedDate, this, !this.optionalPlugin, this.cannotDisable);
        String provider = pluginDescriptor.valueOf(XPATH_PLUGIN_PROVIDER).trim();
        if (!provider.equals("")) {
            plugin.setProvider(provider);
        }
        if (!(website = pluginDescriptor.valueOf(XPATH_PLUGIN_WEBSITE).trim()).equals("")) {
            try {
                plugin.setWebsite(website);
            }
            catch (URISyntaxException e1) {
                AnalysisContext.logError("Plugin " + pluginId + " has invalid website: " + website, e1);
            }
        }
        if (!(updateUrl = pluginDescriptor.valueOf("/FindbugsPlugin/@update-url").trim()).equals("")) {
            try {
                plugin.setUpdateUrl(updateUrl);
            }
            catch (URISyntaxException e1) {
                AnalysisContext.logError("Plugin " + pluginId + " has invalid update check URL: " + website, e1);
            }
        }
        Node pluginShortDesc = null;
        try {
            pluginShortDesc = PluginLoader.findMessageNode(messageCollectionList, XPATH_PLUGIN_SHORT_DESCRIPTION, "no plugin description");
        }
        catch (PluginException e) {
            // empty catch block
        }
        if (pluginShortDesc != null) {
            plugin.setShortDescription(pluginShortDesc.getText().trim());
        }
        Node detailedDescription = null;
        try {
            detailedDescription = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/Plugin/Details", "no plugin description");
        }
        catch (PluginException e) {
            // empty catch block
        }
        if (detailedDescription != null) {
            plugin.setDetailedDescription(detailedDescription.getText().trim());
        }
        List globalOptionNodes = pluginDescriptor.selectNodes("/FindbugsPlugin/GlobalOptions/Property");
        for (Node optionNode : globalOptionNodes) {
            String key = optionNode.valueOf("@key");
            String value = optionNode.getText().trim();
            plugin.setMyGlobalOption(key, value);
        }
        List cloudNodeList = pluginDescriptor.selectNodes("/FindbugsPlugin/Cloud");
        for (Node cloudNode : cloudNodeList) {
            String cloudClassname = cloudNode.valueOf("@cloudClass");
            String cloudId = cloudNode.valueOf("@id");
            String usernameClassname = cloudNode.valueOf("@usernameClass");
            boolean onlineStorage = Boolean.valueOf(cloudNode.valueOf("@onlineStorage"));
            propertiesLocation = cloudNode.valueOf("@properties");
            disabled = Boolean.valueOf(cloudNode.valueOf("@disabled")) != false && !cloudId.equals(CloudFactory.DEFAULT_CLOUD);
            if (disabled) continue;
            boolean hidden = Boolean.valueOf(cloudNode.valueOf("@hidden")) != false && !cloudId.equals(CloudFactory.DEFAULT_CLOUD);
            Class<Cloud> cloudClass = PluginLoader.getClass(this.classLoader, cloudClassname, Cloud.class);
            Class<NameLookup> usernameClass = PluginLoader.getClass(this.classLoader, usernameClassname, NameLookup.class);
            Node cloudMessageNode = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/Cloud[@id='" + cloudId + "']", "Missing Cloud description for cloud " + cloudId);
            String description = PluginLoader.getChildText(cloudMessageNode, "Description").trim();
            String details2 = PluginLoader.getChildText(cloudMessageNode, "Details").trim();
            PropertyBundle properties = new PropertyBundle();
            if (propertiesLocation != null && propertiesLocation.length() > 0) {
                URL properiesURL = this.classLoader.getResource(propertiesLocation);
                if (properiesURL == null) continue;
                properties.loadPropertiesFromURL(properiesURL);
            }
            List propertyNodes = cloudNode.selectNodes("Property");
            for (Node node : propertyNodes) {
                String key = node.valueOf("@key");
                String value = node.getText().trim();
                properties.setProperty(key, value);
            }
            CloudPlugin cloudPlugin = new CloudPluginBuilder().setFindbugsPluginId(pluginId).setCloudid(cloudId).setClassLoader(this.classLoader).setCloudClass(cloudClass).setUsernameClass(usernameClass).setHidden(hidden).setProperties(properties).setDescription(description).setDetails(details2).setOnlineStorage(onlineStorage).createCloudPlugin();
            plugin.addCloudPlugin(cloudPlugin);
        }
        try {
            String description;
            List componentNodeList = pluginDescriptor.selectNodes("/FindbugsPlugin/PluginComponent");
            for (Node componentNode : componentNodeList) {
                String componentKindname = componentNode.valueOf("@componentKind");
                if (componentKindname == null) {
                    throw new PluginException("Missing @componentKind for " + pluginId + " loaded from " + this.loadedFrom);
                }
                String componentClassname = componentNode.valueOf("@componentClass");
                if (componentClassname == null) {
                    throw new PluginException("Missing @componentClassname for " + pluginId + " loaded from " + this.loadedFrom);
                }
                String componentId = componentNode.valueOf("@id");
                if (componentId == null) {
                    throw new PluginException("Missing @id for " + pluginId + " loaded from " + this.loadedFrom);
                }
                try {
                    propertiesLocation = componentNode.valueOf("@properties");
                    disabled = Boolean.valueOf(componentNode.valueOf("@disabled"));
                    Node filterMessageNode = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/PluginComponent[@id='" + componentId + "']", "Missing Cloud description for PluginComponent " + componentId);
                    description = PluginLoader.getChildText(filterMessageNode, "Description").trim();
                    details = PluginLoader.getChildText(filterMessageNode, "Details").trim();
                    PropertyBundle properties = new PropertyBundle();
                    if (propertiesLocation != null && propertiesLocation.length() > 0) {
                        URL properiesURL = this.classLoaderForResources.getResource(propertiesLocation);
                        if (properiesURL == null) {
                            AnalysisContext.logError("Could not load properties for " + pluginId + " component " + componentId + " from " + propertiesLocation);
                            continue;
                        }
                        properties.loadPropertiesFromURL(properiesURL);
                    }
                    List propertyNodes = componentNode.selectNodes("Property");
                    for (Node node : propertyNodes) {
                        String key = node.valueOf("@key");
                        String value = node.getText();
                        properties.setProperty(key, value);
                    }
                    Class<?> componentKind = this.classLoader.loadClass(componentKindname);
                    this.loadComponentPlugin(plugin, componentKind, componentClassname, componentId, disabled, description, details, properties);
                }
                catch (RuntimeException e) {
                    AnalysisContext.logError("Unable to load ComponentPlugin " + componentId + " : " + componentClassname + " implementing " + componentKindname, e);
                }
            }
            List findBugsMainList = pluginDescriptor.selectNodes("/FindbugsPlugin/FindBugsMain");
            for (Node main : findBugsMainList) {
                String className = main.valueOf("@class");
                if (className == null) {
                    throw new PluginException("Missing @class for FindBugsMain in plugin" + pluginId + " loaded from " + this.loadedFrom);
                }
                String cmd = main.valueOf("@cmd");
                if (cmd == null) {
                    throw new PluginException("Missing @cmd for for FindBugsMain in plugin " + pluginId + " loaded from " + this.loadedFrom);
                }
                String kind = main.valueOf("@kind");
                boolean analysis = Boolean.valueOf(main.valueOf("@analysis"));
                Element mainMessageNode = (Element)PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/FindBugsMain[@cmd='" + cmd + "']/Description", "Missing FindBugsMain description for cmd " + cmd);
                description = mainMessageNode.getTextTrim();
                try {
                    Class<?> mainClass = this.classLoader.loadClass(className);
                    plugin.addFindBugsMain(mainClass, cmd, description, kind, analysis);
                }
                catch (Exception e) {
                    AnalysisContext.logError("Unable to load FindBugsMain " + cmd + " : " + className + " in plugin " + pluginId + " loaded from " + this.loadedFrom, e);
                }
            }
            List detectorNodeList = pluginDescriptor.selectNodes("/FindbugsPlugin/Detector");
            int detectorCount = 0;
            for (Node detectorNode : detectorNodeList) {
                Node node;
                String className = detectorNode.valueOf("@class");
                String speed = detectorNode.valueOf("@speed");
                String disabled2 = detectorNode.valueOf("@disabled");
                String reports = detectorNode.valueOf("@reports");
                String requireJRE = detectorNode.valueOf("@requirejre");
                String hidden = detectorNode.valueOf("@hidden");
                if (speed == null || speed.length() == 0) {
                    speed = "fast";
                }
                Class<?> detectorClass = null;
                if (!(FindBugs.noAnalysis || Detector.class.isAssignableFrom(detectorClass = this.classLoader.loadClass(className)) || Detector2.class.isAssignableFrom(detectorClass))) {
                    throw new PluginException("Class " + className + " does not implement Detector or Detector2");
                }
                DetectorFactory factory = new DetectorFactory(plugin, className, detectorClass, !disabled2.equals("true"), speed, reports, requireJRE);
                if (Boolean.valueOf(hidden).booleanValue()) {
                    factory.setHidden(true);
                }
                factory.setPositionSpecifiedInPluginDescriptor(detectorCount++);
                plugin.addDetectorFactory(factory);
                node = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/Detector[@class='" + className + "']/Details", "Missing Detector description for detector " + className);
                Element details3 = (Element)node;
                String detailHTML = details3.getText();
                StringBuilder buf = new StringBuilder();
                buf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
                buf.append("<HTML><HEAD><TITLE>Detector Description</TITLE></HEAD><BODY>\n");
                buf.append(detailHTML);
                buf.append("</BODY></HTML>\n");
                factory.setDetailHTML(buf.toString());
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Could not instantiate detector class: " + e, e);
        }
        Node orderingConstraintsNode = pluginDescriptor.selectSingleNode("/FindbugsPlugin/OrderingConstraints");
        if (orderingConstraintsNode != null) {
            for (Element constraintElement : orderingConstraintsNode.selectNodes("./SplitPass|./WithinPass")) {
                DetectorFactorySelector earlierSelector = PluginLoader.getConstraintSelector(constraintElement, plugin, "Earlier");
                DetectorFactorySelector laterSelector = PluginLoader.getConstraintSelector(constraintElement, plugin, "Later");
                DetectorOrderingConstraint constraint = new DetectorOrderingConstraint(earlierSelector, laterSelector);
                constraint.setSingleSource(earlierSelector instanceof SingleDetectorFactorySelector);
                if (constraintElement.getName().equals("SplitPass")) {
                    plugin.addInterPassOrderingConstraint(constraint);
                    continue;
                }
                plugin.addIntraPassOrderingConstraint(constraint);
            }
        }
        List categoryNodeListGlobal = pluginDescriptor.selectNodes("/FindbugsPlugin/BugCategory");
        for (Node categoryNode : categoryNodeListGlobal) {
            String key = categoryNode.valueOf("@category");
            if (key.equals("")) {
                throw new PluginException("BugCategory element with missing category attribute");
            }
            BugCategory bc = plugin.addOrCreateBugCategory(key);
            boolean hidden = Boolean.valueOf(categoryNode.valueOf("@hidden"));
            if (!hidden) continue;
            bc.setHidden(hidden);
        }
        Iterator<Object> i$2 = messageCollectionList.iterator();
        block42: while (true) {
            List categoryNodeList;
            if (i$2.hasNext()) {
                Document messageCollection = (Document)i$2.next();
                categoryNodeList = messageCollection.selectNodes("/MessageCollection/BugCategory");
                if (DEBUG) {
                    System.out.println("found " + categoryNodeList.size() + " categories in " + pluginId);
                }
            } else {
                List bugPatternNodeList = pluginDescriptor.selectNodes("/FindbugsPlugin/BugPattern");
                i$ = bugPatternNodeList.iterator();
                break;
            }
            Iterator i$3 = categoryNodeList.iterator();
            while (true) {
                BugCategory bc;
                String key;
                Node categoryNode;
                block94: {
                    if (!i$3.hasNext()) continue block42;
                    categoryNode = (Node)i$3.next();
                    key = categoryNode.valueOf("@category");
                    if (key.equals("")) {
                        throw new PluginException("BugCategory element with missing category attribute");
                    }
                    bc = plugin.addOrCreateBugCategory(key);
                    String shortDesc = PluginLoader.getChildText(categoryNode, "Description");
                    bc.setShortDescription(shortDesc);
                    try {
                        String abbrev = PluginLoader.getChildText(categoryNode, "Abbreviation");
                        if (bc.getAbbrev() == null) {
                            bc.setAbbrev(abbrev);
                            if (DEBUG) {
                                System.out.println("category " + key + " abbrev -> " + abbrev);
                            }
                            break block94;
                        }
                        if (DEBUG) {
                            System.out.println("rejected abbrev '" + abbrev + "' for category " + key + ": " + bc.getAbbrev());
                        }
                    }
                    catch (PluginException pe) {
                        if (!DEBUG) break block94;
                        System.out.println("missing Abbreviation for category " + key + "/" + shortDesc);
                    }
                }
                try {
                    details = PluginLoader.getChildText(categoryNode, "Details");
                    if (bc.getDetailText() == null) {
                        bc.setDetailText(details);
                        if (!DEBUG) continue;
                        System.out.println("category " + key + " details -> " + details);
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.out.println("rejected details [" + details + "] for category " + key + ": [" + bc.getDetailText() + ']');
                }
                catch (PluginException pe) {}
            }
            break;
        }
        while (i$.hasNext()) {
            Node bugPatternNode = (Node)i$.next();
            String type = bugPatternNode.valueOf("@type");
            String abbrev = bugPatternNode.valueOf("@abbrev");
            String category = bugPatternNode.valueOf("@category");
            String experimental = bugPatternNode.valueOf("@experimental");
            String query = "/MessageCollection/BugPattern[@type='" + type + "']";
            Node messageNode = PluginLoader.findMessageNode(messageCollectionList, query, "messages.xml missing BugPattern element for type " + type);
            String shortDesc = PluginLoader.getChildText(messageNode, "ShortDescription");
            String longDesc = PluginLoader.getChildText(messageNode, "LongDescription");
            String detailText = PluginLoader.getChildText(messageNode, "Details");
            int cweid = 0;
            try {
                String cweString = bugPatternNode.valueOf("@cweid");
                if (cweString.length() > 0) {
                    cweid = Integer.parseInt(cweString);
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            BugPattern bugPattern = new BugPattern(type, abbrev, category, Boolean.valueOf(experimental), shortDesc, longDesc, detailText, cweid);
            try {
                boolean deprecated;
                String deprecatedStr = bugPatternNode.valueOf("@deprecated");
                boolean bl = deprecated = deprecatedStr.length() > 0 && Boolean.valueOf(deprecatedStr) != false;
                if (deprecated) {
                    bugPattern.setDeprecated(deprecated);
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            plugin.addBugPattern(bugPattern);
        }
        HashSet<String> definedBugCodes = new HashSet<String>();
        Iterator<Object> i$4 = messageCollectionList.iterator();
        block45: while (true) {
            if (!i$4.hasNext()) {
                Node node = pluginDescriptor.selectSingleNode("/FindbugsPlugin/EngineRegistrar");
                if (node != null) {
                    String engineClassName = node.valueOf("@class");
                    if (engineClassName == null) {
                        throw new PluginException("EngineRegistrar element with missing class attribute");
                    }
                    try {
                        Class<?> engineRegistrarClass = this.classLoader.loadClass(engineClassName);
                        if (!IAnalysisEngineRegistrar.class.isAssignableFrom(engineRegistrarClass)) {
                            throw new PluginException(engineRegistrarClass + " does not implement IAnalysisEngineRegistrar");
                        }
                        plugin.setEngineRegistrarClass(engineRegistrarClass.asSubclass(IAnalysisEngineRegistrar.class));
                    }
                    catch (ClassNotFoundException e) {
                        throw new PluginException("Could not instantiate analysis engine registrar class: " + e, e);
                    }
                }
                try {
                    URL bugRankURL = this.getResource("bugrank.txt");
                    if (bugRankURL == null && DEBUG) {
                        System.out.println("No bugrank.txt for plugin " + pluginId);
                    }
                    BugRanker ranker = new BugRanker(bugRankURL);
                    plugin.setBugRanker(ranker);
                }
                catch (IOException e) {
                    throw new PluginException("Couldn't parse \"bugrank.txt\"", e);
                }
                if (!DEBUG) return plugin;
                System.out.println("Loaded " + plugin.getPluginId() + " from " + this.loadedFrom);
                return plugin;
            }
            Document messageCollection = (Document)i$4.next();
            List bugCodeNodeList = messageCollection.selectNodes("/MessageCollection/BugCode");
            Iterator i$5 = bugCodeNodeList.iterator();
            while (true) {
                if (!i$5.hasNext()) continue block45;
                Node bugCodeNode = (Node)i$5.next();
                String abbrev = bugCodeNode.valueOf("@abbrev");
                if (abbrev.equals("")) {
                    throw new PluginException("BugCode element with missing abbrev attribute");
                }
                if (definedBugCodes.contains(abbrev)) continue;
                String description = bugCodeNode.getText();
                String query = "/FindbugsPlugin/BugCode[@abbrev='" + abbrev + "']";
                Node fbNode = pluginDescriptor.selectSingleNode(query);
                int cweid = 0;
                if (fbNode != null) {
                    try {
                        cweid = Integer.parseInt(fbNode.valueOf("@cweid"));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                BugCode bugCode = new BugCode(abbrev, description, cweid);
                plugin.addBugCode(bugCode);
                definedBugCodes.add(abbrev);
            }
            break;
        }
    }

    private static List<String> getPotentialMessageFiles() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        ArrayList<String> potential = new ArrayList<String>(3);
        if (country != null) {
            potential.add("messages_" + language + "_" + country + ".xml");
        }
        potential.add("messages_" + language + ".xml");
        potential.add("messages.xml");
        return potential;
    }

    private List<Document> getMessageDocuments() throws PluginException {
        ArrayList<Document> messageCollectionList = new ArrayList<Document>();
        PluginException caught = null;
        for (String m : PluginLoader.getPotentialMessageFiles()) {
            try {
                this.addCollection(messageCollectionList, m);
            }
            catch (PluginException e) {
                caught = e;
                AnalysisContext.logError("Error loading localized message file:" + m, e);
            }
        }
        if (messageCollectionList.isEmpty()) {
            if (caught != null) {
                throw caught;
            }
            throw new PluginException("No message.xml files found");
        }
        return messageCollectionList;
    }

    private <T> void loadComponentPlugin(Plugin plugin, Class<T> componentKind, String componentClassname, String filterId, boolean disabled, String description, String details, PropertyBundle properties) throws PluginException {
        Class<T> componentClass = null;
        if (!FindBugs.noAnalysis) {
            componentClass = PluginLoader.getClass(this.classLoader, componentClassname, componentKind);
        }
        ComponentPlugin<T> componentPlugin = new ComponentPlugin<T>(plugin, filterId, this.classLoader, componentClass, properties, !disabled, description, details);
        plugin.addComponentPlugin(componentKind, componentPlugin);
    }

    private Date parseDate(String releaseDate) {
        if (releaseDate == null || releaseDate.length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat releaseDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm aa z");
            Date result = releaseDateFormat.parse(releaseDate);
            return result;
        }
        catch (ParseException e) {
            AnalysisContext.logError("unable to parse date " + releaseDate, e);
            return null;
        }
    }

    private static DetectorFactorySelector getConstraintSelector(Element constraintElement, Plugin plugin, String singleDetectorElementName) throws PluginException {
        boolean spanPlugins;
        Node node = constraintElement.selectSingleNode("./" + singleDetectorElementName);
        if (node != null) {
            String detectorClass = node.valueOf("@class");
            return new SingleDetectorFactorySelector(plugin, detectorClass);
        }
        node = constraintElement.selectSingleNode("./" + singleDetectorElementName + "Category");
        if (node != null) {
            spanPlugins = Boolean.valueOf(node.valueOf("@spanplugins"));
            String categoryName = node.valueOf("@name");
            if (!categoryName.equals("")) {
                if (categoryName.equals("reporting")) {
                    return new ReportingDetectorFactorySelector(spanPlugins ? null : plugin);
                }
                if (categoryName.equals("training")) {
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, TrainingDetector.class);
                }
                if (categoryName.equals("interprocedural")) {
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, InterproceduralFirstPassDetector.class);
                }
                throw new PluginException("Invalid category name " + categoryName + " in constraint selector node");
            }
        }
        if ((node = constraintElement.selectSingleNode("./" + singleDetectorElementName + "Subtypes")) != null) {
            spanPlugins = Boolean.valueOf(node.valueOf("@spanplugins"));
            String superName = node.valueOf("@super");
            if (!superName.equals("")) {
                try {
                    Class<?> superClass = Class.forName(superName);
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, superClass);
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException("Unknown class " + superName + " in constraint selector node");
                }
            }
        }
        throw new PluginException("Invalid constraint selector node");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCollection(List<Document> messageCollectionList, String filename) throws PluginException {
        URL messageURL = this.getResource(filename);
        if (messageURL != null) {
            SAXReader reader = new SAXReader();
            try {
                Document messageCollection;
                BufferedReader stream = UTF8.bufferedReader(messageURL.openStream());
                try {
                    messageCollection = reader.read((Reader)stream);
                }
                finally {
                    ((Reader)stream).close();
                }
                messageCollectionList.add(messageCollection);
            }
            catch (Exception e) {
                throw new PluginException("Couldn't parse \"" + messageURL + "\"", e);
            }
        }
    }

    private static Node findMessageNode(List<Document> messageCollectionList, String xpath, String missingMsg) throws PluginException {
        for (Document document : messageCollectionList) {
            Node node = document.selectSingleNode(xpath);
            if (node == null) continue;
            return node;
        }
        throw new PluginException(missingMsg);
    }

    private static String findMessageText(List<Document> messageCollectionList, String xpath, String missingMsg) {
        for (Document document : messageCollectionList) {
            Node node = document.selectSingleNode(xpath);
            if (node == null) continue;
            return node.getText().trim();
        }
        return missingMsg;
    }

    private static String getChildText(Node node, String childName) throws PluginException {
        Node child = node.selectSingleNode(childName);
        if (child == null) {
            throw new PluginException("Could not find child \"" + childName + "\" for node");
        }
        return child.getText();
    }

    public static PluginLoader getPluginLoader(URL url, ClassLoader parent, boolean isInitial, boolean optional) throws PluginException {
        URI uri = PluginLoader.toUri(url);
        Plugin plugin = Plugin.getPlugin(uri);
        if (plugin != null) {
            PluginLoader loader = plugin.getPluginLoader();
            assert (loader.getClassLoader().getParent().equals(parent));
            return loader;
        }
        return new PluginLoader(url, uri, parent, isInitial, optional);
    }

    @Nonnull
    public static synchronized PluginLoader getCorePluginLoader() {
        Plugin plugin = Plugin.getPlugin(null);
        if (plugin != null) {
            return plugin.getPluginLoader();
        }
        throw new IllegalStateException("Core plugin not loaded yet!");
    }

    public boolean isCorePlugin() {
        return this.corePlugin;
    }

    static void installStandardPlugins() {
        String homeDir = DetectorFactoryCollection.getFindBugsHome();
        if (homeDir == null) {
            return;
        }
        File home = new File(homeDir);
        PluginLoader.loadPlugins(home);
    }

    private static void loadPlugins(File home) {
        if (home.canRead() && home.isDirectory()) {
            PluginLoader.loadPluginsInDir(new File(home, "plugin"), false);
            PluginLoader.loadPluginsInDir(new File(home, "optionalPlugin"), true);
        }
    }

    static void installUserInstalledPlugins() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            return;
        }
        File homeFindBugs = new File(new File(homeDir), ".findbugs");
        PluginLoader.loadPlugins(homeFindBugs);
    }

    private static void loadPluginsInDir(File pluginDir, boolean optional) {
        File[] contentList = pluginDir.listFiles();
        if (contentList == null) {
            return;
        }
        for (File file : contentList) {
            if (!file.getName().endsWith(".jar")) continue;
            try {
                URL url = file.toURI().toURL();
                if (!IO.verifyURL(url)) continue;
                PluginLoader.loadInitialPlugin(url, true, optional);
                if (!FindBugs.DEBUG) continue;
                System.out.println("Found plugin: " + file.toString());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    static synchronized void loadInitialPlugins() {
        PluginLoader.loadCorePlugin();
        if (JavaWebStart.isRunningViaJavaWebstart()) {
            PluginLoader.installWebStartPlugins();
        } else {
            PluginLoader.installStandardPlugins();
            PluginLoader.installUserInstalledPlugins();
        }
        Set<Map.Entry<Object, Object>> entrySet = SystemProperties.getAllProperties().entrySet();
        for (Map.Entry<Object, Object> e : entrySet) {
            if (!(e.getKey() instanceof String) || !(e.getValue() instanceof String) || !((String)e.getKey()).startsWith("findbugs.plugin.")) continue;
            try {
                String value = (String)e.getValue();
                if (value.startsWith("file:") && !value.endsWith(".jar") && !value.endsWith("/")) {
                    value = value + "/";
                }
                URL url = JavaWebStart.resolveRelativeToJnlpCodebase(value);
                System.out.println("Loading " + e.getKey() + " from " + url);
                PluginLoader.loadInitialPlugin(url, true, false);
            }
            catch (MalformedURLException e1) {
                AnalysisContext.logError(String.format("Bad URL for plugin: %s=%s", e.getKey(), e.getValue()), e1);
            }
        }
        if (Plugin.getAllPlugins().size() > 1 && JavaWebStart.isRunningViaJavaWebstart()) {
            try {
                System.setSecurityManager(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void loadCorePlugin() {
        try {
            Plugin plugin = Plugin.getPlugin(null);
            if (plugin != null) {
                throw new IllegalStateException("Already loaded");
            }
            PluginLoader pluginLoader = new PluginLoader();
            plugin = pluginLoader.getPlugin();
            Plugin.putPlugin(null, plugin);
        }
        catch (PluginException e1) {
            throw new IllegalStateException("Unable to load core plugin", e1);
        }
    }

    private static void loadInitialPlugin(URL u, boolean initial, boolean optional) {
        try {
            PluginLoader.getPluginLoader(u, PluginLoader.class.getClassLoader(), initial, optional);
        }
        catch (DuplicatePluginIdException ignored) {
        }
        catch (PluginException e) {
            AnalysisContext.logError("Unable to load plugin from " + u, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void installWebStartPlugins() {
        URL pluginListProperties = PluginLoader.getCoreResource("pluginlist.properties");
        BufferedReader in = null;
        if (pluginListProperties != null) {
            try {
                String plugin;
                DetectorFactoryCollection.jawsDebugMessage(pluginListProperties.toString());
                URL base = PluginLoader.getUrlBase(pluginListProperties);
                in = UTF8.bufferedReader(pluginListProperties.openStream());
                while ((plugin = in.readLine()) != null) {
                    URL url = new URL(base, plugin);
                    try {
                        URLConnection connection = url.openConnection();
                        String contentType = connection.getContentType();
                        DetectorFactoryCollection.jawsDebugMessage("contentType : " + contentType);
                        if (connection instanceof HttpURLConnection) {
                            ((HttpURLConnection)connection).disconnect();
                        }
                        PluginLoader.loadInitialPlugin(url, true, false);
                    }
                    catch (Exception e) {
                        DetectorFactoryCollection.jawsDebugMessage("error loading " + url + " : " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                try {
                    DetectorFactoryCollection.jawsDebugMessage("error : " + e.getMessage());
                }
                catch (Throwable throwable) {
                    Util.closeSilently(in);
                    throw throwable;
                }
                Util.closeSilently(in);
            }
            Util.closeSilently(in);
        }
    }

    private static URL getUrlBase(URL pluginListProperties) throws MalformedURLException {
        String urlname = pluginListProperties.toString();
        URL base = pluginListProperties;
        int pos = urlname.indexOf("!/");
        if (pos >= 0 && urlname.startsWith("jar:")) {
            urlname = urlname.substring(4, pos);
            base = new URL(urlname);
        }
        return base;
    }

    public String toString() {
        if (this.plugin == null) {
            return String.format("PluginLoader(%s)", this.loadedFrom);
        }
        return String.format("PluginLoader(%s, %s)", this.plugin.getPluginId(), this.loadedFrom);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Summary validate(File file) throws IllegalArgumentException {
        Summary summary;
        String path = file.getPath();
        if (!file.getName().endsWith(".jar")) {
            String message = "File " + path + " is not a .jar file";
            throw new IllegalArgumentException(message);
        }
        if (!file.isFile() || !file.canRead()) {
            String message = "File " + path + " is not a file or is not readable";
            throw new IllegalArgumentException(message);
        }
        if (file.length() == 0L) {
            String message = "File " + path + " is empty";
            throw new IllegalArgumentException(message);
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            ZipEntry findbugsXML = zip.getEntry("findbugs.xml");
            if (findbugsXML == null) {
                throw new IllegalArgumentException("plugin doesn't contain a findbugs.xml file");
            }
            ZipEntry messagesXML = zip.getEntry("messages.xml");
            if (messagesXML == null) {
                throw new IllegalArgumentException("plugin doesn't contain a messages.xml file");
            }
            Document pluginDocument = PluginLoader.parseDocument(zip.getInputStream(findbugsXML));
            String pluginId = pluginDocument.valueOf(XPATH_PLUGIN_PLUGINID).trim();
            String provider = pluginDocument.valueOf(XPATH_PLUGIN_PROVIDER).trim();
            String website = pluginDocument.valueOf(XPATH_PLUGIN_WEBSITE).trim();
            ArrayList<Document> msgDocuments = new ArrayList<Document>(3);
            for (String msgFile : PluginLoader.getPotentialMessageFiles()) {
                ZipEntry msgEntry = zip.getEntry(msgFile);
                if (msgEntry == null) continue;
                Document msgDocument = PluginLoader.parseDocument(zip.getInputStream(msgEntry));
                msgDocuments.add(msgDocument);
            }
            String shortDesc = PluginLoader.findMessageText(msgDocuments, XPATH_PLUGIN_SHORT_DESCRIPTION, "");
            summary = new Summary(pluginId, shortDesc, provider, website);
        }
        catch (DocumentException e) {
            try {
                throw new IllegalArgumentException(e);
                catch (IOException e2) {
                    throw new IllegalArgumentException(e2);
                }
            }
            catch (Throwable throwable) {
                Util.closeSilently(zip);
                throw throwable;
            }
        }
        Util.closeSilently(zip);
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseDocument(@WillClose InputStream in) throws DocumentException {
        BufferedReader r = UTF8.bufferedReader(in);
        try {
            Document d;
            SAXReader reader = new SAXReader();
            Document document = d = reader.read((Reader)r);
            return document;
        }
        finally {
            Util.closeSilently(r);
        }
    }

    static {
        loadedPluginIds = new HashSet();
        if (DEBUG) {
            System.out.println("Debugging plugin loading. FindBugs version " + Version.getReleaseWithDateIfDev());
        }
        PluginLoader.loadInitialPlugins();
    }

    public static class Summary {
        public final String id;
        public final String description;
        public final String provider;
        public final String webbsite;

        public Summary(String id, String description, String provider, String website) {
            this.id = id;
            this.description = description;
            this.provider = provider;
            this.webbsite = website;
        }
    }
}

