/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethodChooser;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy2 {
    private static final ClassDescriptor objectDescriptor = DescriptorFactory.createClassDescriptor(Object.class);
    private static final boolean OPEN_WORLD = SystemProperties.getBoolean("findbugs.openworld", true);
    private static final boolean OPEN_WORLD_DEBUG = SystemProperties.getBoolean("findbugs.openworld.debug", false);

    public static XMethod findExactMethod(InvokeInstruction inv, ConstantPoolGen cpg, JavaClassAndMethodChooser chooser) {
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        XMethod result = Hierarchy2.findMethod(DescriptorFactory.createClassDescriptorFromDottedClassName(className), methodName, methodSig, inv instanceof INVOKESTATIC);
        return Hierarchy2.thisOrNothing(result, chooser);
    }

    @CheckForNull
    private static XMethod thisOrNothing(@CheckForNull XMethod m, JavaClassAndMethodChooser chooser) {
        if (m == null) {
            return null;
        }
        if (chooser.choose(m)) {
            return m;
        }
        return null;
    }

    @CheckForNull
    public static XMethod findInvocationLeastUpperBound(InvokeInstruction inv, ConstantPoolGen cpg, JavaClassAndMethodChooser methodChooser) {
        short opcode;
        if (Hierarchy.DEBUG_METHOD_LOOKUP) {
            System.out.println("Find prototype method for " + SignatureConverter.convertMethodSignature(inv, cpg));
        }
        if ((opcode = inv.getOpcode()) == 184 ? methodChooser == Hierarchy.INSTANCE_METHOD : methodChooser == Hierarchy.STATIC_METHOD) {
            return null;
        }
        if (opcode == 183) {
            return Hierarchy2.findExactMethod(inv, cpg, methodChooser);
        }
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        if (Hierarchy.DEBUG_METHOD_LOOKUP) {
            System.out.println("[Class name is " + className + "]");
            System.out.println("[Method name is " + methodName + "]");
            System.out.println("[Method signature is " + methodSig + "]");
        }
        if (className.startsWith("[")) {
            className = "java.lang.Object";
        }
        try {
            return Hierarchy2.thisOrNothing(Hierarchy2.findInvocationLeastUpperBound(Hierarchy2.getXClassFromDottedClassName(className), methodName, methodSig, opcode == 184, opcode == 185), methodChooser);
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    @CheckForNull
    public static XMethod findInvocationLeastUpperBound(ClassDescriptor classDesc, String methodName, String methodSig, boolean invokeStatic, boolean invokeInterface) {
        try {
            return Hierarchy2.findInvocationLeastUpperBound(Hierarchy2.getXClass(classDesc), methodName, methodSig, invokeStatic, invokeInterface);
        }
        catch (Exception e) {
            return null;
        }
    }

    @CheckForNull
    public static XMethod findInvocationLeastUpperBound(XClass jClass, String methodName, String methodSig, boolean invokeStatic, boolean invokeInterface) {
        XMethod result = Hierarchy2.findMethod(jClass.getClassDescriptor(), methodName, methodSig, invokeStatic);
        if (result != null) {
            return result;
        }
        ClassDescriptor sClass = jClass.getSuperclassDescriptor();
        if (sClass != null && (result = Hierarchy2.findInvocationLeastUpperBound(sClass, methodName, methodSig, invokeStatic, invokeInterface)) != null) {
            return result;
        }
        for (ClassDescriptor i : jClass.getInterfaceDescriptorList()) {
            result = Hierarchy2.findInvocationLeastUpperBound(i, methodName, methodSig, invokeStatic, invokeInterface);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @CheckForNull
    public static XMethod findInvocationLeastUpperBound0(XClass jClass, String methodName, String methodSig, boolean invokeStatic, boolean invokeInterface) {
        XMethod result = Hierarchy2.findMethod(jClass.getClassDescriptor(), methodName, methodSig, invokeStatic);
        if (result != null) {
            return result;
        }
        if (invokeInterface) {
            for (ClassDescriptor i : jClass.getInterfaceDescriptorList()) {
                result = Hierarchy2.findInvocationLeastUpperBound(i, methodName, methodSig, invokeStatic, invokeInterface);
                if (result == null) continue;
                return result;
            }
        } else {
            ClassDescriptor sClass = jClass.getSuperclassDescriptor();
            if (sClass != null) {
                return Hierarchy2.findInvocationLeastUpperBound(sClass, methodName, methodSig, invokeStatic, invokeInterface);
            }
        }
        return null;
    }

    public static Set<XMethod> findSuperMethods(XMethod m) {
        HashSet<XMethod> result = new HashSet<XMethod>();
        Hierarchy2.findSuperMethods(m.getClassDescriptor(), m, result);
        result.remove(m);
        return result;
    }

    private static void findSuperMethods(@CheckForNull ClassDescriptor c, XMethod m, Set<XMethod> accumulator) {
        if (c == null) {
            return;
        }
        try {
            XClass xc = Hierarchy2.getXClass(c);
            XMethod xm = xc.findMatchingMethod(m.getMethodDescriptor());
            if (xm != null && !accumulator.add(xm)) {
                return;
            }
            Hierarchy2.findSuperMethods(xc.getSuperclassDescriptor(), m, accumulator);
            for (ClassDescriptor i : xc.getInterfaceDescriptorList()) {
                Hierarchy2.findSuperMethods(i, m, accumulator);
            }
            if (!accumulator.add(m)) {
                return;
            }
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error finding super methods for " + m, e);
        }
    }

    @CheckForNull
    public static XMethod findMethod(ClassDescriptor classDescriptor, String methodName, String methodSig, boolean isStatic) {
        try {
            return Hierarchy2.getXClass(classDescriptor).findMethod(methodName, methodSig, isStatic);
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    static XClass getXClass(@SlashedClassName String c) throws CheckedAnalysisException {
        return Hierarchy2.getXClass(DescriptorFactory.createClassDescriptor(c));
    }

    static XClass getXClassFromDottedClassName(@DottedClassName String c) throws CheckedAnalysisException {
        return Hierarchy2.getXClass(DescriptorFactory.createClassDescriptorFromDottedClassName(c));
    }

    static XClass getXClass(ClassDescriptor c) throws CheckedAnalysisException {
        return Global.getAnalysisCache().getClassAnalysis(XClass.class, c);
    }

    @Nonnull
    public static Set<XMethod> resolveMethodCallTargets(InvokeInstruction invokeInstruction, TypeFrame typeFrame, ConstantPoolGen cpg) throws DataflowAnalysisException, ClassNotFoundException {
        boolean receiverTypeIsExact;
        ObjectType receiverType;
        short opcode = invokeInstruction.getOpcode();
        if (opcode == 184) {
            return Util.emptyOrNonnullSingleton(Hierarchy2.findInvocationLeastUpperBound(invokeInstruction, cpg, Hierarchy.STATIC_METHOD));
        }
        if (!typeFrame.isValid()) {
            return Collections.emptySet();
        }
        if (opcode == 183) {
            receiverType = ObjectTypeFactory.getInstance(invokeInstruction.getClassName(cpg));
            receiverTypeIsExact = false;
        } else {
            int instanceStackLocation = typeFrame.getInstanceStackLocation((Instruction)invokeInstruction, cpg);
            receiverType = (Type)typeFrame.getStackValue(instanceStackLocation);
            if (!(receiverType instanceof ReferenceType)) {
                return Collections.emptySet();
            }
            receiverTypeIsExact = typeFrame.isExact(instanceStackLocation);
        }
        if (Hierarchy.DEBUG_METHOD_LOOKUP) {
            System.out.println("[receiver type is " + receiverType + ", " + (receiverTypeIsExact ? "exact]" : " not exact]"));
        }
        return Hierarchy2.resolveMethodCallTargets((ReferenceType)receiverType, invokeInstruction, cpg, receiverTypeIsExact);
    }

    public static Set<XMethod> resolveMethodCallTargets(ReferenceType receiverType, InvokeInstruction invokeInstruction, ConstantPoolGen cpg) throws ClassNotFoundException {
        return Hierarchy2.resolveMethodCallTargets(receiverType, invokeInstruction, cpg, false);
    }

    public static Set<XMethod> resolveMethodCallTargets(ReferenceType receiverType, InvokeInstruction invokeInstruction, ConstantPoolGen cpg, boolean receiverTypeIsExact) throws ClassNotFoundException {
        if (invokeInstruction.getOpcode() == 184) {
            throw new IllegalArgumentException();
        }
        String methodName = invokeInstruction.getName(cpg);
        String methodSig = invokeInstruction.getSignature(cpg);
        if (receiverType instanceof ArrayType) {
            try {
                return Util.emptyOrNonnullSingleton(Hierarchy2.getXClass(objectDescriptor).findMethod(methodName, methodSig, false));
            }
            catch (CheckedAnalysisException e) {
                return Collections.emptySet();
            }
        }
        if (receiverType instanceof ObjectType) {
            String receiverClassName = ((ObjectType)receiverType).getClassName();
            return Hierarchy2.resolveVirtualMethodCallTargets(receiverClassName, methodName, methodSig, receiverTypeIsExact, invokeInstruction instanceof INVOKESPECIAL);
        }
        assert (receiverType instanceof NullType);
        return Collections.emptySet();
    }

    public static Set<XMethod> resolveVirtualMethodCallTargets(String receiverClassName, String methodName, String methodSig, boolean receiverTypeIsExact, boolean invokeSpecial) throws ClassNotFoundException {
        ClassDescriptor receiverDesc = DescriptorFactory.createClassDescriptorFromDottedClassName(receiverClassName);
        return Hierarchy2.resolveVirtualMethodCallTargets(receiverDesc, methodName, methodSig, receiverTypeIsExact, invokeSpecial);
    }

    public static Set<XMethod> resolveVirtualMethodCallTargets(XMethod target, boolean receiverTypeIsExact, boolean invokeSpecial) throws ClassNotFoundException {
        return Hierarchy2.resolveVirtualMethodCallTargets(target.getClassDescriptor(), target.getName(), target.getSignature(), receiverTypeIsExact, invokeSpecial);
    }

    public static Set<XMethod> resolveVirtualMethodCallTargets(ClassDescriptor receiverDesc, String methodName, String methodSig, boolean receiverTypeIsExact, boolean invokeSpecial) throws ClassNotFoundException {
        boolean virtualCall;
        XClass xClass;
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        try {
            xClass = Hierarchy2.getXClass(receiverDesc);
        }
        catch (CheckedAnalysisException e) {
            return Collections.emptySet();
        }
        LinkedHashSet<XMethod> result = new LinkedHashSet<XMethod>();
        XMethod upperBound = Hierarchy2.findMethod(receiverDesc, methodName, methodSig, false);
        if (upperBound == null) {
            upperBound = Hierarchy2.findInvocationLeastUpperBound(xClass, methodName, methodSig, false, false);
        }
        if (upperBound != null) {
            if (Hierarchy.DEBUG_METHOD_LOOKUP) {
                System.out.println("Adding upper bound: " + upperBound);
            }
            result.add(upperBound);
        }
        if (OPEN_WORLD_DEBUG) {
            System.out.println("OWD: " + receiverDesc + "." + methodName + methodSig);
            if (upperBound != null) {
                System.out.println("  upper bound:" + upperBound);
            }
        }
        boolean bl = virtualCall = (upperBound == null || !upperBound.isFinal()) && !receiverTypeIsExact && !invokeSpecial;
        if (virtualCall && !receiverDesc.getClassName().equals("java/lang/Object")) {
            Set<ClassDescriptor> subTypeSet = analysisContext.getSubtypes2().getSubtypes(receiverDesc);
            for (ClassDescriptor subtype : subTypeSet) {
                XMethod concreteSubtypeMethod = Hierarchy2.findMethod(subtype, methodName, methodSig, false);
                if (concreteSubtypeMethod == null || !OPEN_WORLD && concreteSubtypeMethod.isAbstract()) continue;
                if (OPEN_WORLD_DEBUG) {
                    System.out.println("  -> " + concreteSubtypeMethod);
                }
                result.add(concreteSubtypeMethod);
            }
        }
        return result;
    }

    @CheckForNull
    public static ObjectType[] findDeclaredExceptions(InvokeInstruction inv, ConstantPoolGen cpg) {
        XMethod method = Hierarchy2.findInvocationLeastUpperBound(inv, cpg, inv instanceof INVOKESTATIC ? Hierarchy.STATIC_METHOD : Hierarchy.INSTANCE_METHOD);
        if (method == null) {
            return null;
        }
        String[] exceptions = method.getThrownExceptions();
        if (exceptions == null) {
            return new ObjectType[0];
        }
        ObjectType[] result = new ObjectType[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            result[i] = ObjectTypeFactory.getInstance(ClassName.toDottedClassName(exceptions[i]));
        }
        return result;
    }
}

