/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.URLClassPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class URLClassPathRepository
implements Repository {
    public static final boolean DEBUG = SystemProperties.getBoolean("findbugs.classpath.debug");
    private static final long serialVersionUID = 1L;
    private Map<String, JavaClass> nameToClassMap = new HashMap<String, JavaClass>();
    private URLClassPath urlClassPath = new URLClassPath();

    public void destroy() {
        this.nameToClassMap.clear();
        this.urlClassPath.close();
        if (DEBUG) {
            System.out.println("Destroying Repository");
        }
    }

    public void addURL(String fileName) throws IOException {
        this.urlClassPath.addURL(fileName);
    }

    public void storeClass(JavaClass javaClass) {
        Repository tmp;
        if (DEBUG) {
            System.out.println("Storing class " + javaClass.getClassName() + " in repository");
        }
        JavaClass previous = this.nameToClassMap.put(javaClass.getClassName(), javaClass);
        if (DEBUG && previous != null) {
            System.out.println("\t==> A previous class was evicted!");
            this.dumpStack();
        }
        if ((tmp = org.apache.bcel.Repository.getRepository()) != null && tmp != this) {
            throw new IllegalStateException("Wrong/multiple BCEL repository");
        }
        if (tmp == null) {
            org.apache.bcel.Repository.setRepository((Repository)this);
        }
    }

    public void removeClass(JavaClass javaClass) {
        this.nameToClassMap.remove(javaClass.getClassName());
        if (DEBUG) {
            System.out.println("Removing class " + javaClass.getClassName() + " from Repository");
            this.dumpStack();
        }
    }

    private void dumpStack() {
        new Throwable().printStackTrace(System.out);
    }

    public JavaClass findClass(String className) {
        String dottedClassName = className.replace('/', '.');
        return this.nameToClassMap.get(dottedClassName);
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        JavaClass javaClass = this.findClass(className);
        if (javaClass == null) {
            if (DEBUG) {
                System.out.println("Looking up " + className + " on classpath");
                this.dumpStack();
            }
            javaClass = this.urlClassPath.lookupClass(className);
            this.storeClass(javaClass);
        }
        return javaClass;
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    public void clear() {
        if (DEBUG) {
            System.out.println("Clearing Repository!");
            this.dumpStack();
        }
        this.nameToClassMap.clear();
    }

    public ClassPath getClassPath() {
        return new ClassPath(this.urlClassPath.getClassPath());
    }
}

