/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.SourceFileDataSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipSourceFileDataSource
implements SourceFileDataSource {
    private ZipFile zipFile;
    private String entryName;
    private ZipEntry zipEntry;

    public ZipSourceFileDataSource(ZipFile zipFile, String entryName) {
        this.zipFile = zipFile;
        this.entryName = entryName;
        this.zipEntry = zipFile.getEntry(entryName);
    }

    public InputStream open() throws IOException {
        if (this.zipEntry == null) {
            throw new FileNotFoundException("No zip entry for " + this.entryName);
        }
        return this.zipFile.getInputStream(this.zipEntry);
    }

    public String getFullFileName() {
        return this.entryName;
    }

    public long getLastModified() {
        long time = this.zipEntry.getTime();
        if (time < 0L) {
            return 0L;
        }
        return time;
    }
}

