/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.type.BottomType;
import edu.umd.cs.findbugs.ba.type.ExceptionObjectType;
import edu.umd.cs.findbugs.ba.type.ExceptionSet;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.ExtendedTypes;
import edu.umd.cs.findbugs.ba.type.TypeMerger;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class StandardTypeMerger
implements TypeMerger,
Constants,
ExtendedTypes {
    private RepositoryLookupFailureCallback lookupFailureCallback;
    private ExceptionSetFactory exceptionSetFactory;
    private static final ObjectType OBJECT_TYPE = ObjectTypeFactory.getInstance("java.lang.Object");

    public StandardTypeMerger(RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
        this.lookupFailureCallback = lookupFailureCallback;
        this.exceptionSetFactory = exceptionSetFactory;
    }

    public Type mergeTypes(Type a, Type b) throws DataflowAnalysisException {
        byte aType = a.getType();
        byte bType = b.getType();
        if (aType == 17) {
            return b;
        }
        if (bType == 17) {
            return a;
        }
        if (aType == 20 || bType == 20) {
            return BottomType.instance();
        }
        if (this.isReferenceType(aType) && this.isReferenceType(bType)) {
            if (aType == 21) {
                return b;
            }
            if (bType == 21) {
                return a;
            }
            ReferenceType aRef = (ReferenceType)a;
            ReferenceType bRef = (ReferenceType)b;
            return this.mergeReferenceTypes(aRef, bRef);
        }
        if (this.isReferenceType(aType) || this.isReferenceType(bType)) {
            return BottomType.instance();
        }
        if (aType == bType) {
            return a;
        }
        if (this.isIntegerType(aType) && this.isIntegerType(bType)) {
            return Type.INT;
        }
        return BottomType.instance();
    }

    protected boolean isReferenceType(byte type) {
        return type == 14 || type == 13 || type == 21 || type == 22;
    }

    protected boolean isObjectType(byte type) {
        return type == 14 || type == 22;
    }

    protected boolean isIntegerType(byte type) {
        return type == 10 || type == 8 || type == 4 || type == 5 || type == 9;
    }

    private static void updateExceptionSet(ExceptionSet exceptionSet, ObjectType type) {
        if (type instanceof ExceptionObjectType) {
            exceptionSet.addAll(((ExceptionObjectType)type).getExceptionSet());
        } else {
            exceptionSet.addExplicit(type);
        }
    }

    protected ReferenceType mergeReferenceTypes(ReferenceType aRef, ReferenceType bRef) throws DataflowAnalysisException {
        if (aRef.equals((Object)bRef)) {
            return aRef;
        }
        byte aType = aRef.getType();
        byte bType = bRef.getType();
        try {
            if (this.isObjectType(aType) && this.isObjectType(bType) && (aType == 22 || bType == 22 || this.isThrowable(aRef) && this.isThrowable(bRef))) {
                ExceptionSet union = this.exceptionSetFactory.createExceptionSet();
                if (aType == 14 && aRef.getSignature().equals("Ljava/lang/Throwable;")) {
                    return aRef;
                }
                if (bType == 14 && bRef.getSignature().equals("Ljava/lang/Throwable;")) {
                    return bRef;
                }
                StandardTypeMerger.updateExceptionSet(union, (ObjectType)aRef);
                StandardTypeMerger.updateExceptionSet(union, (ObjectType)bRef);
                Type t = ExceptionObjectType.fromExceptionSet(union);
                if (t instanceof ReferenceType) {
                    return (ReferenceType)t;
                }
            }
            if (aRef instanceof GenericObjectType && bRef instanceof GenericObjectType && aRef.getSignature().equals(bRef.getSignature())) {
                GenericObjectType aG = (GenericObjectType)aRef;
                GenericObjectType bG = (GenericObjectType)bRef;
                if (aG.getTypeCategory() == bG.getTypeCategory()) {
                    switch (aG.getTypeCategory()) {
                        case PARAMETERIZED: {
                            List<? extends ReferenceType> aP = aG.getParameters();
                            List<? extends ReferenceType> bP = bG.getParameters();
                            assert (aP != null);
                            assert (bP != null);
                            if (aP.size() != bP.size()) break;
                            ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(aP.size());
                            for (int i = 0; i < aP.size(); ++i) {
                                result.add(this.mergeReferenceTypes(aP.get(i), bP.get(i)));
                            }
                            GenericObjectType rOT = GenericUtilities.getType(aG.getClassName(), result);
                            return rOT;
                        }
                    }
                }
            }
            if (aRef instanceof GenericObjectType) {
                aRef = ((GenericObjectType)aRef).getObjectType();
            }
            if (bRef instanceof GenericObjectType) {
                bRef = ((GenericObjectType)bRef).getObjectType();
            }
            return AnalysisContext.currentAnalysisContext().getSubtypes2().getFirstCommonSuperclass(aRef, bRef);
        }
        catch (ClassNotFoundException e) {
            this.lookupFailureCallback.reportMissingClass(e);
            return Type.OBJECT;
        }
    }

    private boolean isThrowable(ReferenceType ref) {
        try {
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            return subtypes2.isSubtype(ref, (ReferenceType)Type.THROWABLE);
        }
        catch (ClassNotFoundException e) {
            this.lookupFailureCallback.reportMissingClass(e);
            return false;
        }
    }
}

