/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IAnalysisEngine;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IDatabaseFactory;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.UncheckedAnalysisException;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.util.MapCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisCache
implements IAnalysisCache {
    private static final int MAX_JAVACLASS_RESULTS_TO_CACHE = 5000;
    private static final int MAX_CONSTANT_POOL_GEN_RESULTS_TO_CACHE = 500;
    private static final int MAX_CLASS_RESULTS_TO_CACHE = 5000;
    private static final boolean ASSERTIONS_ENABLED = SystemProperties.ASSERTIONS_ENABLED;
    private final IClassPath classPath;
    private final BugReporter bugReporter;
    private final Map<Class<?>, IClassAnalysisEngine<?>> classAnalysisEngineMap;
    private final Map<Class<?>, IMethodAnalysisEngine<?>> methodAnalysisEngineMap;
    private final Map<Class<?>, IDatabaseFactory<?>> databaseFactoryMap;
    private final Map<Class<?>, Map<ClassDescriptor, Object>> classAnalysisMap;
    private final Map<Class<?>, Object> databaseMap;
    private final Map<?, ?> analysisLocals = Collections.synchronizedMap(new HashMap());
    static final AbnormalAnalysisResult NULL_ANALYSIS_RESULT = new AbnormalAnalysisResult();

    @Override
    public final Map<?, ?> getAnalysisLocals() {
        return this.analysisLocals;
    }

    static <E> E checkedCast(Class<E> analysisClass, Object o) {
        if (SystemProperties.ASSERTIONS_ENABLED) {
            return analysisClass.cast(o);
        }
        return (E)o;
    }

    AnalysisCache(IClassPath classPath, BugReporter errorLogger) {
        this.classPath = classPath;
        this.bugReporter = errorLogger;
        this.classAnalysisEngineMap = new HashMap();
        this.methodAnalysisEngineMap = new HashMap();
        this.databaseFactoryMap = new HashMap();
        this.classAnalysisMap = new HashMap();
        this.databaseMap = new HashMap();
    }

    @Override
    public IClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    public void purgeAllMethodAnalysis() {
        try {
            Map<ClassDescriptor, ClassContext> map = this.getAllClassAnalysis(ClassContext.class);
            Collection<ClassContext> allClassContexts = map.values();
            for (ClassContext c : allClassContexts) {
                if (!(c instanceof ClassContext)) continue;
                c.purgeAllMethodAnalyses();
            }
        }
        catch (ClassCastException e) {
            AnalysisContext.logError("Unable to purge method analysis", e);
        }
    }

    private <E> Map<ClassDescriptor, E> getAllClassAnalysis(Class<E> analysisClass) {
        Map descriptorMap = AnalysisCache.findOrCreateDescriptorMap(this.classAnalysisMap, this.classAnalysisEngineMap, analysisClass);
        return descriptorMap;
    }

    @Override
    public void purgeClassAnalysis(Class<?> analysisClass) {
        this.classAnalysisMap.remove(analysisClass);
    }

    public void dispose() {
        this.classAnalysisMap.clear();
        this.classAnalysisEngineMap.clear();
        this.analysisLocals.clear();
        this.databaseFactoryMap.clear();
        this.databaseMap.clear();
        this.methodAnalysisEngineMap.clear();
    }

    @CheckForNull
    public Map<ClassDescriptor, Object> getClassAnalysis(Class<?> analysisClass) {
        return this.classAnalysisMap.get(analysisClass);
    }

    public <E> void reuseClassAnalysis(Class<E> analysisClass, Map<ClassDescriptor, Object> map) {
        Map<ClassDescriptor, Object> myMap = this.classAnalysisMap.get(analysisClass);
        if (myMap != null) {
            myMap.putAll(map);
        } else {
            myMap = AnalysisCache.createMap(this.classAnalysisEngineMap, analysisClass);
            myMap.putAll(map);
            this.classAnalysisMap.put(analysisClass, myMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E getClassAnalysis(Class<E> analysisClass, @Nonnull ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (classDescriptor == null) {
            throw new NullPointerException("classDescriptor is null");
        }
        Map descriptorMap = AnalysisCache.findOrCreateDescriptorMap(this.classAnalysisMap, this.classAnalysisEngineMap, analysisClass);
        Object analysisResult = descriptorMap.get(classDescriptor);
        if (analysisResult == null) {
            block10: {
                IAnalysisEngine engine = this.classAnalysisEngineMap.get(analysisClass);
                if (engine == null) {
                    throw new IllegalArgumentException("No analysis engine registered to produce " + analysisClass.getName());
                }
                Profiler profiler = this.getProfiler();
                try {
                    block9: {
                        try {
                            profiler.start(engine.getClass());
                            analysisResult = engine.analyze(this, classDescriptor);
                            if (analysisResult != null) break block9;
                            analysisResult = NULL_ANALYSIS_RESULT;
                        }
                        catch (CheckedAnalysisException e) {
                            analysisResult = new AbnormalAnalysisResult(e);
                            Object var9_8 = null;
                            profiler.end(engine.getClass());
                            break block10;
                        }
                        catch (RuntimeException e) {
                            analysisResult = new AbnormalAnalysisResult(e);
                            Object var9_9 = null;
                            profiler.end(engine.getClass());
                        }
                    }
                    Object var9_7 = null;
                    profiler.end(engine.getClass());
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    profiler.end(engine.getClass());
                    throw throwable;
                }
            }
            descriptorMap.put(classDescriptor, analysisResult);
        }
        if (analysisResult instanceof AbnormalAnalysisResult) {
            return AnalysisCache.checkedCast(analysisClass, ((AbnormalAnalysisResult)analysisResult).returnOrThrow());
        }
        return AnalysisCache.checkedCast(analysisClass, analysisResult);
    }

    @Override
    public <E> E probeClassAnalysis(Class<E> analysisClass, @Nonnull ClassDescriptor classDescriptor) {
        Map<ClassDescriptor, Object> descriptorMap = this.classAnalysisMap.get(analysisClass);
        if (descriptorMap == null) {
            return null;
        }
        return AnalysisCache.checkedCast(analysisClass, descriptorMap.get(classDescriptor));
    }

    String hex(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    @Override
    public <E> E getMethodAnalysis(Class<E> analysisClass, @Nonnull MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor is null");
        }
        ClassContext classContext = this.getClassAnalysis(ClassContext.class, methodDescriptor.getClassDescriptor());
        Object object = classContext.getMethodAnalysis(analysisClass, methodDescriptor);
        if (object == null) {
            try {
                object = this.analyzeMethod(classContext, analysisClass, methodDescriptor);
                if (object == null) {
                    object = NULL_ANALYSIS_RESULT;
                }
            }
            catch (RuntimeException e) {
                object = new AbnormalAnalysisResult(e);
            }
            catch (CheckedAnalysisException e) {
                object = new AbnormalAnalysisResult(e);
            }
            classContext.putMethodAnalysis(analysisClass, methodDescriptor, object);
        }
        if (Debug.VERIFY_INTEGRITY && object == null) {
            throw new IllegalStateException("AnalysisFactory failed to produce a result object");
        }
        if (object instanceof AbnormalAnalysisResult) {
            return AnalysisCache.checkedCast(analysisClass, ((AbnormalAnalysisResult)object).returnOrThrow());
        }
        return AnalysisCache.checkedCast(analysisClass, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> E analyzeMethod(ClassContext classContext, Class<E> analysisClass, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        Object ResultType;
        IMethodAnalysisEngine<?> engine = this.methodAnalysisEngineMap.get(analysisClass);
        if (engine == null) {
            throw new IllegalArgumentException("No analysis engine registered to produce " + analysisClass.getName());
        }
        Profiler profiler = this.getProfiler();
        profiler.start(engine.getClass());
        try {
            ResultType = engine.analyze(this, methodDescriptor);
            Object var8_7 = null;
            profiler.end(engine.getClass());
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            profiler.end(engine.getClass());
            throw throwable;
        }
        return (E)ResultType;
    }

    @Override
    public <E> void eagerlyPutMethodAnalysis(Class<E> analysisClass, @Nonnull MethodDescriptor methodDescriptor, E analysisObject) {
        try {
            ClassContext classContext = this.getClassAnalysis(ClassContext.class, methodDescriptor.getClassDescriptor());
            assert (analysisClass.isInstance(analysisObject));
            classContext.putMethodAnalysis(analysisClass, methodDescriptor, analysisObject);
        }
        catch (CheckedAnalysisException e) {
            IllegalStateException ise = new IllegalStateException("Unexpected exception adding method analysis to cache");
            ise.initCause(e);
            throw ise;
        }
    }

    @Override
    public void purgeMethodAnalyses(@Nonnull MethodDescriptor methodDescriptor) {
        try {
            ClassContext classContext = this.getClassAnalysis(ClassContext.class, methodDescriptor.getClassDescriptor());
            classContext.purgeMethodAnalyses(methodDescriptor);
        }
        catch (CheckedAnalysisException e) {
            IllegalStateException ise = new IllegalStateException("Unexpected exception purging method analyses from cache");
            ise.initCause(e);
            throw ise;
        }
    }

    private static <DescriptorType> Map<DescriptorType, Object> findOrCreateDescriptorMap(Map<Class<?>, Map<DescriptorType, Object>> analysisClassToDescriptorMapMap, Map<Class<?>, ? extends IAnalysisEngine<DescriptorType, ?>> engineMap, Class<?> analysisClass) {
        Map<DescriptorType, Object> descriptorMap = analysisClassToDescriptorMapMap.get(analysisClass);
        if (descriptorMap == null) {
            descriptorMap = AnalysisCache.createMap(engineMap, analysisClass);
            analysisClassToDescriptorMapMap.put(analysisClass, descriptorMap);
        }
        return descriptorMap;
    }

    private static <DescriptorType> Map<DescriptorType, Object> createMap(Map<Class<?>, ? extends IAnalysisEngine<DescriptorType, ?>> engineMap, Class<?> analysisClass) {
        IAnalysisEngine<DescriptorType, ?> engine = engineMap.get(analysisClass);
        HashMap descriptorMap = analysisClass.equals(JavaClass.class) ? new MapCache(5000) : (analysisClass.equals(ConstantPoolGen.class) ? new MapCache(500) : (analysisClass.equals(ClassContext.class) ? new MapCache(10) : (engine instanceof IClassAnalysisEngine && ((IClassAnalysisEngine)engine).canRecompute() ? new MapCache(5000) : new HashMap())));
        return descriptorMap;
    }

    @Override
    public <E> void registerClassAnalysisEngine(Class<E> analysisResultType, IClassAnalysisEngine<E> classAnalysisEngine) {
        this.classAnalysisEngineMap.put(analysisResultType, classAnalysisEngine);
    }

    @Override
    public <E> void registerMethodAnalysisEngine(Class<E> analysisResultType, IMethodAnalysisEngine<E> methodAnalysisEngine) {
        this.methodAnalysisEngineMap.put(analysisResultType, methodAnalysisEngine);
    }

    @Override
    public <E> void registerDatabaseFactory(Class<E> databaseClass, IDatabaseFactory<E> databaseFactory) {
        this.databaseFactoryMap.put(databaseClass, databaseFactory);
    }

    @Override
    public <E> E getDatabase(Class<E> databaseClass) {
        return this.getDatabase(databaseClass, false);
    }

    @Override
    @CheckForNull
    public <E> E getOptionalDatabase(Class<E> databaseClass) {
        return this.getDatabase(databaseClass, true);
    }

    public <E> E getDatabase(Class<E> databaseClass, boolean optional) {
        Object database = this.databaseMap.get(databaseClass);
        if (database == null) {
            try {
                IDatabaseFactory<?> databaseFactory = this.databaseFactoryMap.get(databaseClass);
                if (databaseFactory == null) {
                    if (optional) {
                        return null;
                    }
                    throw new IllegalArgumentException("No database factory registered for " + databaseClass.getName());
                }
                database = databaseFactory.createDatabase();
            }
            catch (CheckedAnalysisException e) {
                database = new AbnormalAnalysisResult(e);
            }
            this.databaseMap.put(databaseClass, database);
        }
        if (database instanceof AbnormalAnalysisResult) {
            throw new UncheckedAnalysisException("Error instantiating " + databaseClass.getName() + " database", ((AbnormalAnalysisResult)database).checkedAnalysisException);
        }
        return databaseClass.cast(database);
    }

    @Override
    public <E> void eagerlyPutDatabase(Class<E> databaseClass, E database) {
        this.databaseMap.put(databaseClass, database);
    }

    @Override
    public IErrorLogger getErrorLogger() {
        return this.bugReporter;
    }

    @Override
    public Profiler getProfiler() {
        return this.bugReporter.getProjectStats().getProfiler();
    }

    static class AbnormalAnalysisResult {
        final CheckedAnalysisException checkedAnalysisException;
        final RuntimeException runtimeException;
        final boolean isNull;

        AbnormalAnalysisResult(CheckedAnalysisException checkedAnalysisException) {
            this.checkedAnalysisException = checkedAnalysisException;
            this.runtimeException = null;
            this.isNull = false;
        }

        AbnormalAnalysisResult(RuntimeException runtimeException) {
            this.runtimeException = runtimeException;
            this.checkedAnalysisException = null;
            this.isNull = false;
        }

        AbnormalAnalysisResult() {
            this.isNull = true;
            this.checkedAnalysisException = null;
            this.runtimeException = null;
        }

        public Object returnOrThrow() throws CheckedAnalysisException {
            if (this.isNull) {
                return null;
            }
            if (this.runtimeException != null) {
                throw this.runtimeException;
            }
            if (this.checkedAnalysisException != null) {
                throw this.checkedAnalysisException;
            }
            throw new IllegalStateException("It has to be something");
        }
    }
}

