/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ProgramPoint;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.PutfieldScanner;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.detect.UnreadFieldsData;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class ReadOfInstanceFieldInMethodInvokedByConstructorInSuperclass
extends OpcodeStackDetector {
    final BugAccumulator accumulator;
    Set<XField> initializedFields;
    Set<XField> nullCheckedFields;

    public ReadOfInstanceFieldInMethodInvokedByConstructorInSuperclass(BugReporter bugReporter) {
        this.accumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code obj) {
        if (this.getMethod().isStatic()) {
            return;
        }
        this.initializedFields = new HashSet<XField>();
        this.nullCheckedFields = new HashSet<XField>();
        super.visit(obj);
        this.accumulator.reportAccumulatedBugs();
    }

    public void sawOpcode(int opcode) {
        ClassDescriptor superClassDescriptor;
        if (opcode == 181) {
            XField f = this.getXFieldOperand();
            OpcodeStack.Item item = this.stack.getStackItem(1);
            if (item.getRegisterNumber() != 0) {
                return;
            }
            this.initializedFields.add(f);
            return;
        }
        if (opcode != 180) {
            return;
        }
        OpcodeStack.Item item = this.stack.getStackItem(0);
        if (item.getRegisterNumber() != 0) {
            return;
        }
        XField f = this.getXFieldOperand();
        if (f == null || !f.getClassDescriptor().equals(this.getClassDescriptor())) {
            return;
        }
        if (f.isSynthetic() || f.getName().startsWith("this$")) {
            return;
        }
        if (this.initializedFields.contains(f)) {
            return;
        }
        FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
        Set<ProgramPoint> calledFrom = fieldSummary.getCalledFromSuperConstructor(superClassDescriptor = DescriptorFactory.createClassDescriptor(this.getSuperclassName()), this.getXMethod());
        if (calledFrom.isEmpty()) {
            return;
        }
        UnreadFieldsData unreadFields = AnalysisContext.currentAnalysisContext().getUnreadFieldsData();
        if (!unreadFields.isWrittenInConstructor(f)) {
            return;
        }
        int priority = f.isFinal() ? 1 : (unreadFields.isWrittenDuringInitialization(f) || unreadFields.isWrittenOutsideOfInitialization(f) ? 2 : 1);
        int nextOpcode = this.getNextOpcode();
        if (this.nullCheckedFields.contains(f) || nextOpcode == 198 || nextOpcode == 199 || nextOpcode == 153 || nextOpcode == 154) {
            ++priority;
            this.nullCheckedFields.add(f);
        }
        for (ProgramPoint p : calledFrom) {
            Map<Integer, OpcodeStack.Item> putfieldsAt;
            XMethod upcall = this.getConstructorThatCallsSuperConstructor(p.method);
            if (upcall == null) continue;
            Method upcallMethod = null;
            for (Method m : this.getThisClass().getMethods()) {
                if (!m.getName().equals(upcall.getName()) || !m.getSignature().equals(upcall.getSignature())) continue;
                upcallMethod = m;
                break;
            }
            if (upcallMethod == null || (putfieldsAt = PutfieldScanner.getPutfieldsFor(this.getThisClass(), upcallMethod, f)).isEmpty()) continue;
            Map.Entry<Integer, OpcodeStack.Item> e = putfieldsAt.entrySet().iterator().next();
            int pc = e.getKey();
            OpcodeStack.Item value = e.getValue();
            if (value.isNull() || value.hasConstantValue(0)) {
                ++priority;
            }
            SourceLineAnnotation fieldSetAt = SourceLineAnnotation.fromVisitedInstruction(this.getThisClass(), upcallMethod, pc);
            BugInstance bug = new BugInstance(this, "UR_UNINIT_READ_CALLED_FROM_SUPER_CONSTRUCTOR", priority).addClassAndMethod(this).addField(f);
            bug.addMethod(p.method).describe("METHOD_SUPERCLASS_CONSTRUCTOR").addSourceLine(p.getSourceLineAnnotation()).describe("SOURCE_LINE_CALLED_FROM_SUPERCLASS_AT").addMethod(upcall).describe("METHOD_CONSTRUCTOR").add(fieldSetAt).describe("SOURCE_LINE_FIELD_SET_TOO_LATE_AT");
            this.accumulator.accumulateBug(bug, this);
        }
    }

    @CheckForNull
    private XMethod getConstructorThatCallsSuperConstructor(XMethod superConstructor) {
        FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
        XMethod lookfor = superConstructor.getSignature().equals("()V") ? null : superConstructor;
        for (XMethod xMethod : this.getXClass().getXMethods()) {
            if (!xMethod.getName().equals("<init>") || fieldSummary.getSuperCall(xMethod) != lookfor) continue;
            return xMethod;
        }
        return null;
    }
}

