/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SAXBugCollectionHandler;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.BugMatcher;
import edu.umd.cs.findbugs.filter.ClassMatcher;
import edu.umd.cs.findbugs.filter.FieldMatcher;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.filter.LocalMatcher;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.MethodMatcher;
import edu.umd.cs.findbugs.filter.OrMatcher;
import edu.umd.cs.findbugs.filter.PriorityMatcher;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.xml.OutputStreamXMLOutput;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.IdentityHashMap;
import java.util.Iterator;
import javax.annotation.WillClose;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Filter
extends OrMatcher {
    private static final boolean DEBUG = SystemProperties.getBoolean("filter.debug");
    private IdentityHashMap<Matcher, Boolean> disabled = new IdentityHashMap();

    public Filter() {
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.disabled == null ? 0 : this.disabled.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return !(this.disabled == null ? other.disabled != null : !this.disabled.equals(other.disabled));
    }

    public boolean isEmpty() {
        return super.numberChildren() == 0;
    }

    public void setEnabled(Matcher m, boolean value) {
        if (value) {
            this.enable(m);
        } else {
            this.disable(m);
        }
    }

    public void disable(Matcher m) {
        this.disabled.put(m, true);
    }

    public boolean isEnabled(Matcher m) {
        return !this.disabled.containsKey(m);
    }

    public void enable(Matcher m) {
        this.disabled.remove(m);
    }

    public static Filter parseFilter(String fileName) throws IOException {
        return new Filter(fileName);
    }

    public Filter(String fileName) throws IOException {
        try {
            this.parse(fileName);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean contains(Matcher child) {
        return this.children.contains(child);
    }

    public void softAdd(Matcher child) {
        super.addChild(child);
    }

    public void addChild(Matcher child) {
        super.addChild(child);
        this.enable(child);
    }

    public void removeChild(Matcher child) {
        this.enable(child);
        super.removeChild(child);
    }

    public void clear() {
        this.disabled.clear();
        super.clear();
    }

    public boolean match(BugInstance bugInstance) {
        Iterator<Matcher> i = this.childIterator();
        while (i.hasNext()) {
            Matcher child = i.next();
            if (!this.isEnabled(child) || !child.match(bugInstance)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String fileName) throws IOException, SAXException {
        File file = new File(fileName);
        SAXBugCollectionHandler handler = new SAXBugCollectionHandler(this, file);
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setContentHandler(handler);
        xr.setErrorHandler(handler);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Reader reader = Util.getReader(fileInputStream);
            xr.parse(new InputSource(reader));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Util.closeSilently(fileInputStream);
            throw throwable;
        }
        Util.closeSilently(fileInputStream);
    }

    private static Matcher getMatcher(Element element) throws FilterException {
        String name = element.getName();
        if (name.equals("BugCode")) {
            return new BugMatcher(element.valueOf("@name"), "", "");
        }
        if (name.equals("Local")) {
            return new LocalMatcher(element.valueOf("@name"));
        }
        if (name.equals("BugPattern")) {
            return new BugMatcher("", element.valueOf("@name"), "");
        }
        if (name.equals("Bug")) {
            return new BugMatcher(element.valueOf("@code"), element.valueOf("@pattern"), element.valueOf("@category"));
        }
        if (name.equals("Priority") || name.equals("Confidence")) {
            return new PriorityMatcher(element.valueOf("@value"));
        }
        if (name.equals("Class")) {
            Attribute nameAttr = element.attribute("name");
            if (nameAttr == null) {
                throw new FilterException("Missing name attribute in Class element");
            }
            return new ClassMatcher(nameAttr.getValue());
        }
        if (name.equals("Package")) {
            Attribute nameAttr = element.attribute("name");
            if (nameAttr == null) {
                throw new FilterException("Missing name attribute in Package element");
            }
            String pName = nameAttr.getValue();
            pName = pName.startsWith("~") ? pName : "~" + pName.replace(".", "\\.");
            return new ClassMatcher(pName + "\\.[^.]+");
        }
        if (name.equals("Method")) {
            String nameValue;
            Attribute nameAttr = element.attribute("name");
            Attribute paramsAttr = element.attribute("params");
            Attribute returnsAttr = element.attribute("returns");
            Attribute roleAttr = element.attribute("role");
            if (nameAttr == null) {
                if (paramsAttr == null || returnsAttr == null) {
                    throw new FilterException("Method element must have eiter name or params and returnss attributes");
                }
                nameValue = "~.*";
            } else {
                nameValue = nameAttr.getValue();
            }
            if (!(paramsAttr == null && returnsAttr == null || paramsAttr != null && returnsAttr != null)) {
                throw new FilterException("Method element must have both params and returns attributes if either is used");
            }
            if (paramsAttr == null) {
                if (roleAttr == null) {
                    return new MethodMatcher(nameValue);
                }
                return new MethodMatcher(nameValue, roleAttr.getValue());
            }
            if (roleAttr == null) {
                return new MethodMatcher(nameValue, paramsAttr.getValue(), returnsAttr.getValue());
            }
            return new MethodMatcher(nameValue, paramsAttr.getValue(), returnsAttr.getValue(), roleAttr.getValue());
        }
        if (name.equals("Field")) {
            String nameValue;
            Attribute nameAttr = element.attribute("name");
            Attribute typeAttr = element.attribute("type");
            if (nameAttr == null) {
                if (typeAttr == null) {
                    throw new FilterException("Field element must have either name or type attribute");
                }
                nameValue = "~.*";
            } else {
                nameValue = nameAttr.getValue();
            }
            if (typeAttr == null) {
                return new FieldMatcher(nameValue);
            }
            return new FieldMatcher(nameValue, typeAttr.getValue());
        }
        if (name.equals("Or")) {
            OrMatcher orMatcher = new OrMatcher();
            Iterator i = element.elementIterator();
            while (i.hasNext()) {
                orMatcher.addChild(Filter.getMatcher((Element)i.next()));
            }
            return orMatcher;
        }
        throw new FilterException("Unknown element: " + name);
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 1) {
                System.err.println("Usage: " + Filter.class.getName() + " <filename>");
                System.exit(1);
            }
            Filter filter = new Filter(argv[0]);
            filter.writeAsXML(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsXML(@WillClose OutputStream out) throws IOException {
        OutputStreamXMLOutput xmlOutput = new OutputStreamXMLOutput(out);
        try {
            xmlOutput.beginDocument();
            xmlOutput.openTag("FindBugsFilter");
            this.writeBodyAsXML(xmlOutput);
            xmlOutput.closeTag("FindBugsFilter");
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            xmlOutput.finish();
            throw throwable;
        }
        xmlOutput.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEnabledMatchersAsXML(@WillClose OutputStream out) throws IOException {
        OutputStreamXMLOutput xmlOutput = new OutputStreamXMLOutput(out);
        try {
            xmlOutput.beginDocument();
            xmlOutput.openTag("FindBugsFilter");
            Iterator<Matcher> i = this.childIterator();
            while (i.hasNext()) {
                Matcher child = i.next();
                if (this.disabled.containsKey(child)) continue;
                child.writeXML(xmlOutput, false);
            }
            xmlOutput.closeTag("FindBugsFilter");
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xmlOutput.finish();
            throw throwable;
        }
        xmlOutput.finish();
    }

    public void writeBodyAsXML(XMLOutput xmlOutput) throws IOException {
        Iterator<Matcher> i = this.childIterator();
        while (i.hasNext()) {
            Matcher child = i.next();
            child.writeXML(xmlOutput, this.disabled.containsKey(child));
        }
    }
}

