/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.misc;

import java.math.BigDecimal;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.ASTNode;
import org.beetl.core.statement.GrammarToken;

public class ALU {
    public static final int NULL = 0;
    public static final int OBJECT = 1;
    public static final int STRING = 2;
    public static final int DOUBLE = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int INTEGER = 6;
    public static final int SHORT = 7;
    public static final int CHAR = 8;
    public static final int HS = 9;
    public static int scale = 12;
    public static int round = 5;

    public static int getBaseType(Object o1, Object o2) {
        if (o1 != null && o2 != null) {
            Class<?> cls2;
            Class<?> cls1 = o1.getClass();
            if (cls1 == String.class || (cls2 = o2.getClass()) == String.class) {
                return 2;
            }
            if (cls1 == Character.class && cls2 == Character.class) {
                return 8;
            }
            if (o1 instanceof Number && o2 instanceof Number) {
                if (cls1 == BigDecimal.class || cls2 == BigDecimal.class) {
                    return 9;
                }
                if (cls1 == Double.class || cls2 == Double.class) {
                    return 3;
                }
                if (cls1 == Float.class || cls2 == Float.class) {
                    return 4;
                }
                if (cls1 == Long.class || cls2 == Long.class) {
                    return 5;
                }
                if (cls1 == Integer.class || cls2 == Integer.class) {
                    return 6;
                }
                if (cls1 == Short.class || cls2 == Short.class) {
                    return 7;
                }
            }
            return 2;
        }
        return 0;
    }

    public static int getBaseType(Class cls1, Class cls2) {
        if (cls1 == String.class || cls2 == String.class) {
            return 2;
        }
        if (cls1 == Character.class && cls2 == Character.class) {
            return 8;
        }
        if (Number.class.isAssignableFrom(cls1) && Number.class.isAssignableFrom(cls2)) {
            if (cls1 == BigDecimal.class || cls2 == BigDecimal.class) {
                return 9;
            }
            if (cls1 == Double.class || cls2 == Double.class) {
                return 3;
            }
            if (cls1 == Float.class || cls2 == Float.class) {
                return 4;
            }
            if (cls1 == Long.class || cls2 == Long.class) {
                return 5;
            }
            if (cls1 == Integer.class || cls2 == Integer.class) {
                return 6;
            }
            if (cls1 == Short.class || cls2 == Short.class) {
                return 7;
            }
        }
        return 1;
    }

    public static Class getBaseTypeClass(Class cls1, Class cls2) {
        int type = ALU.getBaseType(cls1, cls2);
        switch (type) {
            case 6: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
            case 5: {
                return Long.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Float.class;
            }
            case 7: {
                return Short.class;
            }
            case 9: {
                return BigDecimal.class;
            }
        }
        return Object.class;
    }

    public static int getNumberType(Number o1) {
        if (o1 != null) {
            Class<?> cls = o1.getClass();
            if (cls == Integer.class) {
                return 6;
            }
            if (cls == Long.class) {
                return 5;
            }
            if (cls == Short.class) {
                return 7;
            }
            if (cls == Float.class) {
                return 4;
            }
            if (cls == Double.class) {
                return 3;
            }
            if (cls == BigDecimal.class) {
                return 9;
            }
        }
        return 0;
    }

    public static int getBaseType(Object o1) {
        if (o1 != null) {
            Class<?> cls = o1.getClass();
            if (cls == String.class) {
                return 2;
            }
            if (cls == Integer.class) {
                return 6;
            }
            if (cls == Long.class) {
                return 5;
            }
            if (cls == Short.class) {
                return 7;
            }
            if (cls == Float.class) {
                return 4;
            }
            if (cls == Double.class) {
                return 3;
            }
            if (cls == Character.class) {
                return 8;
            }
            if (cls == BigDecimal.class) {
                return 9;
            }
            return 1;
        }
        return 0;
    }

    public static Object plusOne(Object o1, ASTNode node) {
        if (o1 != null) {
            if (o1 instanceof Number) {
                Number num = (Number)o1;
                switch (ALU.getNumberType(num)) {
                    case 6: {
                        return num.intValue() + 1;
                    }
                    case 5: {
                        return num.longValue() + 1L;
                    }
                    case 3: {
                        return num.doubleValue() + 1.0;
                    }
                    case 4: {
                        return Float.valueOf(num.floatValue() + 1.0f);
                    }
                    case 7: {
                        return (short)(num.intValue() + 1);
                    }
                    case 9: {
                        BigDecimal bd = (BigDecimal)o1;
                        return bd.add(BigDecimal.ONE);
                    }
                }
            } else {
                throw ALU.numberExpectedException(o1, node);
            }
        }
        throw ALU.valueIsNullException(o1, node);
    }

    public static Object minusOne(Object o1, ASTNode node) {
        if (o1 != null) {
            if (o1 instanceof Number) {
                Number num = (Number)o1;
                switch (ALU.getNumberType(num)) {
                    case 6: {
                        return num.intValue() - 1;
                    }
                    case 5: {
                        return num.longValue() - 1L;
                    }
                    case 3: {
                        return num.doubleValue() - 1.0;
                    }
                    case 4: {
                        return Float.valueOf(num.floatValue() - 1.0f);
                    }
                    case 7: {
                        return (short)(num.intValue() - 1);
                    }
                    case 9: {
                        BigDecimal bd = (BigDecimal)o1;
                        return bd.min(BigDecimal.ONE);
                    }
                }
            } else {
                throw ALU.numberExpectedException(o1, node);
            }
        }
        throw ALU.valueIsNullException(o1, node);
    }

    public static Object plus(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 2: {
                    return String.valueOf(o1).concat(String.valueOf(o2));
                }
                case 6: {
                    return ((Number)o1).intValue() + ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() + ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() + ((Number)o2).doubleValue();
                }
                case 4: {
                    return Float.valueOf(((Number)o1).floatValue() + ((Number)o2).floatValue());
                }
                case 7: {
                    return (short)(((Number)o1).intValue() + ((Number)o2).intValue());
                }
                case 8: {
                    return Character.valueOf((char)(((Number)o1).intValue() + ((Number)o2).intValue()));
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.add(b2);
                }
            }
            throw ALU.UnsupportedTypeException(o1, o2, node1, node2, "+");
        }
        if (o1 != null) {
            switch (ALU.getBaseType(o1)) {
                case 2: {
                    return o1;
                }
            }
            throw ALU.valueIsNullException(o1, o2, node1, node2);
        }
        if (o2 != null) {
            switch (ALU.getBaseType(o2)) {
                case 2: {
                    return o2;
                }
            }
            throw ALU.valueIsNullException(o1, o2, node1, node2);
        }
        return o1 != null ? o1 : o2;
    }

    public static Object minus(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 6: {
                    return ((Number)o1).intValue() - ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() - ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() - ((Number)o2).doubleValue();
                }
                case 4: {
                    return Float.valueOf(((Number)o1).floatValue() - ((Number)o2).floatValue());
                }
                case 7: {
                    return (short)(((Number)o1).intValue() - ((Number)o2).intValue());
                }
                case 8: {
                    return Character.valueOf((char)(((Number)o1).intValue() - ((Number)o2).intValue()));
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.subtract(b2);
                }
            }
            throw ALU.UnsupportedTypeException(o1, o2, node1, node2, "-");
        }
        throw ALU.valueIsNullException(o1, o2, node1, node2);
    }

    public static Object negative(Object o1, ASTNode node) {
        if (o1 != null) {
            switch (ALU.getBaseType(o1)) {
                case 6: {
                    return -((Number)o1).intValue();
                }
                case 5: {
                    return -((Number)o1).longValue();
                }
                case 3: {
                    return -((Number)o1).doubleValue();
                }
                case 4: {
                    return Float.valueOf(-((Number)o1).floatValue());
                }
                case 7: {
                    return (int)(-((Number)o1).shortValue());
                }
                case 9: {
                    BigDecimal bd = (BigDecimal)o1;
                    return bd;
                }
            }
            throw new RuntimeException("value not a number");
        }
        throw ALU.valueIsNullException(o1, node);
    }

    public static Object mult(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 6: {
                    return ((Number)o1).intValue() * ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() * ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() * ((Number)o2).doubleValue();
                }
                case 4: {
                    return Float.valueOf(((Number)o1).floatValue() * ((Number)o2).floatValue());
                }
                case 7: {
                    return (short)(((Number)o1).intValue() * ((Number)o2).intValue());
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.multiply(b2);
                }
            }
            throw ALU.UnsupportedTypeException(o1, o2, node1, node2, "*");
        }
        throw ALU.valueIsNullException(o1, o2, node1, node2);
    }

    public static Object div(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    double c = ((Number)o2).doubleValue();
                    if (c == 0.0) {
                        BeetlException ex = new BeetlException("DIV_ZERO_ERROR");
                        ex.pushToken(node2.token);
                        throw ex;
                    }
                    double a = ((Number)o1).doubleValue() / ((Number)o2).doubleValue();
                    return ALU.trim(a, (Number)o1, (Number)o2);
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    BigDecimal b = b1.divide(b2, scale, round);
                    return b.stripTrailingZeros();
                }
            }
            throw ALU.UnsupportedTypeException(o1, o2, node1, node2, "/");
        }
        throw ALU.valueIsNullException(o1, o2, node1, node2);
    }

    private static Number trim(double d, Number a1, Number a2) {
        Object n1 = null;
        Object n2 = null;
        if (a1 instanceof BigDecimal || a2 instanceof BigDecimal) {
            return d;
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            return d;
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf((float)d);
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            if (d != (double)((long)d)) {
                return d;
            }
            return (long)d;
        }
        if (n1 instanceof Integer || n2 instanceof Integer) {
            if (d != (double)((int)d)) {
                return d;
            }
            return (int)d;
        }
        if (d != (double)((short)d)) {
            return d;
        }
        return (short)d;
    }

    public static Object mod(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 6: {
                    return ((Number)o1).intValue() % ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() % ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() % ((Number)o2).doubleValue();
                }
                case 4: {
                    return Float.valueOf(((Number)o1).floatValue() % ((Number)o2).floatValue());
                }
                case 7: {
                    return (short)(((Number)o1).intValue() % ((Number)o2).intValue());
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.divide(b2);
                }
            }
            throw ALU.UnsupportedTypeException(o1, o2, node1, node2, "%");
        }
        throw ALU.valueIsNullException(o1, o2, node1, node2);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            switch (ALU.getBaseType(o1, o2)) {
                case 6: 
                case 7: {
                    return ((Number)o1).intValue() == ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() == ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() == ((Number)o2).doubleValue();
                }
                case 4: {
                    return ((Number)o1).floatValue() == ((Number)o2).floatValue();
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.equals(b2);
                }
            }
        } else {
            if (o1 instanceof Enum) {
                return o1.toString().equals(o2);
            }
            if (o2 instanceof Enum) {
                return o2.toString().equals(o1);
            }
        }
        return false;
    }

    public static boolean notEquals(Object o1, Object o2) {
        return !ALU.equals(o1, o2);
    }

    public static boolean greater(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 8: {
                    return (o1 instanceof Number ? ((Number)o1).intValue() : (int)((Character)o1).charValue()) > (o2 instanceof Number ? ((Number)o2).intValue() : (int)((Character)o2).charValue());
                }
                case 6: 
                case 7: {
                    return ((Number)o1).intValue() > ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() > ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() > ((Number)o2).doubleValue();
                }
                case 4: {
                    return ((Number)o1).floatValue() > ((Number)o2).floatValue();
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.compareTo(b2) > 0;
                }
            }
            int result = ALU.compareObject(o1, o2, node1, node2, ">");
            if (result == -2) {
                throw ALU.UnsupportedTypeException(o1, o2, node1, node2, ">");
            }
            return result > 0;
        }
        throw ALU.valueIsNullException(o1, o2, node1, node2);
    }

    public static boolean greaterEquals(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 8: {
                    return (o1 instanceof Number ? ((Number)o1).intValue() : (int)((Character)o1).charValue()) >= (o2 instanceof Number ? ((Number)o2).intValue() : (int)((Character)o2).charValue());
                }
                case 6: 
                case 7: {
                    return ((Number)o1).intValue() >= ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() >= ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() >= ((Number)o2).doubleValue();
                }
                case 4: {
                    return ((Number)o1).floatValue() >= ((Number)o2).floatValue();
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.compareTo(b2) >= 0;
                }
            }
            int result = ALU.compareObject(o1, o2, node1, node2, ">=");
            if (result == -2) {
                throw ALU.UnsupportedTypeException(o1, o2, node1, node2, ">=");
            }
            return result >= 0;
        }
        throw ALU.valueIsNullException(o1, o2, node1, node2);
    }

    public static boolean less(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 8: {
                    return (o1 instanceof Number ? ((Number)o1).intValue() : (int)((Character)o1).charValue()) < (o2 instanceof Number ? ((Number)o2).intValue() : (int)((Character)o2).charValue());
                }
                case 6: 
                case 7: {
                    return ((Number)o1).intValue() < ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() < ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() < ((Number)o2).doubleValue();
                }
                case 4: {
                    return ((Number)o1).floatValue() < ((Number)o2).floatValue();
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.compareTo(b2) < 0;
                }
            }
            int result = ALU.compareObject(o1, o2, node1, node2, "<");
            if (result == -2) {
                throw ALU.UnsupportedTypeException(o1, o2, node1, node2, "<");
            }
            return result < 0;
        }
        throw ALU.valueIsNullException(o1, o2, node1, node2);
    }

    public static boolean lessEquals(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        if (o1 != null && o2 != null) {
            switch (ALU.getBaseType(o1, o2)) {
                case 8: {
                    return (o1 instanceof Number ? ((Number)o1).intValue() : (int)((Character)o1).charValue()) <= (o2 instanceof Number ? ((Number)o2).intValue() : (int)((Character)o2).charValue());
                }
                case 6: 
                case 7: {
                    return ((Number)o1).intValue() <= ((Number)o2).intValue();
                }
                case 5: {
                    return ((Number)o1).longValue() <= ((Number)o2).longValue();
                }
                case 3: {
                    return ((Number)o1).doubleValue() <= ((Number)o2).doubleValue();
                }
                case 4: {
                    return ((Number)o1).floatValue() <= ((Number)o2).floatValue();
                }
                case 9: {
                    BigDecimal b1 = ALU.getBigDecimal(o1);
                    BigDecimal b2 = ALU.getBigDecimal(o2);
                    return b1.compareTo(b2) <= 0;
                }
            }
            int result = ALU.compareObject(o1, o2, node1, node2, "<=");
            if (result == -2) {
                throw ALU.UnsupportedTypeException(o1, o2, node1, node2, "<=");
            }
            return result <= 0;
        }
        throw ALU.valueIsNullException(o1, o2, node1, node2);
    }

    private static int compareObject(Object a, Object b, ASTNode node1, ASTNode node2, String type) {
        if (a instanceof Comparable && b instanceof Comparable) {
            Comparable ac = (Comparable)a;
            try {
                int result = ac.compareTo(b);
                if (result > 0) {
                    return 1;
                }
                if (result < 0) {
                    return -1;
                }
                return result;
            }
            catch (RuntimeException e) {
                BeetlException ex = new BeetlException("EXPRESSION_NOT_COMPATIBLE", e);
                GrammarToken token = GrammarToken.createToken(node1.token.text + " " + node2.token.text, node1.token.line);
                ex.pushToken(token);
                throw ex;
            }
        }
        return -2;
    }

    private static RuntimeException UnsupportedTypeException(Object o1, Object o2, ASTNode node1, ASTNode node2, String type) {
        BeetlException ex = new BeetlException("EXPRESSION_NOT_COMPATIBLE", o1.getClass() + type + o2.getClass());
        GrammarToken token = GrammarToken.createToken(node1.token.text + type + node2.token.text, node1.token.line);
        ex.pushToken(token);
        throw ex;
    }

    private static RuntimeException numberExpectedException(Object o1, ASTNode node1) {
        BeetlException ex = new BeetlException("NUMBER_EXPECTED_ERROR");
        ex.pushToken(node1.token);
        throw ex;
    }

    private static RuntimeException valueIsNullException(Object o1, ASTNode node1) {
        BeetlException ex = new BeetlException("NULL");
        ex.pushToken(node1.token);
        throw ex;
    }

    private static BeetlException valueIsNullException(Object o1, Object o2, ASTNode node1, ASTNode node2) {
        BeetlException ex = null;
        if (o1 == null) {
            ex = new BeetlException("NULL");
            ex.pushToken(node1.token);
        } else {
            ex = new BeetlException("NULL");
            ex.pushToken(node2.token);
        }
        throw ex;
    }

    private static BigDecimal getBigDecimal(Object o) {
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        return new BigDecimal(o.toString());
    }

    public static Boolean isTrue(Object o, ASTNode node) {
        if (o == null) {
            BeetlException be = new BeetlException("NULL");
            be.pushToken(node.token);
            throw be;
        }
        if (Boolean.TRUE == o) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE == o) {
            return Boolean.FALSE;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        BeetlException ex = new BeetlException("BOOLEAN_EXPECTED_ERROR", o.getClass().toString());
        ex.pushToken(node.token);
        throw ex;
    }
}

