/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.resource.FileResourceLoader;

public class FileResource
extends Resource {
    File file = null;
    long lastModified = 0L;

    public FileResource(File file, String id, ResourceLoader loader) {
        super(id, loader);
        this.file = file;
        this.lastModified = file.lastModified();
    }

    @Override
    public Reader openReader() {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), ((FileResourceLoader)this.getResourceLoader()).charset));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (FileNotFoundException e) {
            FileResourceLoader loader = (FileResourceLoader)this.resourceLoader;
            BeetlException be = new BeetlException("TEMPLATE_LOAD_ERROR", " \u6a21\u677f\u6839\u76ee\u5f55\u4e3a " + loader.getRoot());
            be.resourceId = this.id;
            throw be;
        }
        return br;
    }

    @Override
    public boolean isModified() {
        return this.lastModified != this.file.lastModified();
    }
}

