/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.ObjectAA;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.VarAssignStatement;
import org.beetl.core.statement.VarAttribute;
import org.beetl.core.statement.VarRef;
import org.beetl.core.statement.VarSquareAttribute;

public class VarRefAssignStatement
extends VarAssignStatement {
    protected int varIndex;
    public Expression exp;
    public VarRef varRef;
    protected VarAttribute lastVarAttribute = null;

    public VarRefAssignStatement(Expression exp, VarRef varRef) {
        super(exp, exp.token);
        this.exp = exp;
        this.varRef = varRef;
        this.lastVarAttribute = varRef.attributes[varRef.attributes.length - 1];
    }

    @Override
    public void execute(Context ctx) {
        Object value = this.exp.evaluate(ctx);
        Object obj = this.varRef.evaluateUntilLast(ctx);
        Object key = null;
        key = this.lastVarAttribute instanceof VarSquareAttribute ? ((VarSquareAttribute)this.lastVarAttribute).exp.evaluate(ctx) : this.lastVarAttribute.name;
        try {
            ObjectAA.defaultObjectAA().setValue(obj, key, value);
        }
        catch (ClassCastException ex) {
            BeetlException bx = new BeetlException("ATTRIBUTE_INVALID", ex);
            bx.pushToken(this.lastVarAttribute.token);
            throw bx;
        }
        catch (BeetlException be) {
            be.pushToken(this.lastVarAttribute.token);
            throw be;
        }
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }

    @Override
    public void setVarIndex(int varIndex) {
        this.varIndex = varIndex;
    }

    @Override
    public void infer(InferContext inferCtx) {
    }
}

