/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.lab;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.beetl.core.Configuration;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.beetl.core.lab.TestTag;
import org.beetl.core.lab.TestUser;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.statement.PlaceholderST;

public class Test {
    public static void main(String[] args) throws Exception {
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader("org/beetl/core/lab/");
        Configuration cfg = Configuration.defaultConfiguration();
        cfg.setDirectByteOutput(true);
        cfg.getResourceMap().put("tagRoot", "/");
        cfg.getPkgList().add("org.beetl.core.lab.");
        GroupTemplate gt = new GroupTemplate(resourceLoader, cfg);
        cfg.setStatementStart("<%");
        cfg.setStatementEnd("%>");
        gt.registerFunction("test", new TestFun());
        gt.registerTag("test", TestTag.class);
        PlaceholderST.output = new PlaceholderST.Output(){

            @Override
            public void write(Context ctx, Object value) throws IOException {
                ctx.byteWriter.writeString(value == null ? "null" : value.toString());
            }
        };
        ArrayList<TestUser> list = new ArrayList<TestUser>();
        list.add(null);
        list.add(new TestUser("abc"));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("key", 123);
        for (int i = 0; i < 2; ++i) {
            Template t = gt.getTemplate("/hello.txt");
            t.binding("a", map);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            try {
                t.renderTo(bs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println(new String(bs.toByteArray()));
        }
    }

    public static void testOne() {
    }

    public static class TestFun
    implements Function {
        public String[] call(Object[] paras, Context ctx) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("hi");
            list.add("joel");
            System.out.println("list -----");
            return list.toArray(new String[0]);
        }
    }
}

