/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beetl.core.BodyContent;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.MethodInvoker;
import org.beetl.core.om.ObjectUtil;

public class Type
implements Serializable {
    public Class cls;
    public Type[] types = null;
    public static final Type ObjectType = new Type(Object.class);
    public static final Type BooleanType = new Type(Boolean.class);
    public static final Type StringType = new Type(String.class);
    public static final Type NumberType = new Type(Number.class);
    public static final Type ListType = new Type(List.class);
    public static final Type MapType = new Type(Map.class);
    public static final Type NULLType = new Type(NULLClass.class);
    public static final Type BodyContentType = new Type(BodyContent.class);
    public static final Type mapEntryType = new Type(Map.Entry.class);
    public static final Type IntegerType = new Type(Integer.class);
    public static final Type ShortType = new Type(Short.class);
    public static final Type FloatType = new Type(Float.class);
    public static final Type DoubleType = new Type(Double.class);
    public static final Class[] StringPara = new Class[]{String.class};
    public static final Class[] GetMethodPara = new Class[0];

    public Type() {
    }

    public Type(Class cls) {
        this.cls = cls;
    }

    public Type(Class cls, Class c1) {
        this.cls = cls;
        this.types = new Type[]{new Type(c1)};
    }

    public Type(Class cls, Class c1, Class c2) {
        this.cls = cls;
        this.types = new Type[]{new Type(c1), new Type(c2)};
    }

    public Type(Class cls, Type type) {
        this.cls = cls;
        this.types = new Type[]{type};
    }

    public Type getType(String attrName) throws BeetlException {
        if (Map.class.isAssignableFrom(this.cls)) {
            if (this.types != null) {
                return this.types[1];
            }
            return ObjectType;
        }
        if (Collection.class.isAssignableFrom(this.cls)) {
            if (this.types != null) {
                return this.types[0];
            }
            return ObjectType;
        }
        if (this.cls == Object.class) {
            return new Type(Object.class);
        }
        MethodInvoker invoker = ObjectUtil.getInvokder(this.cls, attrName);
        if (invoker == null) {
            BeetlException be = new BeetlException("GET_CALL_ERROR");
            throw be;
        }
        Class returnCls = invoker.getReturnType();
        if (returnCls == Object.class) {
            return ObjectType;
        }
        return new Type(returnCls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.cls.toString());
        if (this.types != null) {
            sb.append("<");
            for (Type t : this.types) {
                sb.append(t).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(">");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        Type t = (Type)o;
        return t.cls == this.cls;
    }

    public Type copy() {
        Type type = new Type(this.cls);
        if (this.types != null) {
            Type[] copyTypes = new Type[this.types.length];
            for (int i = 0; i < this.types.length; ++i) {
                copyTypes[i] = new Type(this.types[i].cls);
            }
            type.types = copyTypes;
        }
        return type;
    }

    public class NULLClass {
    }
}

