/*
 * Decompiled with CFR 0.152.
 */
package com.ibeetl.starter;

import com.ibeetl.starter.BeetlMapperScannerRegister;
import com.ibeetl.starter.BeetlSqlCustomize;
import com.ibeetl.starter.BeetlSqlProperties;
import java.util.Properties;
import javax.sql.DataSource;
import org.beetl.core.om.ObjectUtil;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.ext.spring4.BeetlSqlDataSource;
import org.beetl.sql.ext.spring4.SqlManagerFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(name={"beetlsql.enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={BeetlMapperScannerRegister.class})
public class BeetlSqlConfig {
    @Autowired(required=false)
    BeetlSqlCustomize cust;

    @Bean(name={"sqlManagerFactoryBean"})
    @ConditionalOnMissingBean(value={SqlManagerFactoryBean.class})
    public SqlManagerFactoryBean getSqlManagerFactoryBean(BeetlSqlDataSource source, Environment env) throws Exception {
        Interceptor[] interceptorArray;
        BeetlSqlProperties beetlSqlProperties = new BeetlSqlProperties(env);
        SqlManagerFactoryBean factory = new SqlManagerFactoryBean();
        factory.setCs(source);
        factory.setDbStyle((DBStyle)ObjectUtil.tryInstance((String)beetlSqlProperties.getDbStyle()));
        if (beetlSqlProperties.dev.booleanValue()) {
            Interceptor[] interceptorArray2 = new Interceptor[1];
            interceptorArray = interceptorArray2;
            interceptorArray2[0] = new DebugInterceptor();
        } else {
            interceptorArray = new Interceptor[]{};
        }
        factory.setInterceptors(interceptorArray);
        factory.setNc((NameConversion)ObjectUtil.tryInstance((String)beetlSqlProperties.getNameConversion()));
        ClasspathLoader loader = new ClasspathLoader(beetlSqlProperties.getSqlPath());
        Properties ps = new Properties();
        ps.put("PRODUCT_MODE", beetlSqlProperties.dev != false ? "false" : "true");
        factory.setExtProperties(ps);
        factory.setSqlLoader((SQLLoader)loader);
        if (this.cust != null) {
            this.cust.customize(factory);
        }
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={BeetlSqlDataSource.class})
    public BeetlSqlDataSource beetlSqlDataSource(DataSource dataSource) {
        BeetlSqlDataSource source = new BeetlSqlDataSource();
        source.setMasterSource(dataSource);
        return source;
    }
}

