/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.beetl.sql.core.kit.CaseInsensitiveHashMap;

public class ThreadSafeCaseInsensitiveHashMap
extends CaseInsensitiveHashMap {
    private static final long serialVersionUID = 9178606903603606032L;
    private final Map<String, String> lowerCaseMap = new HashMap<String, String>();
    final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    @Override
    public boolean containsKey(Object key) {
        try {
            this.r.lock();
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Object get(Object key) {
        try {
            this.r.lock();
            Object object = super.get(key);
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String key, Object value) {
        try {
            this.w.lock();
            Object object = super.put(key, value);
            return object;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void putAll(Map m) {
        try {
            this.w.lock();
            super.putAll(m);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public Object remove(Object key) {
        try {
            this.w.lock();
            Object object = super.remove(key);
            return object;
        }
        finally {
            this.w.unlock();
        }
    }
}

