/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json;

import java.util.Comparator;
import java.util.Map;
import org.beetl.json.node.PojoAttributeNode;

public class AttributeComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        int s2;
        PojoAttributeNode n1 = (PojoAttributeNode)o1;
        PojoAttributeNode n2 = (PojoAttributeNode)o2;
        int s1 = this.score(n1.getAttrType());
        if (s1 == (s2 = this.score(n2.getAttrType()))) {
            return n1.getAttrName().compareTo(n2.getAttrName());
        }
        return s1 - s2;
    }

    private int score(Class type) {
        if (type.isArray()) {
            return 3;
        }
        Package pkg = type.getPackage();
        if (pkg == null) {
            return 1;
        }
        String pkgName = type.getPackage().getName();
        if (pkgName.startsWith("java.lang")) {
            return 1;
        }
        if (pkgName.startsWith("java.util")) {
            if (Iterable.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
                return 4;
            }
            return 3;
        }
        return 2;
    }
}

