/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beetl.json.AttribiuteErrorHandler;
import org.beetl.json.AttributeComparator;
import org.beetl.json.Format;
import org.beetl.json.JsonException;
import org.beetl.json.JsonWriter;
import org.beetl.json.Location;
import org.beetl.json.LocationAction;
import org.beetl.json.OutputNodeKey;
import org.beetl.json.Policy;
import org.beetl.json.PolicyCache;
import org.beetl.json.PolicyParser;
import org.beetl.json.ext.JsonDateFormat;
import org.beetl.json.ext.JsonNumberFormat;
import org.beetl.json.util.StringQuoteCheck;

public class JsonTool {
    PolicyCache cache = new PolicyCache(this);
    List<Location> defaultLocs = new ArrayList<Location>();
    public boolean singleQuotes = false;
    Map<Class, Format> formats = new HashMap<Class, Format>();
    public Map<String, LocationAction> userActions;
    List<String> parseStops;
    public Map<String, String> alias;
    Pattern pattern;
    public AttribiuteErrorHandler attributeErrorHander;
    public static final String EMPTY_POLICY = "";
    public boolean ignoreClientIOError;
    public boolean pretty;
    public boolean orderAttribute;
    public Comparator orderAttributeComparator;

    public JsonTool() {
        JsonDateFormat df = new JsonDateFormat();
        this.formats.put(java.util.Date.class, df);
        this.formats.put(Date.class, df);
        this.formats.put(Time.class, df);
        this.formats.put(Timestamp.class, df);
        JsonNumberFormat nf = new JsonNumberFormat();
        this.formats.put(Short.class, nf);
        this.formats.put(Long.class, nf);
        this.formats.put(Integer.class, nf);
        this.formats.put(Float.class, nf);
        this.formats.put(Double.class, nf);
        this.formats.put(BigInteger.class, nf);
        this.formats.put(BigDecimal.class, nf);
        this.userActions = new HashMap<String, LocationAction>();
        this.userActions.put("quote", new StringQuoteCheck());
        this.parseStops = new ArrayList<String>();
        this.alias = new HashMap<String, String>();
        this.alias.put("#ju", "java.util");
        this.alias.put("#jl", "java.lang");
        this.alias.put("#String", "java.lang.String");
        this.pattern = Pattern.compile("#[_a-zA-Z][_a-zA-Z0-9]*");
        this.parseStops.add("java.lang.Object");
        this.attributeErrorHander = new AttribiuteErrorHandler();
        this.ignoreClientIOError = false;
        this.pretty = false;
        this.orderAttribute = true;
        this.orderAttributeComparator = new AttributeComparator();
    }

    public String serialize(Object obj) {
        if (obj == null) {
            return "{}";
        }
        Policy po = this.getPolicy(obj.getClass(), EMPTY_POLICY);
        try {
            return po.toJson(obj, this);
        }
        catch (IOException e) {
            throw new RuntimeException("\u4e0d\u53ef\u80fd\u53d1\u751f");
        }
    }

    public String serialize(Object obj, String policy) {
        if (obj == null) {
            return "{}";
        }
        Policy po = this.getPolicy(obj.getClass(), policy);
        try {
            return po.toJson(obj, this);
        }
        catch (IOException e) {
            throw new RuntimeException("\u4e0d\u53ef\u80fd\u53d1\u751f");
        }
    }

    public String serialize(Object obj, String ... policys) {
        if (obj == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        for (String p : policys) {
            sb.append(p).append(",");
        }
        sb.setLength(sb.length() - 1);
        Policy po = this.getPolicy(obj.getClass(), sb.toString());
        try {
            return po.toJson(obj, this);
        }
        catch (IOException e) {
            throw new RuntimeException("\u4e0d\u53ef\u80fd\u53d1\u751f");
        }
    }

    public void serialize(Object obj, Writer w, String policy) {
        block3: {
            try {
                if (obj == null) {
                    w.write("{}");
                }
                Policy po = this.getPolicy(obj.getClass(), policy);
                po.toJson(w, obj, this);
            }
            catch (IOException e) {
                if (this.ignoreClientIOError) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public void serialize(Object obj, Writer w, String ... policys) {
        block4: {
            try {
                if (obj == null) {
                    w.write("{}");
                }
                StringBuilder sb = new StringBuilder();
                for (String p : policys) {
                    sb.append(p).append(",");
                }
                sb.setLength(sb.length() - 1);
                Policy po = this.getPolicy(obj.getClass(), sb.toString());
                po.toJson(w, obj, this);
            }
            catch (IOException e) {
                if (this.ignoreClientIOError) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public void serialize(Object obj, Writer w) {
        block3: {
            try {
                if (obj == null) {
                    w.write("{}");
                }
                Policy po = this.getPolicy(obj.getClass(), EMPTY_POLICY);
                po.toJson(w, obj, this);
            }
            catch (IOException e) {
                if (this.ignoreClientIOError) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public void serializeJW(JsonWriter w, OutputNodeKey field, Object obj, List<Location> inherit) {
        block3: {
            try {
                if (obj == null) {
                    w.writeNull();
                    return;
                }
                Policy po = this.getPolicy(obj.getClass(), EMPTY_POLICY, inherit);
                po.toJson(w, field, obj);
            }
            catch (IOException e) {
                if (this.ignoreClientIOError) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public void serializeJW(JsonWriter w, OutputNodeKey field, Object obj, String policy, List<Location> inherit) {
        block3: {
            try {
                if (obj == null) {
                    w.writeNull();
                    return;
                }
                Policy po = this.getPolicy(obj.getClass(), policy, inherit);
                po.toJson(w, field, obj);
            }
            catch (IOException e) {
                if (this.ignoreClientIOError) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    private Policy getPolicy(Class c, String policy) {
        return this.cache.getPolicy(c, policy, null);
    }

    private Policy getPolicy(Class c, String policy, List<Location> inherit) {
        return this.cache.getPolicy(c, policy, inherit);
    }

    public void addFormat(Class type, Format format) {
        this.formats.put(type, format);
    }

    public Format getFormat(Class type) {
        return this.formats.get(type);
    }

    public void addAction(String name, LocationAction action) {
        this.userActions.put(name, action);
    }

    public LocationAction getAction(String name) {
        return this.userActions.get(name);
    }

    public void addLocationAction(String loc, String action) {
        Location location = PolicyParser.parse(null, loc, action, this);
        this.defaultLocs.add(location);
    }

    public void addPolicy(String policy) {
        List<Location> list = PolicyParser.parseStringPolicy(null, policy, this);
        this.defaultLocs.addAll(list);
    }

    public void addParseStopClass(String clsName) {
        this.parseStops.add(clsName);
    }

    public boolean isStopParse(String clsName) {
        return this.parseStops.contains(clsName);
    }

    public void addAlias(String shortName, String name) {
        this.alias.put("#" + shortName, name);
    }

    public String getNameByAlias(String str) {
        Matcher matcher = this.pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int end;
            int start = matcher.start();
            String key = str.substring(start, end = matcher.end());
            String realName = this.alias.get(key);
            if (realName == null) {
                throw new JsonException(0, "\u522b\u540d\u672a\u627e\u5230:" + key + "\u5728" + str);
            }
            matcher.appendReplacement(sb, realName);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

