/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json;

import org.beetl.json.JsonException;
import org.beetl.json.JsonTool;
import org.beetl.json.LocationAction;
import org.beetl.json.OutputNode;
import org.beetl.json.action.AsJsonAction;
import org.beetl.json.action.ClassCycleIgnoreAction;
import org.beetl.json.action.ClassCycleIncludeAction;
import org.beetl.json.action.DirectOutpuAction;
import org.beetl.json.action.FormatAction;
import org.beetl.json.action.IValueAction;
import org.beetl.json.action.IfAction;
import org.beetl.json.action.KeyChangeAction;
import org.beetl.json.action.ThisExcludeAction;
import org.beetl.json.action.ThisIncludeAction;
import org.beetl.json.action.ThisOrderAction;
import org.beetl.json.action.ValueChangeAction;
import org.beetl.json.action.ValueIgnoreAction;
import org.beetl.json.loc.IndexLocation;

public abstract class Location {
    protected LocationAction action = null;
    protected JsonTool tool = null;
    protected Location nextLoc = null;

    public LocationAction getAction() {
        return this.action;
    }

    public void setAction(LocationAction action) {
        this.action = action;
    }

    public abstract boolean match(OutputNode var1, Class var2, String var3, JsonTool var4);

    protected boolean testNextLoc(boolean selfMatch, OutputNode node, Class type, String field, JsonTool tool) {
        if (selfMatch) {
            if (this.nextLoc != null) {
                if (this.nextLoc instanceof IndexLocation) {
                    node.addIndexLocations((IndexLocation)this.nextLoc);
                } else {
                    node.addInHeritedPolicy(this.nextLoc);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public LocationAction parseAction(String act) {
        LocationAction action = null;
        if (act.startsWith("f")) {
            action = this.parserFormat(act);
        } else if (act.startsWith("nn")) {
            action = this.parserNewName(act);
        } else if (act.startsWith("?")) {
            action = this.parserIfAction(act);
        } else if (act.startsWith("$.")) {
            action = this.parserValueChange(act);
        } else if (act.startsWith("ci")) {
            action = this.parserCycleIngore(act);
        } else if (act.startsWith("cu")) {
            action = this.parserCycleUsing(act);
        } else if (act.startsWith("!")) {
            action = this.parserUserDefine(act);
        } else if (act.startsWith("i")) {
            action = this.parserIgnoreAction(act);
        } else if (act.startsWith("u")) {
            action = this.parserAttributeUsing(act);
        } else if (act.startsWith("o")) {
            action = this.parserOrder(act);
        } else if (act.startsWith("->")) {
            action = this.parserDirectOutput(act);
        } else if (act.equals("asJson")) {
            action = new AsJsonAction();
        }
        return action;
    }

    protected LocationAction parserIgnoreAction(String act) {
        LocationAction action = null;
        if (act.length() == 1) {
            action = new ValueIgnoreAction();
        } else {
            String names = act.substring(2, act.length() - 1);
            action = new ThisExcludeAction(names);
        }
        return action;
    }

    protected LocationAction parserAttributeUsing(String act) {
        ThisIncludeAction action = null;
        String names = act.substring(2, act.length() - 1);
        action = new ThisIncludeAction(names);
        return action;
    }

    protected LocationAction parserOrder(String act) {
        ThisOrderAction action = null;
        String names = act.substring(2, act.length() - 1);
        action = new ThisOrderAction(names);
        return action;
    }

    protected LocationAction parserDirectOutput(String act) {
        String output = act.substring(2);
        return new DirectOutpuAction(output);
    }

    protected LocationAction parserFormat(String act) {
        FormatAction action = null;
        if (act.length() > 1 && act.charAt(1) == '/') {
            String format = act.substring(2, act.length() - 1);
            action = new FormatAction(format);
        } else {
            action = new FormatAction("");
        }
        return action;
    }

    protected LocationAction parserNewName(String act) {
        String targetName = act.substring(3, act.length() - 1);
        return new KeyChangeAction(targetName);
    }

    protected LocationAction parserIfAction(String act) {
        IfAction action = null;
        int index = act.indexOf("->");
        String condtion = act.substring(1, index);
        String output = act.substring(index + 2, act.length());
        action = new IfAction(condtion, output);
        return action;
    }

    protected LocationAction parserValueChange(String act) {
        int index = act.indexOf("->");
        if (index != -1) {
            String methodName = act.substring(2, index);
            String chainActionString = act.substring(index + 2);
            IValueAction chainAction = (IValueAction)this.parseAction(chainActionString);
            ValueChangeAction va = new ValueChangeAction(methodName, chainAction);
            return va;
        }
        String methodName = act.substring(2);
        ValueChangeAction va = new ValueChangeAction(methodName);
        return va;
    }

    protected LocationAction parserCycleIngore(String act) {
        ClassCycleIgnoreAction action = null;
        String names = act.substring(3, act.length() - 1);
        action = new ClassCycleIgnoreAction(names);
        return action;
    }

    protected LocationAction parserCycleUsing(String act) {
        ClassCycleIncludeAction action = null;
        String names = act.substring(3, act.length() - 1);
        action = new ClassCycleIncludeAction(names);
        return action;
    }

    protected LocationAction parserUserDefine(String act) {
        LocationAction action = null;
        String userActionName = act.substring(1);
        action = this.tool.getAction(userActionName);
        if (action == null) {
            throw new JsonException(0, "\u627e\u4e0d\u5230" + userActionName);
        }
        return action;
    }

    public JsonTool getTool() {
        return this.tool;
    }

    public void setTool(JsonTool tool) {
        this.tool = tool;
    }

    public Location getNextLoc() {
        return this.nextLoc;
    }

    public void setNextLoc(Location nextLoc) {
        this.nextLoc = nextLoc;
    }
}

