/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.beetl.json.ActionReturn;
import org.beetl.json.JsonWriter;
import org.beetl.json.OutputNode;
import org.beetl.json.OutputNodeKey;
import org.beetl.json.action.IValueAction;
import org.beetl.json.node.PojoAttributeNode;
import org.beetl.json.node.PojoNode;

public class ClassCycleIncludeAction
implements IValueAction {
    String[] names = null;

    public ClassCycleIncludeAction(String names) {
        this.names = names.split(",");
    }

    @Override
    public ActionReturn doit(OutputNodeKey field, Object obj, OutputNode thisNode, JsonWriter w) {
        if (thisNode instanceof PojoAttributeNode) {
            return new ActionReturn(obj, 0);
        }
        try {
            if (w.containObjectInPath(obj)) {
                w.writeKey(field);
                String path = w.getObjectPath(obj);
                w.writeScopeChar('{');
                w.writeKeyValue("$ref", (Object)path);
                this.cycleRender((PojoNode)thisNode, field, obj, w);
                w.writeScopeChar('}');
                return new ActionReturn(obj, 2);
            }
            return new ActionReturn(obj, 0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void cycleRender(PojoNode pojo, OutputNodeKey field, Object obj, JsonWriter w) throws IOException {
        List<PojoAttributeNode> attrs = pojo.getAttrs();
        Iterator<PojoAttributeNode> it = attrs.iterator();
        if (!it.hasNext()) {
            return;
        }
        boolean firstWrite = true;
        do {
            PojoAttributeNode node;
            if (!this.containAttr((node = it.next()).getAttrName())) continue;
            node.render(field, obj, w);
            firstWrite = true;
        } while (it.hasNext());
    }

    private boolean containAttr(String attr) {
        for (String s : this.names) {
            if (!s.equals(attr)) continue;
            return true;
        }
        return false;
    }
}

