/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.beetl.json.ActionReturn;
import org.beetl.json.JsonException;
import org.beetl.json.JsonWriter;
import org.beetl.json.OutputNode;
import org.beetl.json.OutputNodeKey;
import org.beetl.json.action.IValueAction;

public class ValueChangeAction
implements IValueAction {
    String methodName = "";
    IValueAction action = null;

    public ValueChangeAction(String methodName) {
        this.methodName = methodName;
    }

    public ValueChangeAction(String methodName, IValueAction action) {
        this.methodName = methodName;
        this.action = action;
    }

    @Override
    public ActionReturn doit(OutputNodeKey field, Object o, OutputNode thisNode, JsonWriter w) {
        if (o == null) {
            return new ActionReturn(o, 1);
        }
        try {
            Method m = o.getClass().getMethod(this.methodName, new Class[0]);
            Object value = m.invoke(o, new Object[0]);
            if (this.action != null) {
                ActionReturn newValue = this.action.doit(field, value, thisNode, w);
                return newValue;
            }
            return new ActionReturn(value, 1);
        }
        catch (NoSuchMethodException e) {
            throw new JsonException(0, "No method:" + this.methodName);
        }
        catch (IllegalAccessException e) {
            throw new JsonException(0, "can not access method :" + this.methodName);
        }
        catch (IllegalArgumentException e) {
            throw new JsonException(0, "can not access:" + this.methodName);
        }
        catch (InvocationTargetException e) {
            throw new JsonException(0, e.getTargetException().toString());
        }
    }
}

