/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json.node;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.beetl.json.ActionReturn;
import org.beetl.json.JsonTool;
import org.beetl.json.JsonWriter;
import org.beetl.json.Location;
import org.beetl.json.LocationAction;
import org.beetl.json.OutputNode;
import org.beetl.json.OutputNodeKey;
import org.beetl.json.action.IInstanceAction;
import org.beetl.json.action.IValueAction;
import org.beetl.json.loc.ClassTypeLocation;
import org.beetl.json.loc.ThisLocation;
import org.beetl.json.node.PojoAttributeNode;
import org.beetl.json.util.JsonUtil;

public class PojoNode
extends OutputNode {
    Class c;
    List<PojoAttributeNode> attrs = new ArrayList<PojoAttributeNode>();

    public PojoNode(Class c) {
        this.c = c;
    }

    @Override
    public void render(OutputNodeKey field, Object obj, JsonWriter w) throws IOException {
        Iterator iterator;
        if (this.valueActions != null && (iterator = this.valueActions.iterator()).hasNext()) {
            IValueAction valueAction = (IValueAction)iterator.next();
            ActionReturn ar = valueAction.doit(field, obj, this, w);
            obj = ar.value;
            if (ar.process == 2) {
                return;
            }
        }
        if (obj == null) {
            w.writeKey(field);
            w.writeNull();
        }
        if (w.containObjectInPath(obj)) {
            w.writeKey(field);
            String path = w.getObjectPath(obj);
            w.writeScopeChar('{');
            w.writeKeyValue("$ref", (Object)path);
            w.writeScopeChar('}');
            return;
        }
        w.addObjectPath(field, obj);
        w.writeKey(field);
        w.writeScopeChar('{');
        Iterator<PojoAttributeNode> it = this.attrs.iterator();
        if (!it.hasNext()) {
            w.writeScopeChar('}');
        } else {
            do {
                PojoAttributeNode node = it.next();
                node.render(null, obj, w);
            } while (it.hasNext());
            w.writeScopeChar('}');
        }
        w.removeObjectPath(obj);
    }

    @Override
    public void addActionIfMatchLocations(List<Location> list, JsonTool tool) {
        Method[] ms;
        for (Method m : ms = this.c.getMethods()) {
            if (!JsonUtil.isGetterMethod(m) || tool.isStopParse(m.getDeclaringClass().getName())) continue;
            PojoAttributeNode node = new PojoAttributeNode(this.c, m);
            node.addActionIfMatchLocations(list, tool);
            if (node.isIgnore()) continue;
            this.attrs.add(node);
        }
        if (tool.orderAttribute) {
            Collections.sort(this.attrs, tool.orderAttributeComparator);
        }
        ArrayList<IInstanceAction> insActions = new ArrayList<IInstanceAction>();
        for (Location l : list) {
            if (l instanceof ClassTypeLocation) {
                if (!((ClassTypeLocation)l).match(this, this.c, null, tool)) continue;
                LocationAction action = l.getAction();
                if (action instanceof IValueAction) {
                    this.addValueAction((IValueAction)l.getAction());
                    continue;
                }
                if (!(action instanceof IInstanceAction)) continue;
                insActions.add((IInstanceAction)action);
                continue;
            }
            if (!(l instanceof ThisLocation)) continue;
            insActions.add((IInstanceAction)l.getAction());
        }
        if (insActions.size() != 0) {
            for (IInstanceAction ca : insActions) {
                ActionReturn ar = ca.doit(this);
                if (ar.process != 0) break;
                this.attrs = (List)ar.value;
            }
        }
    }

    public List<PojoAttributeNode> getAttrs() {
        return this.attrs;
    }
}

