/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json.util;

import org.beetl.json.ActionReturn;
import org.beetl.json.DirectOutputValue;
import org.beetl.json.JsonWriter;
import org.beetl.json.OutputNode;
import org.beetl.json.OutputNodeKey;
import org.beetl.json.action.IValueAction;

public class StringQuoteCheck
implements IValueAction {
    private String cr = null;

    @Override
    public ActionReturn doit(OutputNodeKey field, Object o, OutputNode thisNode, JsonWriter w) {
        DirectOutputValue dov;
        if (o instanceof String) {
            return new ActionReturn(this.getString((String)o, w), 0);
        }
        if (o instanceof DirectOutputValue && (dov = (DirectOutputValue)o).getValue() instanceof String) {
            String newValue = (String)dov.getValue();
            newValue = this.getString(newValue, w);
            return new ActionReturn(newValue, 0);
        }
        return new ActionReturn(o);
    }

    public String getString(String str, JsonWriter w) {
        if (str == null) {
            return str;
        }
        char target = w.getQuotes();
        char[] cs = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            if (c == target) {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (this.cr != null && c == '\r') {
                if (this.isCR(cs, i, '\n')) {
                    ++i;
                }
                sb.append(this.cr);
                continue;
            }
            if (this.cr != null && c == '\n') {
                if (this.isCR(cs, i, '\r')) {
                    ++i;
                }
                sb.append(this.cr);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean isCR(char[] cs, int index, char expected) {
        int next = index + 1;
        return next < cs.length && cs[next] == expected;
    }

    public String getCr() {
        return this.cr;
    }

    public void setCr(String cr) {
        this.cr = cr;
    }
}

