/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.Node;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.base.SequoiadbConstants;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.net.IConnection;
import com.sequoiadb.util.SDBMessageHelper;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;

public class ReplicaGroup {
    private String name;
    private int id;
    private Sequoiadb sequoiadb;
    private boolean isCataRG;

    public Sequoiadb getSequoiadb() {
        return this.sequoiadb;
    }

    public int getId() {
        return this.id;
    }

    public String getGroupName() {
        return this.name;
    }

    ReplicaGroup(Sequoiadb sdb, int id) {
        this.sequoiadb = sdb;
        this.id = id;
        BSONObject group = sdb.getDetailById(id);
        this.name = group.get("GroupName").toString();
        this.isCataRG = this.name.equals("SYSCatalogGroup");
    }

    ReplicaGroup(Sequoiadb sdb, String name) {
        this.sequoiadb = sdb;
        this.name = name;
        BSONObject group = sdb.getDetailByName(name);
        this.isCataRG = name == "SYSCatalogGroup";
        this.id = Integer.parseInt(group.get("GroupID").toString());
    }

    public int getNodeNum(Node.NodeStatus status) throws BaseException {
        BSONObject group = this.sequoiadb.getDetailById(this.id);
        try {
            Object obj = group.get("Group");
            if (obj == null) {
                return 0;
            }
            BasicBSONList list = (BasicBSONList)obj;
            return list.size();
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BaseException("SDB_SYS", new Object[]{e});
        }
    }

    public BSONObject getDetail() throws BaseException {
        return this.sequoiadb.getDetailById(this.id);
    }

    public Node getMaster() throws BaseException {
        BSONObject group = this.sequoiadb.getDetailById(this.id);
        BSONObject primaryData = null;
        Object nodeId = null;
        Object primaryNodeObj = group.get("PrimaryNode");
        if (primaryNodeObj == null) {
            throw new BaseException("SDB_CLS_NODE_NOT_EXIST", new Object[0]);
        }
        Object groupInfoObj = group.get("Group");
        if (groupInfoObj == null) {
            return null;
        }
        BasicBSONList nodeInfos = (BasicBSONList)groupInfoObj;
        for (Object nodeInfoObj : nodeInfos) {
            BSONObject nodeInfo = (BSONObject)nodeInfoObj;
            nodeId = nodeInfo.get("NodeID");
            if (nodeId == null) {
                throw new BaseException("SDB_SYS", new Object[0]);
            }
            if (!nodeId.equals(primaryNodeObj)) continue;
            primaryData = nodeInfo;
            break;
        }
        if (primaryData != null) {
            nodeId = primaryData.get("NodeID");
            String hostName = primaryData.get("HostName").toString();
            int port = this.getNodePort(primaryData);
            return new Node(hostName, port, Integer.parseInt(nodeId.toString()), this);
        }
        return null;
    }

    public Node getSlave() throws BaseException {
        BSONObject group = this.sequoiadb.getDetailById(this.id);
        if (group == null) {
            return null;
        }
        ArrayList<BSONObject> slaves = new ArrayList<BSONObject>();
        BSONObject primaryData = null;
        Object primaryNodeObj = group.get("PrimaryNode");
        if (primaryNodeObj == null) {
            throw new BaseException("SDB_CLS_NODE_NOT_EXIST", new Object[0]);
        }
        Object groupInfoObj = group.get("Group");
        if (groupInfoObj == null) {
            return null;
        }
        BasicBSONList nodeInfos = (BasicBSONList)groupInfoObj;
        for (Object nodeInfoObj : nodeInfos) {
            BSONObject nodeInfo = (BSONObject)nodeInfoObj;
            Object nodeId = nodeInfo.get("NodeID");
            if (nodeId == null) {
                throw new BaseException("SDB_SYS", new Object[0]);
            }
            if (nodeId.equals(primaryNodeObj)) {
                primaryData = nodeInfo;
                continue;
            }
            slaves.add(nodeInfo);
        }
        if (slaves.size() != 0) {
            Random rand = new Random();
            BSONObject randNode = (BSONObject)slaves.get(rand.nextInt(slaves.size()));
            int nodeId = Integer.parseInt(randNode.get("NodeID").toString());
            String hostName = randNode.get("HostName").toString();
            int port = this.getNodePort(randNode);
            return new Node(hostName, port, nodeId, this);
        }
        if (primaryData != null) {
            int nodeId = Integer.parseInt(primaryData.get("NodeID").toString());
            String hostName = primaryData.get("HostName").toString();
            int port = this.getNodePort(primaryData);
            return new Node(hostName, port, nodeId, this);
        }
        return null;
    }

    public Node getNode(String nodeName) throws BaseException {
        String[] temp = nodeName.split(":");
        if (temp.length != 2) {
            throw new BaseException("SDB_INVALIDARG", nodeName);
        }
        BSONObject group = this.sequoiadb.getDetailById(this.id);
        if (group == null) {
            return null;
        }
        try {
            Object nodeId = null;
            Object hostName = null;
            int port = -1;
            Object list = group.get("Group");
            if (list == null) {
                return null;
            }
            BasicBSONList nodeInfos = (BasicBSONList)list;
            if (nodeInfos.size() == 0) {
                return null;
            }
            for (Object nodeInfoObj : nodeInfos) {
                BSONObject nodeInfo = (BSONObject)nodeInfoObj;
                nodeId = nodeInfo.get("NodeID");
                hostName = nodeInfo.get("HostName");
                port = this.getNodePort(nodeInfo);
                if (nodeId == null || hostName == null) {
                    throw new BaseException("SDB_SYS", new Object[0]);
                }
                String hostName2 = InetAddress.getByName(temp[0]).toString().split("/")[1];
                if (!(hostName = InetAddress.getByName(hostName.toString()).toString().split("/")[1]).equals(hostName2) || port != Integer.parseInt(temp[1])) continue;
                return new Node(hostName2, port, Integer.parseInt(nodeId.toString()), this);
            }
        }
        catch (Exception e) {
            throw new BaseException("SDB_SYS", nodeName);
        }
        return null;
    }

    public Node getNode(String hostName, int port) throws BaseException {
        BSONObject group = this.sequoiadb.getDetailById(this.id);
        try {
            Object list = group.get("Group");
            if (list == null) {
                return null;
            }
            BasicBSONList nodeInfos = (BasicBSONList)list;
            if (nodeInfos.size() == 0) {
                return null;
            }
            Object nodeIdObj = null;
            int nodeId = -1;
            BSONObject nodeInfo = null;
            int nodePort = -1;
            for (Object obj : nodeInfos) {
                nodeInfo = (BSONObject)obj;
                nodeIdObj = nodeInfo.get("NodeID");
                if (nodeIdObj == null) {
                    throw new BaseException("SDB_SYS", new Object[0]);
                }
                nodeId = Integer.parseInt(nodeIdObj.toString());
                hostName = InetAddress.getByName(hostName).toString().split("/")[1];
                String hostName2 = InetAddress.getByName(nodeInfo.get("HostName").toString()).toString().split("/")[1];
                if (!hostName2.equals(hostName) || (nodePort = this.getNodePort(nodeInfo)) != port) continue;
                return new Node(hostName, port, nodeId, this);
            }
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BaseException("SDB_SYS", hostName, port);
        }
        return null;
    }

    public Node createNode(String hostName, int port, String dbPath, Map<String, String> configure) throws BaseException {
        SDBMessage rtn;
        int flags;
        BasicBSONObject config = new BasicBSONObject();
        config.put("GroupName", (Object)this.name);
        config.put("HostName", (Object)hostName);
        config.put("svcname", (Object)Integer.toString(port));
        config.put("dbpath", (Object)dbPath);
        if (configure != null) {
            for (String key : configure.keySet()) {
                if (key.equals("GroupName") || key.equals("HostName") || key.equals("svcname")) continue;
                config.put(key, (Object)configure.get(key));
            }
        }
        if ((flags = (rtn = this.adminCommand("create", "node", config)).getFlags()) != 0) {
            throw new BaseException(flags, hostName, port, dbPath, configure);
        }
        return this.getNode(hostName, port);
    }

    public void removeNode(String hostName, int port, BSONObject configure) throws BaseException {
        SDBMessage rtn;
        int flags;
        BasicBSONObject config = new BasicBSONObject();
        config.put("GroupName", (Object)this.name);
        config.put("HostName", (Object)hostName);
        config.put("svcname", (Object)Integer.toString(port));
        if (configure != null) {
            for (String key : configure.keySet()) {
                if (key.equals("GroupName") || key.equals("HostName") || key.equals("svcname")) continue;
                config.put(key, configure.get(key));
            }
        }
        if ((flags = (rtn = this.adminCommand("remove", "node", config)).getFlags()) != 0) {
            throw new BaseException(hostName, port, configure);
        }
    }

    public void start() throws BaseException {
        BasicBSONObject groupName = new BasicBSONObject();
        groupName.put("GroupName", (Object)this.name);
        SDBMessage rtn = this.adminCommand("active", "group", groupName);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, this.name);
        }
    }

    public void stop() throws BaseException {
        BasicBSONObject groupName = new BasicBSONObject();
        groupName.put("GroupName", (Object)this.name);
        SDBMessage rtn = this.adminCommand("shutdown", "group", groupName);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, this.name);
        }
    }

    public boolean isCatalog() {
        return this.isCataRG;
    }

    private int getNodePort(BSONObject node) {
        Object services = node.get("Service");
        if (services == null) {
            throw new BaseException("SDB_SYS", node);
        }
        BasicBSONList serviceInfos = (BasicBSONList)services;
        if (serviceInfos.size() == 0) {
            throw new BaseException("SDB_CLS_NODE_NOT_EXIST", new Object[0]);
        }
        int port = -1;
        for (Object obj : serviceInfos) {
            BSONObject service = (BSONObject)obj;
            if (!service.get("Type").toString().equals("0")) continue;
            port = Integer.parseInt(service.get("Name").toString());
            break;
        }
        if (port == -1) {
            throw new BaseException("SDB_SYS", node);
        }
        return port;
    }

    private SDBMessage adminCommand(String cmdType, String contextType, BSONObject query) throws BaseException {
        IConnection connection = this.sequoiadb.getConnection();
        BasicBSONObject dummyObj = new BasicBSONObject();
        SDBMessage sdbMessage = new SDBMessage();
        String commandString = "$" + cmdType + " " + contextType;
        if (query != null) {
            sdbMessage.setMatcher(query);
        } else {
            sdbMessage.setMatcher(dummyObj);
        }
        sdbMessage.setCollectionFullName(commandString);
        sdbMessage.setFlags(0);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        sdbMessage.setRequestID(this.sequoiadb.getNextRequstID());
        sdbMessage.setSkipRowsCount(-1L);
        sdbMessage.setReturnRowsCount(-1L);
        sdbMessage.setSelector(dummyObj);
        sdbMessage.setOrderBy(dummyObj);
        sdbMessage.setHint(dummyObj);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_QUERY);
        byte[] request = SDBMessageHelper.buildQueryRequest(sdbMessage, this.sequoiadb.endianConvert);
        connection.sendMessage(request);
        ByteBuffer byteBuffer = connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        return rtnSDBMessage;
    }
}

