/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.CollectionSpace;
import com.sequoiadb.base.DBCursor;
import com.sequoiadb.base.Domain;
import com.sequoiadb.base.ReplicaGroup;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.SequoiadbConstants;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.net.ConfigOptions;
import com.sequoiadb.net.ConnectionTCPImpl;
import com.sequoiadb.net.IConnection;
import com.sequoiadb.net.ServerAddress;
import com.sequoiadb.util.SDBMessageHelper;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;
import org.bson.types.Code;
import org.bson.util.JSON;

public class Sequoiadb {
    private ServerAddress serverAddress;
    private IConnection connection;
    private String userName;
    private String password;
    boolean endianConvert;
    private long requestID = 0L;
    public static final int SDB_PAGESIZE_4K = 4096;
    public static final int SDB_PAGESIZE_8K = 8192;
    public static final int SDB_PAGESIZE_16K = 16384;
    public static final int SDB_PAGESIZE_32K = 32768;
    public static final int SDB_PAGESIZE_64K = 65536;
    public static final int SDB_PAGESIZE_DEFAULT = 0;
    public static final int SDB_LIST_CONTEXTS = 0;
    public static final int SDB_LIST_CONTEXTS_CURRENT = 1;
    public static final int SDB_LIST_SESSIONS = 2;
    public static final int SDB_LIST_SESSIONS_CURRENT = 3;
    public static final int SDB_LIST_COLLECTIONS = 4;
    public static final int SDB_LIST_COLLECTIONSPACES = 5;
    public static final int SDB_LIST_STORAGEUNITS = 6;
    public static final int SDB_LIST_GROUPS = 7;
    public static final int SDB_LIST_STOREPROCEDURES = 8;
    public static final int SDB_LIST_DOMAINS = 9;
    public static final int SDB_LIST_TASKS = 10;
    public static final int SDB_LIST_CS_IN_DOMAIN = 11;
    public static final int SDB_LIST_CL_IN_DOMAIN = 12;
    public static final int SDB_SNAP_CONTEXTS = 0;
    public static final int SDB_SNAP_CONTEXTS_CURRENT = 1;
    public static final int SDB_SNAP_SESSIONS = 2;
    public static final int SDB_SNAP_SESSIONS_CURRENT = 3;
    public static final int SDB_SNAP_COLLECTIONS = 4;
    public static final int SDB_SNAP_COLLECTIONSPACES = 5;
    public static final int SDB_SNAP_DATABASE = 6;
    public static final int SDB_SNAP_SYSTEM = 7;
    public static final int SDB_SNAP_CATALOG = 8;
    public static final int FMP_FUNC_TYPE_INVALID = -1;
    public static final int FMP_FUNC_TYPE_JS = 0;
    public static final int FMP_FUNC_TYPE_C = 1;
    public static final int FMP_FUNC_TYPE_JAVA = 2;
    public static final String CATALOG_GROUP_NAME = "SYSCatalogGroup";

    public IConnection getConnection() {
        return this.connection;
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(ServerAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    public boolean isEndianConvert() {
        return this.endianConvert;
    }

    public Sequoiadb(String username, String password) throws BaseException {
        this.serverAddress = new ServerAddress();
        ConfigOptions opts = new ConfigOptions();
        this.initConnection(opts);
        this.userName = username;
        this.password = password;
        this.auth();
    }

    public Sequoiadb(String connString, String username, String password) throws BaseException {
        this(connString, username, password, null);
    }

    public Sequoiadb(String connString, String username, String password, ConfigOptions options) throws BaseException {
        ConfigOptions opts = options;
        if (null == options) {
            opts = new ConfigOptions();
        }
        try {
            this.serverAddress = new ServerAddress(connString);
            this.initConnection(opts);
        }
        catch (UnknownHostException e) {
            throw new BaseException("SDB_NETWORK", connString, e);
        }
        this.userName = username;
        this.password = password;
        this.auth();
    }

    public Sequoiadb(List<String> connStrings, String username, String password, ConfigOptions options) throws BaseException {
        int count;
        int size;
        ConfigOptions opts = options;
        if (options == null) {
            opts = new ConfigOptions();
        }
        if (0 == (size = connStrings.size())) {
            throw new BaseException("SDB_INVALIDARG", "Address list is empty");
        }
        Random random = new Random();
        int mark = count = random.nextInt(size);
        while (true) {
            ++count;
            String str = connStrings.get(count %= size);
            try {
                try {
                    this.serverAddress = new ServerAddress(str);
                    this.initConnection(opts);
                }
                catch (UnknownHostException e) {
                    throw new BaseException("SDB_NETWORK", str);
                }
                this.userName = username;
                this.password = password;
                this.auth();
            }
            catch (BaseException e) {
                if (mark != count) continue;
                throw new BaseException("SDB_NET_CANNOT_CONNECT", new Object[0]);
                if (mark != count) continue;
            }
            break;
        }
    }

    public Sequoiadb(String addr, int port, String username, String password) throws BaseException {
        this(addr, port, username, password, null);
    }

    public Sequoiadb(String addr, int port, String username, String password, ConfigOptions options) throws BaseException {
        ConfigOptions opts = options;
        if (options == null) {
            opts = new ConfigOptions();
        }
        try {
            this.serverAddress = new ServerAddress(addr, port);
            this.initConnection(opts);
        }
        catch (UnknownHostException e) {
            throw new BaseException("SDB_NETWORK", addr, port, e);
        }
        this.userName = username;
        this.password = password;
        this.auth();
    }

    private void auth() {
        this.endianConvert = this.requestSysInfo();
        byte[] request = SDBMessageHelper.buildAuthMsg(this.userName, this.password, this.getNextRequstID(), (byte)0, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtn = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtn.getOperationCode() != SequoiadbConstants.Operation.MSG_AUTH_VERIFY_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtn.getOperationCode()});
        }
        int flags = rtn.getFlags();
        if (flags != 0) {
            this.connection.close();
            throw new BaseException(flags, this.userName, this.password);
        }
    }

    public void createUser(String username, String password) throws BaseException {
        if (username == null || password == null) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        byte[] request = SDBMessageHelper.buildAuthMsg(username, password, this.getNextRequstID(), (byte)1, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtn = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtn.getOperationCode() != SequoiadbConstants.Operation.MSG_AUTH_CRTUSR_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtn.getOperationCode()});
        }
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, username, password);
        }
    }

    public void removeUser(String username, String password) throws BaseException {
        byte[] request = SDBMessageHelper.buildAuthMsg(username, password, this.getNextRequstID(), (byte)2, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtn = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtn.getOperationCode() != SequoiadbConstants.Operation.MSG_AUTH_DELUSR_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtn.getOperationCode()});
        }
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, username, password);
        }
    }

    public void disconnect() throws BaseException {
        byte[] request = SDBMessageHelper.buildDisconnectRequest(this.endianConvert);
        this.releaseResource();
        this.connection.sendMessage(request);
        this.connection.close();
    }

    private boolean isClosed() {
        if (this.connection == null) {
            return true;
        }
        return this.connection.isClosed();
    }

    public boolean isValid() throws BaseException {
        if (this.connection == null || this.connection.isClosed()) {
            return false;
        }
        try {
            this.sendKillContextMsg();
        }
        catch (BaseException e) {
            return false;
        }
        return true;
    }

    public void changeConnectionOptions(ConfigOptions opts) throws BaseException {
        this.connection.changeConfigOptions(opts);
        this.auth();
    }

    public CollectionSpace createCollectionSpace(String csName) throws BaseException {
        return this.createCollectionSpace(csName, 0);
    }

    public CollectionSpace createCollectionSpace(String csName, int pageSize) throws BaseException {
        BasicBSONObject options = new BasicBSONObject();
        options.put("PageSize", (Object)pageSize);
        return this.createCollectionSpace(csName, options);
    }

    public CollectionSpace createCollectionSpace(String csName, BSONObject options) throws BaseException {
        if (this.isCollectionSpaceExist(csName)) {
            throw new BaseException("SDB_DMS_CS_EXIST", csName);
        }
        SDBMessage rtnSDBMessage = this.createCS(csName, options);
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
        return this.getCollectionSpace(csName);
    }

    public void dropCollectionSpace(String csName) throws BaseException {
        if (!this.isCollectionSpaceExist(csName)) {
            throw new BaseException("SDB_DMS_CS_NOTEXIST", csName);
        }
        BasicBSONObject matcher = new BasicBSONObject();
        matcher.put("Name", (Object)csName);
        String commandString = "drop collectionspace";
        SDBMessage rtn = this.adminCommand(commandString, 0, 0L, -1L, -1L, matcher, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public CollectionSpace getCollectionSpace(String csName) throws BaseException {
        if (this.isCollectionSpaceExist(csName)) {
            return new CollectionSpace(this, csName.trim());
        }
        throw new BaseException("SDB_DMS_CS_NOTEXIST", csName);
    }

    public boolean isCollectionSpaceExist(String csName) throws BaseException {
        String commandString = "test collectionspace";
        BasicBSONObject matcher = new BasicBSONObject();
        matcher.put("Name", (Object)csName);
        SDBMessage rtn = this.adminCommand(commandString, 0, 0L, -1L, -1L, matcher, null, null, null);
        int flags = rtn.getFlags();
        if (flags == 0) {
            return true;
        }
        if (flags == new BaseException("SDB_DMS_CS_NOTEXIST", new Object[0]).getErrorCode()) {
            return false;
        }
        throw new BaseException(flags, csName);
    }

    public DBCursor listCollectionSpaces() throws BaseException {
        return this.getList(5, 0, 0L, -1L, -1L, null, null, null, null);
    }

    public ArrayList<String> getCollectionSpaceNames() throws BaseException {
        DBCursor cursor = this.getList(5, 0, 0L, -1L, -1L, null, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        while (cursor.hasNext()) {
            colList.add(cursor.getNext().get("Name").toString());
        }
        return colList;
    }

    public DBCursor listCollections() throws BaseException {
        return this.getList(4, 0, 0L, 0L, -1L, null, null, null, null);
    }

    public ArrayList<String> getCollectionNames() throws BaseException {
        DBCursor cursor = this.getList(4, 0, 0L, 0L, -1L, null, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        while (cursor.hasNext()) {
            colList.add(cursor.getNext().get("Name").toString());
        }
        return colList;
    }

    public ArrayList<String> getStorageUnits() throws BaseException {
        DBCursor cursor = this.getList(6, 0, 0L, -1L, -1L, null, null, null, null);
        ArrayList<String> colList = new ArrayList<String>();
        while (cursor.hasNext()) {
            colList.add(cursor.getNext().get("Name").toString());
        }
        return colList;
    }

    public void resetSnapshot() throws BaseException {
        String commandString = "snapshot reset";
        SDBMessage rtn = this.adminCommand(commandString, 0, 0L, -1L, -1L, null, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public DBCursor getList(int listType, BSONObject query, BSONObject selector, BSONObject orderBy) throws BaseException {
        return this.getList(listType, 0, 0L, 0L, -1L, query, selector, orderBy, null);
    }

    public void flushConfigure(BSONObject param) throws BaseException {
        SDBMessage rtn = this.adminCommand("export configuration", 0, 0L, 0L, -1L, param, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public void execUpdate(String sql) throws BaseException {
        SDBMessage sdb = new SDBMessage();
        sdb.setRequestID(this.getNextRequstID());
        sdb.setNodeID(SequoiadbConstants.ZERO_NODEID);
        byte[] request = SDBMessageHelper.buildSqlMsg(sdb, sql, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtn = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtn.getOperationCode() != SequoiadbConstants.Operation.MSG_BS_SQL_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtn.getOperationCode()});
        }
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, sql);
        }
    }

    public DBCursor exec(String sql) throws BaseException {
        SDBMessage sdb = new SDBMessage();
        sdb.setRequestID(this.getNextRequstID());
        sdb.setNodeID(SequoiadbConstants.ZERO_NODEID);
        byte[] request = SDBMessageHelper.buildSqlMsg(sdb, sql, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtn = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtn.getOperationCode() != SequoiadbConstants.Operation.MSG_BS_SQL_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtn.getOperationCode()});
        }
        int flags = rtn.getFlags();
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return null;
            }
            throw new BaseException(flags, sql);
        }
        return new DBCursor(rtn, this);
    }

    public DBCursor getSnapshot(int snapType, String matcher, String selector, String orderBy) throws BaseException {
        BSONObject ma = null;
        BSONObject se = null;
        BSONObject or = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (selector != null) {
            se = (BSONObject)JSON.parse(selector);
        }
        if (orderBy != null) {
            or = (BSONObject)JSON.parse(orderBy);
        }
        return this.getSnapshot(snapType, ma, se, or);
    }

    public DBCursor getSnapshot(int snapType, BSONObject matcher, BSONObject selector, BSONObject orderBy) throws BaseException {
        String command = "snapshot";
        switch (snapType) {
            case 0: {
                command = command + " contexts";
                break;
            }
            case 1: {
                command = command + " contexts current";
                break;
            }
            case 2: {
                command = command + " sessions";
                break;
            }
            case 3: {
                command = command + " sessions current";
                break;
            }
            case 4: {
                command = command + " collections";
                break;
            }
            case 5: {
                command = command + " collectionspaces";
                break;
            }
            case 6: {
                command = command + " database";
                break;
            }
            case 7: {
                command = command + " system";
                break;
            }
            case 8: {
                command = command + " catalog";
                break;
            }
            default: {
                throw new BaseException("SDB_INVALIDARG", new Object[0]);
            }
        }
        SDBMessage rtn = this.adminCommand(command, 0, 0L, -1L, -1L, matcher, selector, orderBy, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return null;
            }
            throw new BaseException(flags, matcher, selector, orderBy);
        }
        return new DBCursor(rtn, this);
    }

    public void beginTransaction() throws BaseException {
        byte[] request = SDBMessageHelper.buildTransactionRequest(SequoiadbConstants.Operation.TRANS_BEGIN_REQ, this.getNextRequstID(), this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtn = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtn.getOperationCode() != SequoiadbConstants.Operation.TRANS_BEGIN_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtn.getOperationCode()});
        }
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public void commit() throws BaseException {
        byte[] request = SDBMessageHelper.buildTransactionRequest(SequoiadbConstants.Operation.TRANS_COMMIT_REQ, this.getNextRequstID(), this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtn = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtn.getOperationCode() != SequoiadbConstants.Operation.TRANS_COMMIT_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtn.getOperationCode()});
        }
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public void rollback() throws BaseException {
        byte[] request = SDBMessageHelper.buildTransactionRequest(SequoiadbConstants.Operation.TRANS_ROLLBACK_REQ, this.getNextRequstID(), this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtn = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtn.getOperationCode() != SequoiadbConstants.Operation.TRANS_ROLLBACK_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtn.getOperationCode()});
        }
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public void crtJSProcedure(String code) throws BaseException {
        if (null == code || code.equals("")) {
            throw new BaseException("SDB_INVALIDARG", code);
        }
        BasicBSONObject newobj = new BasicBSONObject();
        Code codeObj = new Code(code);
        newobj.put("func", (Object)codeObj);
        newobj.put("funcType", (Object)0);
        SDBMessage rtn = this.adminCommand("create procedure", 0, 0L, 0L, -1L, newobj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public void rmProcedure(String name) throws BaseException {
        if (null == name || name.equals("")) {
            throw new BaseException("SDB_INVALIDARG", name);
        }
        BasicBSONObject newobj = new BasicBSONObject();
        newobj.put("func", (Object)name);
        SDBMessage rtn = this.adminCommand("remove procedure", 0, 0L, 0L, -1L, newobj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public DBCursor listProcedures(BSONObject condition) throws BaseException {
        return this.getList(8, 0, 0L, 0L, -1L, condition, null, null, null);
    }

    public SptEvalResult evalJS(String code) throws BaseException {
        if (code == null || code.equals("")) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        SptEvalResult evalResult = new SptEvalResult();
        BasicBSONObject newObj = new BasicBSONObject();
        Code codeObj = new Code(code);
        newObj.put("func", (Object)codeObj);
        newObj.put("funcType", (Object)0);
        SDBMessage rtn = this.adminCommandEval("eval", 0, 0L, 0L, -1L, newObj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            List<BSONObject> objList = rtn.getObjectList();
            if (objList.size() > 0) {
                evalResult.errmsg = rtn.getObjectList().get(0);
            }
            return evalResult;
        }
        List<BSONObject> objList = rtn.getObjectList();
        int typeValue = (Integer)objList.get(0).get("ReturnType");
        evalResult.returnType = SptReturnType.getTypeByValue(typeValue);
        evalResult.cursor = new DBCursor(rtn, this);
        return evalResult;
    }

    public void backupOffline(BSONObject options) throws BaseException {
        SDBMessage rtn = this.adminCommand("backup offline", 0, 0L, 0L, -1L, options, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public DBCursor listBackup(BSONObject options, BSONObject matcher, BSONObject selector, BSONObject orderBy) throws BaseException {
        if (null != options) {
            for (String key : options.keySet()) {
                if (key.equals("GroupName") || key.equals("Name") || key.equals("Path")) continue;
                throw new BaseException("SDB_INVALIDARG", key);
            }
        }
        SDBMessage rtn = this.adminCommand("list backups", 0, 0L, 0L, -1L, matcher, selector, orderBy, options);
        DBCursor cursor = null;
        int flags = rtn.getFlags();
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return cursor;
            }
            throw new BaseException(flags, matcher, selector, orderBy, options);
        }
        cursor = new DBCursor(rtn, this);
        return cursor;
    }

    public void removeBackup(BSONObject options) throws BaseException {
        SDBMessage rtn;
        int flags;
        if (null != options) {
            for (String key : options.keySet()) {
                if (key.equals("GroupName") || key.equals("Name") || key.equals("Path")) continue;
                throw new BaseException("SDB_INVALIDARG", new Object[0]);
            }
        }
        if ((flags = (rtn = this.adminCommand("remove backup", 0, 0L, 0L, -1L, options, null, null, null)).getFlags()) != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public DBCursor listTasks(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint) throws BaseException {
        SDBMessage rtn = this.adminCommand("list tasks", 0, 0L, 0L, -1L, matcher, selector, orderBy, hint);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, matcher, selector, orderBy, hint);
        }
        DBCursor cursor = null;
        cursor = new DBCursor(rtn, this);
        return cursor;
    }

    public void waitTasks(long[] taskIDs) throws BaseException {
        if (taskIDs == null || taskIDs.length == 0) {
            throw new BaseException("SDB_INVALIDARG", new Object[]{taskIDs});
        }
        BasicBSONObject newObj = new BasicBSONObject();
        BasicBSONObject subObj = new BasicBSONObject();
        BasicBSONList list = new BasicBSONList();
        for (int i = 0; i < taskIDs.length; ++i) {
            list.put(Integer.toString(i), (Object)taskIDs[i]);
        }
        subObj.put("$in", (Object)list);
        newObj.put("TaskID", (Object)subObj);
        SDBMessage rtn = this.adminCommand("wait task", 0, 0L, 0L, -1L, newObj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public void cancelTask(long taskID, boolean isAsync) throws BaseException {
        if (taskID <= 0L) {
            throw new BaseException("SDB_INVALIDARG", taskID, isAsync);
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.put("TaskID", (Object)taskID);
        newObj.put("Async", (Object)isAsync);
        SDBMessage rtn = this.adminCommand("cancel task", 0, 0L, 0L, -1L, newObj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSessionAttr(BSONObject options) throws BaseException {
        if (null == options || options.isEmpty()) {
            return;
        }
        if (!options.containsField("PreferedInstance")) {
            throw new BaseException("SDB_INVALIDARG", options);
        }
        BasicBSONObject newObj = new BasicBSONObject();
        Object value = options.get("PreferedInstance");
        int v = SequoiadbConstants.PreferInstanceType.INS_SLAVE.getCode();
        if (value instanceof Integer) {
            v = (Integer)value;
            if (v < 1 || v > 7) {
                throw new BaseException("SDB_INVALIDARG", options);
            }
        } else {
            if (!(value instanceof String)) throw new BaseException("SDB_INVALIDARG", options);
            if (value.equals("M") || value.equals("m")) {
                v = SequoiadbConstants.PreferInstanceType.INS_MASTER.getCode();
            } else if (value.equals("S") || value.equals("s")) {
                v = SequoiadbConstants.PreferInstanceType.INS_SLAVE.getCode();
            } else {
                if (!value.equals("A") && !value.equals("a")) throw new BaseException("SDB_INVALIDARG", options);
                v = SequoiadbConstants.PreferInstanceType.INS_ANYONE.getCode();
            }
        }
        newObj.put("PreferedInstance", (Object)v);
        SDBMessage rtn = this.adminCommand("set session attribute", 0, 0L, 0L, -1L, newObj, null, null, null);
        int flags = rtn.getFlags();
        if (flags == 0) return;
        throw new BaseException(flags, new Object[0]);
    }

    public void closeAllCursors() throws BaseException {
        byte[] request = SDBMessageHelper.buildTransactionRequest(SequoiadbConstants.Operation.MSG_BS_INTERRUPTE, this.getNextRequstID(), this.endianConvert);
        this.connection.sendMessage(request);
    }

    public DBCursor listReplicaGroups() throws BaseException {
        return this.getList(7, 0, 0L, -1L, -1L, null, null, null, null);
    }

    public boolean isDomainExist(String domainName) throws BaseException {
        if (null == domainName || domainName.equals("")) {
            throw new BaseException("SDB_INVALIDARG", domainName);
        }
        BasicBSONObject matcher = new BasicBSONObject();
        matcher.put("Name", (Object)domainName);
        DBCursor cursor = this.getList(9, matcher, null, null);
        return null != cursor && cursor.hasNext();
    }

    public Domain createDomain(String domainName, BSONObject options) throws BaseException {
        SDBMessage rtn;
        int flags;
        if (null == domainName || domainName.equals("")) {
            throw new BaseException("SDB_INVALIDARG", domainName, options);
        }
        if (this.isDomainExist(domainName)) {
            throw new BaseException("SDB_CAT_DOMAIN_EXIST", domainName);
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.put("Name", (Object)domainName);
        if (null != options) {
            newObj.put("Options", (Object)options);
        }
        if ((flags = (rtn = this.adminCommand("create domain", 0, 0L, 0L, -1L, newObj, null, null, null)).getFlags()) != 0) {
            throw new BaseException(flags, new Object[0]);
        }
        return new Domain(this, domainName);
    }

    public void dropDomain(String domainName) throws BaseException {
        if (null == domainName || domainName.equals("")) {
            throw new BaseException("SDB_INVALIDARG", domainName);
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.put("Name", (Object)domainName);
        SDBMessage rtn = this.adminCommand("drop domain", 0, 0L, 0L, -1L, newObj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public Domain getDomain(String domainName) throws BaseException {
        if (this.isDomainExist(domainName)) {
            return new Domain(this, domainName);
        }
        throw new BaseException("SDB_CAT_DOMAIN_NOT_EXIST", domainName);
    }

    public DBCursor listDomains(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint) throws BaseException {
        return this.getList(9, 0, 0L, 0L, -1L, matcher, selector, orderBy, hint);
    }

    public ArrayList<String> getReplicaGroupNames() throws BaseException {
        DBCursor cursor = this.getList(7, 0, 0L, -1L, -1L, null, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        while (cursor.hasNext()) {
            colList.add(cursor.getNext().get("GroupName").toString());
        }
        return colList;
    }

    public ArrayList<String> getReplicaGroupsInfo() throws BaseException {
        DBCursor cursor = this.getList(7, 0, 0L, -1L, -1L, null, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        while (cursor.hasNext()) {
            colList.add(cursor.getNext().toString());
        }
        return colList;
    }

    public ReplicaGroup getReplicaGroup(String rgName) throws BaseException {
        BSONObject rg = this.getDetailByName(rgName);
        if (rg == null) {
            return null;
        }
        return new ReplicaGroup(this, rgName);
    }

    public ReplicaGroup getReplicaGroup(int rgId) throws BaseException {
        BSONObject rg = this.getDetailById(rgId);
        if (rg == null) {
            return null;
        }
        return new ReplicaGroup(this, rgId);
    }

    public ReplicaGroup createReplicaGroup(String rgName) throws BaseException {
        BasicBSONObject rg = new BasicBSONObject();
        rg.put("GroupName", (Object)rgName);
        SDBMessage rtn = this.adminCommand("create group", 0, 0L, -1L, -1L, rg, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, rgName);
        }
        return this.getReplicaGroup(rgName);
    }

    public void removeReplicaGroup(String rgName) throws BaseException {
        BasicBSONObject rg = new BasicBSONObject();
        rg.put("GroupName", (Object)rgName);
        SDBMessage rtn = this.adminCommand("remove group", 0, 0L, -1L, -1L, rg, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, rgName);
        }
    }

    long getNextRequstID() {
        return this.requestID++;
    }

    public void activateReplicaGroup(String rgName) throws BaseException {
        BasicBSONObject rg = new BasicBSONObject();
        rg.put("GroupName", (Object)rgName);
        SDBMessage rtn = this.adminCommand("active group", 0, 0L, -1L, -1L, rg, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, rgName);
        }
    }

    public void createReplicaCataGroup(String hostName, int port, String dbPath, Map<String, String> configure) {
        SDBMessage rtn;
        int flags;
        String commandString = "create catalog group";
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("HostName", (Object)hostName);
        obj.put("svcname", (Object)Integer.toString(port));
        obj.put("dbpath", (Object)dbPath);
        if (configure != null) {
            for (String key : configure.keySet()) {
                if (key.equals("HostName") || key.equals("svcname") || key.equals("dbpath")) continue;
                obj.put(key, (Object)configure.get(key).toString());
            }
        }
        if ((flags = (rtn = this.adminCommand(commandString, 0, 0L, -1L, -1L, obj, null, null, null)).getFlags()) != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    DBCursor getList(int listType, int flag, long reqID, long skipNum, long returnNum, BSONObject query, BSONObject selector, BSONObject order, BSONObject hint) throws BaseException {
        String command = "";
        switch (listType) {
            case 0: {
                command = "list contexts";
                break;
            }
            case 1: {
                command = "list contexts current";
                break;
            }
            case 2: {
                command = "list sessions";
                break;
            }
            case 3: {
                command = "list sessions current";
                break;
            }
            case 4: {
                command = "list collections";
                break;
            }
            case 5: {
                command = "list collectionspaces";
                break;
            }
            case 6: {
                command = "list storageunits";
                break;
            }
            case 7: {
                command = "list groups";
                break;
            }
            case 8: {
                command = "list procedures";
                break;
            }
            case 9: {
                command = "list domains";
                break;
            }
            case 10: {
                command = "list tasks";
                break;
            }
            case 11: {
                command = "list collectionspaces in domain";
                break;
            }
            case 12: {
                command = "list collections in domain";
                break;
            }
            default: {
                throw new BaseException("SDB_INVALIDARG", new Object[0]);
            }
        }
        SDBMessage rtn = this.adminCommand(command, flag, reqID, skipNum, returnNum, query, selector, order, hint);
        int flags = rtn.getFlags();
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return null;
            }
            throw new BaseException(flags, query, selector, order, hint);
        }
        return new DBCursor(rtn, this);
    }

    String getUserName() {
        return this.userName;
    }

    String getPassword() {
        return this.password;
    }

    BSONObject getDetailByName(String name) throws BaseException {
        BasicBSONObject condition = new BasicBSONObject();
        condition.put("GroupName", (Object)name);
        DBCursor shardsCursor = this.getList(7, 0, 0L, -1L, -1L, condition, null, null, null);
        if (shardsCursor == null || !shardsCursor.hasNext()) {
            return null;
        }
        return shardsCursor.getNext();
    }

    BSONObject getDetailById(int id) throws BaseException {
        BasicBSONObject condition = new BasicBSONObject();
        condition.put("GroupID", (Object)id);
        DBCursor shardsCursor = this.getList(7, 0, 0L, -1L, -1L, condition, null, null, null);
        if (shardsCursor == null || !shardsCursor.hasNext()) {
            return null;
        }
        return shardsCursor.getNext();
    }

    void releaseResource() {
        this.connection.shrinkBuffer();
    }

    private void initConnection(ConfigOptions options) throws BaseException {
        if (options == null) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        this.connection = new ConnectionTCPImpl(this.serverAddress, options);
        this.connection.initialize();
    }

    SDBMessage adminCommand(String commandString, int flag, long reqID, long skipNum, long returnNum, BSONObject query, BSONObject selector, BSONObject order, BSONObject hint) throws BaseException {
        BasicBSONObject dummyObj = new BasicBSONObject();
        SDBMessage sdbMessage = new SDBMessage();
        if (query == null) {
            sdbMessage.setMatcher(dummyObj);
        } else {
            sdbMessage.setMatcher(query);
        }
        if (selector == null) {
            sdbMessage.setSelector(dummyObj);
        } else {
            sdbMessage.setSelector(selector);
        }
        if (order == null) {
            sdbMessage.setOrderBy(dummyObj);
        } else {
            sdbMessage.setOrderBy(order);
        }
        if (hint == null) {
            sdbMessage.setHint(dummyObj);
        } else {
            sdbMessage.setHint(hint);
        }
        sdbMessage.setCollectionFullName("$" + commandString);
        sdbMessage.setVersion(1);
        sdbMessage.setW((short)0);
        sdbMessage.setPadding((short)0);
        sdbMessage.setFlags(flag);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        if (0L == reqID) {
            reqID = this.getNextRequstID();
        }
        sdbMessage.setRequestID(reqID);
        sdbMessage.setSkipRowsCount(skipNum);
        sdbMessage.setReturnRowsCount(returnNum);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_QUERY);
        byte[] request = SDBMessageHelper.buildQueryRequest(sdbMessage, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        return rtnSDBMessage;
    }

    private SDBMessage adminCommandEval(String commandString, int flag, long reqID, long skipNum, long returnNum, BSONObject query, BSONObject selector, BSONObject order, BSONObject hint) throws BaseException {
        BasicBSONObject dummyObj = new BasicBSONObject();
        SDBMessage sdbMessage = new SDBMessage();
        if (query == null) {
            sdbMessage.setMatcher(dummyObj);
        } else {
            sdbMessage.setMatcher(query);
        }
        if (selector == null) {
            sdbMessage.setSelector(dummyObj);
        } else {
            sdbMessage.setSelector(selector);
        }
        if (order == null) {
            sdbMessage.setOrderBy(dummyObj);
        } else {
            sdbMessage.setOrderBy(order);
        }
        if (hint == null) {
            sdbMessage.setHint(dummyObj);
        } else {
            sdbMessage.setHint(hint);
        }
        sdbMessage.setCollectionFullName("$" + commandString);
        sdbMessage.setVersion(1);
        sdbMessage.setW((short)0);
        sdbMessage.setPadding((short)0);
        sdbMessage.setFlags(flag);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        if (0L == reqID) {
            reqID = this.getNextRequstID();
        }
        sdbMessage.setRequestID(reqID);
        sdbMessage.setSkipRowsCount(skipNum);
        sdbMessage.setReturnRowsCount(returnNum);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_QUERY);
        byte[] request = SDBMessageHelper.buildQueryRequest(sdbMessage, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        return rtnSDBMessage;
    }

    private SDBMessage createCS(String csName, BSONObject options) throws BaseException {
        String commandString = "$create collectionspace";
        BasicBSONObject cObj = new BasicBSONObject();
        BasicBSONObject dummyObj = new BasicBSONObject();
        SDBMessage sdbMessage = new SDBMessage();
        cObj.put("Name", (Object)csName);
        if (null != options) {
            cObj.putAll(options);
        }
        sdbMessage.setMatcher(cObj);
        sdbMessage.setCollectionFullName(commandString);
        sdbMessage.setVersion(1);
        sdbMessage.setW((short)0);
        sdbMessage.setPadding((short)0);
        sdbMessage.setFlags(0);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        sdbMessage.setRequestID(this.getNextRequstID());
        sdbMessage.setSkipRowsCount(-1L);
        sdbMessage.setReturnRowsCount(-1L);
        sdbMessage.setSelector(dummyObj);
        sdbMessage.setOrderBy(dummyObj);
        sdbMessage.setHint(dummyObj);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_QUERY);
        byte[] request = SDBMessageHelper.buildQueryRequest(sdbMessage, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        if (this.endianConvert) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        return rtnSDBMessage;
    }

    private boolean requestSysInfo() {
        byte[] request = SDBMessageHelper.buildSysInfoRequest();
        this.connection.sendMessage(request);
        boolean endianConvert = SDBMessageHelper.msgExtractSysInfoReply(this.connection.receiveSysInfoMsg(128));
        return endianConvert;
    }

    private void sendKillContextMsg() {
        if (this.connection == null) {
            throw new BaseException("SDB_NETWORK", new Object[0]);
        }
        long[] contextIds = new long[]{-1L};
        byte[] request = SDBMessageHelper.buildKillCursorMsg(0L, contextIds, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtnSDBMessage.getOperationCode() != SequoiadbConstants.Operation.OP_KILL_CONTEXT_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtnSDBMessage.getOperationCode()});
        }
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public static enum SptReturnType {
        TYPE_VOID(0),
        TYPE_STR(1),
        TYPE_NUMBER(2),
        TYPE_OBJ(3),
        TYPE_BOOL(4),
        TYPE_RECORDSET(5),
        TYPE_CS(6),
        TYPE_CL(7),
        TYPE_RG(8),
        TYPE_RN(9);

        private int typeValue;

        private SptReturnType(int typeValue) {
            this.typeValue = typeValue;
        }

        public int getTypeValue() {
            return this.typeValue;
        }

        public static SptReturnType getTypeByValue(int typeValue) {
            SptReturnType retType = null;
            for (SptReturnType rt : SptReturnType.values()) {
                if (rt.getTypeValue() != typeValue) continue;
                retType = rt;
                break;
            }
            return retType;
        }
    }

    public static class SptEvalResult {
        private SptReturnType returnType = null;
        private BSONObject errmsg = null;
        private DBCursor cursor = null;

        public void setReturnType(SptReturnType returnType) {
            this.returnType = returnType;
        }

        public SptReturnType getReturnType() {
            return this.returnType;
        }

        public void setErrMsg(BSONObject errmsg) {
            this.errmsg = errmsg;
        }

        public BSONObject getErrMsg() {
            return this.errmsg;
        }

        public void setCursor(DBCursor cursor) {
            this.cursor = cursor;
        }

        public DBCursor getCursor() {
            return this.cursor;
        }
    }
}

