/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.CleanConnectionTask;
import com.sequoiadb.base.CreateConnectionTask;
import com.sequoiadb.base.RecaptureCoordAddrTask;
import com.sequoiadb.base.SDExitThread;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.base.SequoiadbOption;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.net.ConfigOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class SequoiadbDatasource {
    private volatile LinkedList<Sequoiadb> idle_sequoiadbs = new LinkedList();
    private volatile LinkedList<Sequoiadb> used_sequoiadbs = new LinkedList();
    private volatile ArrayList<String> normal_urls = new ArrayList();
    private volatile ArrayList<String> abnormal_urls = new ArrayList();
    private String username = null;
    private String password = null;
    private ConfigOptions nwOpt = null;
    private SequoiadbOption dsOpt = null;
    private Timer timer = new Timer(true);
    private Timer timer2 = new Timer(true);
    private final double MULTIPLE = 1.2;
    private final double MULTIPLE2 = 0.8;
    private Random rand = new Random(47L);
    private boolean isClosed = false;

    public synchronized int getIdleConnNum() {
        return this.idle_sequoiadbs.size();
    }

    public synchronized int getUsedConnNum() {
        return this.used_sequoiadbs.size();
    }

    public synchronized int getNormalAddrNum() {
        return this.normal_urls.size();
    }

    public synchronized int getAbnormalAddrNum() {
        return this.abnormal_urls.size();
    }

    public synchronized void addCoord(String url) {
        this.normal_urls.add(url);
    }

    public SequoiadbDatasource(List<String> urls, String username, String password, ConfigOptions nwOpt, SequoiadbOption dsOpt) throws BaseException {
        if (null == urls || 0 == urls.size()) {
            throw new BaseException("SDB_INVALIDARG", urls);
        }
        ConfigOptions temp = new ConfigOptions();
        temp.setConnectTimeout(100);
        temp.setMaxAutoConnectRetryTime(0L);
        this.username = null == username ? "" : username;
        this.password = null == password ? "" : password;
        this.nwOpt = null == nwOpt ? temp : nwOpt;
        this.dsOpt = null == dsOpt ? new SequoiadbOption() : dsOpt;
        this.normal_urls.addAll(urls);
        this.init(this.dsOpt);
        this.timer.schedule((TimerTask)new CleanConnectionTask(this), this.dsOpt.getRecheckCyclePeriod(), (long)this.dsOpt.getRecheckCyclePeriod());
        this.timer2.schedule((TimerTask)new RecaptureCoordAddrTask(this), this.dsOpt.getRecaptureConnPeriod(), (long)this.dsOpt.getRecaptureConnPeriod());
        Runtime.getRuntime().addShutdownHook(new SDExitThread(this));
    }

    public SequoiadbDatasource(String url, String username, String password, SequoiadbOption dsOpt) throws BaseException {
        if (null == url) {
            throw new BaseException("SDB_INVALIDARG", url);
        }
        this.normal_urls.add(url);
        ConfigOptions temp = new ConfigOptions();
        temp.setConnectTimeout(100);
        temp.setMaxAutoConnectRetryTime(0L);
        this.username = null == username ? "" : username;
        this.password = null == password ? "" : password;
        this.nwOpt = null == this.nwOpt ? temp : this.nwOpt;
        this.dsOpt = null == dsOpt ? new SequoiadbOption() : dsOpt;
        this.init(this.dsOpt);
        this.timer.schedule((TimerTask)new CleanConnectionTask(this), dsOpt.getRecheckCyclePeriod(), (long)dsOpt.getRecheckCyclePeriod());
        Runtime.getRuntime().addShutdownHook(new SDExitThread(this));
    }

    private void init(SequoiadbOption dsOpt) throws BaseException {
        if (dsOpt.getMaxConnectionNum() < 0) {
            throw new BaseException("SDB_INVALIDARG", "maxConnectionNum is negative: " + dsOpt.getMaxConnectionNum());
        }
        if (dsOpt.getMaxConnectionNum() == 0) {
            return;
        }
        if (dsOpt.getMaxConnectionNum() < dsOpt.getInitConnectionNum()) {
            throw new BaseException("SDB_INVALIDARG", "maxConnectionNum is less than initConnectionNum, maxConnectionNum is " + dsOpt.getMaxConnectionNum() + ", initConnectionNum is " + dsOpt.getInitConnectionNum());
        }
        if (dsOpt.getInitConnectionNum() < 0) {
            throw new BaseException("SDB_INVALIDARG", "initConnectionNum is negative: " + dsOpt.getInitConnectionNum());
        }
        this.increaseConn(dsOpt.getInitConnectionNum());
    }

    private synchronized String getCoordAddr() throws BaseException {
        if (1 < this.normal_urls.size()) {
            return this.normal_urls.get(this.rand.nextInt(this.normal_urls.size()));
        }
        if (1 == this.normal_urls.size()) {
            return this.normal_urls.get(0);
        }
        throw new BaseException("SDB_INVALIDARG", "no available address");
    }

    synchronized void getBackCoordAddr() {
        Sequoiadb sdb = null;
        String addr = null;
        if (0 == this.abnormal_urls.size()) {
            return;
        }
        for (int i = 0; i < this.abnormal_urls.size(); ++i) {
            addr = this.abnormal_urls.get(i);
            try {
                sdb = new Sequoiadb(addr, this.username, this.password, this.nwOpt);
                if (!sdb.isValid()) continue;
                this.normal_urls.add(addr);
                this.abnormal_urls.remove(addr);
                --i;
                continue;
            }
            catch (BaseException e) {
                // empty catch block
            }
        }
    }

    private synchronized Sequoiadb getConnDrt() throws BaseException {
        Sequoiadb sdb = null;
        String addr = this.getCoordAddr();
        while (this.normal_urls.size() > 0) {
            try {
                sdb = new Sequoiadb(addr, this.username, this.password, this.nwOpt);
                break;
            }
            catch (BaseException e) {
                String errType = e.getErrorType();
                if (errType.equals("SDB_NETWORK") || errType.equals("SDB_INVALIDARG") || errType.equals("SDB_NET_CANNOT_CONNECT")) {
                    this.abnormal_urls.add(addr);
                    this.normal_urls.remove(addr);
                    addr = this.getCoordAddr();
                    continue;
                }
                throw e;
            }
        }
        if (null == sdb) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        return sdb;
    }

    public synchronized Sequoiadb getConnection() throws BaseException, InterruptedException {
        if (this.dsOpt.getMaxConnectionNum() == 0) {
            return this.getConnDrt();
        }
        Sequoiadb sdb = null;
        if (this.idle_sequoiadbs.size() > 0 && this.used_sequoiadbs.size() < this.dsOpt.getMaxConnectionNum()) {
            sdb = this.idle_sequoiadbs.poll();
            while (null != sdb && !sdb.isValid()) {
                sdb = this.idle_sequoiadbs.poll();
            }
            if (null == sdb) {
                sdb = this.getConnDrt();
            }
            this.used_sequoiadbs.add(sdb);
        } else {
            if (this.used_sequoiadbs.size() >= this.dsOpt.getMaxConnectionNum()) {
                this.wait(this.dsOpt.getTimeout());
                if (this.used_sequoiadbs.size() >= this.dsOpt.getMaxConnectionNum()) {
                    throw new BaseException("SDB_DRIVER_DS_RUNOUT", new Object[0]);
                }
            }
            sdb = this.getConnDrt();
            this.used_sequoiadbs.add(sdb);
            Thread t = new Thread(new CreateConnectionTask(this));
            t.start();
        }
        return sdb;
    }

    public synchronized void close(Sequoiadb sdb) throws BaseException {
        if (null == sdb) {
            throw new BaseException("SDB_INVALIDARG", sdb);
        }
        if (this.dsOpt.getAbandonTime() <= 0) {
            throw new BaseException("SDB_INVALIDARG", "abandonTime is negative: " + this.dsOpt.getAbandonTime());
        }
        if (this.dsOpt.getRecheckCyclePeriod() <= 0) {
            throw new BaseException("SDB_INVALIDARG", "recheckCyclePeriod is negative: " + this.dsOpt.getRecheckCyclePeriod());
        }
        if (this.dsOpt.getRecheckCyclePeriod() >= this.dsOpt.getAbandonTime()) {
            throw new BaseException("SDB_INVALIDARG", "recheckCyclePeriod is not less than abandonTime, recheckCyclePeriod is " + this.dsOpt.getRecheckCyclePeriod() + ", abandonTime is " + this.dsOpt.getAbandonTime());
        }
        if (this.used_sequoiadbs.contains(sdb)) {
            this.used_sequoiadbs.remove(sdb);
            if (this.dsOpt.getMaxConnectionNum() == 0) {
                sdb.disconnect();
                return;
            }
            long lastTime = sdb.getConnection().getLastUseTime();
            long currentTime = System.currentTimeMillis();
            if ((double)(currentTime - lastTime) + 1.2 * (double)this.dsOpt.getRecheckCyclePeriod() >= (double)this.dsOpt.getAbandonTime()) {
                sdb.disconnect();
                return;
            }
        } else {
            sdb.disconnect();
            return;
        }
        sdb.closeAllCursors();
        sdb.releaseResource();
        this.idle_sequoiadbs.add(sdb);
        this.notify();
    }

    synchronized void increaseConnetions() throws BaseException {
        if (this.isClosed) {
            return;
        }
        if (this.dsOpt.getMaxConnectionNum() == 0) {
            return;
        }
        if (this.idle_sequoiadbs.size() >= this.dsOpt.getMaxIdeNum()) {
            return;
        }
        if (this.dsOpt.getDeltaIncCount() < 0) {
            throw new BaseException("SDB_INVALIDARG", "deltaIncCount is negative: " + this.dsOpt.getDeltaIncCount());
        }
        if (this.dsOpt.getMaxConnectionNum() < this.dsOpt.getDeltaIncCount()) {
            throw new BaseException("SDB_INVALIDARG", "deltaIncCount is greater than maxConnectionNum, deltaIncCount is " + this.dsOpt.getDeltaIncCount() + ", maxConnectionNum is " + this.dsOpt.getMaxConnectionNum());
        }
        if (this.used_sequoiadbs.size() < this.dsOpt.getMaxConnectionNum() - this.dsOpt.getDeltaIncCount()) {
            this.increaseConn(this.dsOpt.getDeltaIncCount());
        } else {
            this.increaseConn(this.dsOpt.getMaxConnectionNum() - this.used_sequoiadbs.size());
        }
    }

    synchronized void cleanAbandonConnection() throws BaseException {
        if (this.isClosed) {
            return;
        }
        if (0 == this.idle_sequoiadbs.size() && 0 == this.used_sequoiadbs.size()) {
            return;
        }
        if (this.dsOpt.getAbandonTime() <= 0) {
            throw new BaseException("SDB_INVALIDARG", "abandonTime is negative: " + this.dsOpt.getAbandonTime());
        }
        if (this.dsOpt.getRecheckCyclePeriod() <= 0) {
            throw new BaseException("SDB_INVALIDARG", "recheckCyclePeriod is negative: " + this.dsOpt.getRecheckCyclePeriod());
        }
        if (this.dsOpt.getRecheckCyclePeriod() >= this.dsOpt.getAbandonTime()) {
            throw new BaseException("SDB_INVALIDARG", "recheckCyclePeriod is not less than abandonTime, recheckCyclePeriod is " + this.dsOpt.getRecheckCyclePeriod() + ", abandonTime is " + this.dsOpt.getAbandonTime());
        }
        long lastTime = 0L;
        long currentTime = System.currentTimeMillis();
        ListIterator<Sequoiadb> list1 = this.idle_sequoiadbs.listIterator(0);
        while (list1.hasNext()) {
            Sequoiadb db = list1.next();
            lastTime = db.getConnection().getLastUseTime();
            if (!((double)(currentTime - lastTime) + 1.2 * (double)this.dsOpt.getRecheckCyclePeriod() >= (double)this.dsOpt.getAbandonTime())) continue;
            db.disconnect();
            list1.remove();
        }
        for (int i = 0; i < this.idle_sequoiadbs.size() - this.dsOpt.getMaxIdeNum(); ++i) {
            Sequoiadb db = this.idle_sequoiadbs.poll();
            db.disconnect();
            --i;
        }
    }

    private synchronized void increaseConn(int num) {
        if (num < 0) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        for (int i = 0; i < num; ++i) {
            String coordAddr = this.getCoordAddr();
            Sequoiadb sdb = null;
            try {
                sdb = new Sequoiadb(coordAddr, this.username, this.password, this.nwOpt);
            }
            catch (BaseException e) {
                String errType = e.getErrorType();
                if (errType.equals("SDB_NETWORK") || errType.equals("SDB_INVALIDARG") || errType.equals("SDB_NET_CANNOT_CONNECT")) {
                    this.abnormal_urls.add(coordAddr);
                    this.normal_urls.remove(coordAddr);
                    --i;
                    continue;
                }
                throw e;
            }
            this.idle_sequoiadbs.add(sdb);
        }
    }

    public synchronized void close() {
        this.timer.cancel();
        this.timer2.cancel();
        Iterator iterUsed = this.used_sequoiadbs.iterator();
        while (iterUsed.hasNext()) {
            Sequoiadb db = (Sequoiadb)iterUsed.next();
            db.disconnect();
            iterUsed.remove();
        }
        Iterator iterIdle = this.idle_sequoiadbs.iterator();
        while (iterIdle.hasNext()) {
            Sequoiadb db = (Sequoiadb)iterIdle.next();
            db.disconnect();
            iterIdle.remove();
        }
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }
}

