/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.exception;

import com.sequoiadb.exception.SDBError;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class SDBErrorLookup {
    private static HashMap<String, SDBError> mapByType;
    private static HashMap<Integer, SDBError> mapByCode;

    public SDBErrorLookup() throws Exception {
        SDBErrorLookup.loadErrorMap();
    }

    private static void loadErrorMap() throws Exception {
        mapByType = new HashMap();
        mapByCode = new HashMap();
        InputStream in = SDBErrorLookup.class.getClassLoader().getResourceAsStream("errors.properties");
        Properties properties = new Properties();
        properties.load(in);
        Enumeration<Object> em = properties.keys();
        while (em.hasMoreElements()) {
            String errorType = (String)em.nextElement();
            String proValue = (String)properties.get(errorType);
            String[] tmp = proValue.split(":");
            String errorCodeStr = tmp[0].trim();
            String errorDesc = tmp[1].trim();
            int errorCode = Integer.parseInt(errorCodeStr);
            SDBError err = new SDBError();
            err.setErrorCode(errorCode);
            err.setErrorDescription(errorDesc);
            err.setErrorType(errorType);
            mapByCode.put(errorCode, err);
            mapByType.put(errorType, err);
        }
    }

    public static String getErrorDescriptionByType(String errorType) throws Exception {
        SDBError errObj;
        if (mapByType == null) {
            SDBErrorLookup.loadErrorMap();
        }
        if ((errObj = mapByType.get(errorType)) != null) {
            return errObj.getErrorDescription();
        }
        return "Unknown Error";
    }

    public static String getErrorDescriptionByCode(int errorCode) throws Exception {
        SDBError errObj;
        if (mapByCode == null) {
            SDBErrorLookup.loadErrorMap();
        }
        if ((errObj = mapByCode.get(errorCode)) != null) {
            return errObj.getErrorDescription();
        }
        return "Unknown Error";
    }

    public static int getErrorCodeByType(String errorType) throws Exception {
        SDBError errObj;
        if (mapByType == null) {
            SDBErrorLookup.loadErrorMap();
        }
        if ((errObj = mapByType.get(errorType)) != null) {
            return errObj.getErrorCode();
        }
        return 1;
    }

    public static String getErrorTypeByCode(int errorCode) throws Exception {
        SDBError errObj;
        if (mapByCode == null) {
            SDBErrorLookup.loadErrorMap();
        }
        if ((errObj = mapByCode.get(errorCode)) != null) {
            return errObj.getErrorType();
        }
        return "UNKNOWN";
    }
}

