/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.shiro.authz;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.shiro.authz.PermissionsEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;

public class CustomDataPermissionsEditor
implements PermissionsEditor {
    public static final String DEFAULT_CUSTOM_DATA_FIELD_NAME = "apacheShiroPermissions";
    private final CustomData CUSTOM_DATA;
    private String fieldName = "apacheShiroPermissions";

    public CustomDataPermissionsEditor(CustomData customData) {
        Assert.notNull((Object)customData, (String)"CustomData argument cannot be null.");
        this.CUSTOM_DATA = customData;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public CustomDataPermissionsEditor setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Override
    public PermissionsEditor append(String perm) {
        Assert.hasText((String)perm, (String)"Permission string argument cannot be null or empty.");
        Collection<String> perms = this.lookupPermissionStrings();
        String fieldName = this.getFieldName();
        if (perms == null) {
            perms = new LinkedHashSet<String>();
            this.CUSTOM_DATA.put((Object)fieldName, perms);
        } else if (perms instanceof List) {
            perms = CustomDataPermissionsEditor.asSet(fieldName, (List)perms);
            this.CUSTOM_DATA.put((Object)fieldName, perms);
        }
        perms.add(perm);
        return this;
    }

    @Override
    public PermissionsEditor remove(String perm) {
        Collection<String> perms;
        if (StringUtils.hasText((String)perm) && !CollectionUtils.isEmpty(perms = this.lookupPermissionStrings())) {
            if (perms instanceof List) {
                String attrName = this.getFieldName();
                perms = CustomDataPermissionsEditor.asSet(attrName, (List)perms);
                this.CUSTOM_DATA.put((Object)attrName, perms);
            }
            perms.remove(perm);
        }
        return this;
    }

    @Override
    public Set<String> getPermissionStrings() {
        Set<String> set;
        Collection<String> perms = this.lookupPermissionStrings();
        if (CollectionUtils.isEmpty(perms)) {
            return Collections.emptySet();
        }
        if (perms instanceof List) {
            set = CustomDataPermissionsEditor.asSet(this.getFieldName(), (List)perms);
        } else {
            assert (perms instanceof Set) : "perms instance must be a Set<String>";
            set = (Set<String>)perms;
        }
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> asSet(String fieldName, List list) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(list.size());
        for (Object element : list) {
            if (element == null) continue;
            if (!(element instanceof String)) {
                String msg = "CustomData field '" + fieldName + "' contains an element that is not a String " + "as required. Element type: " + element.getClass().getName() + ", element value: " + element;
                throw new IllegalArgumentException(msg);
            }
            String s = (String)element;
            set.add(s);
        }
        return set;
    }

    private Collection<String> lookupPermissionStrings() {
        String fieldName = this.getFieldName();
        Object value = this.CUSTOM_DATA.get((Object)fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Set) {
            return (Set)value;
        }
        List permList = null;
        if (!(value instanceof List)) {
            String msg = "Unable to recognize CustomData field '" + fieldName + "' value of type " + value.getClass().getName() + ".  Expected type: Set<String> or List<String>.";
            throw new IllegalArgumentException(msg);
        }
        permList = (List)value;
        return permList;
    }
}

