/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.shiro.realm;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.UsernamePasswordRequest;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.shiro.realm.AccountCustomDataPermissionResolver;
import com.stormpath.shiro.realm.AccountPermissionResolver;
import com.stormpath.shiro.realm.AccountRoleResolver;
import com.stormpath.shiro.realm.DefaultGroupRoleResolver;
import com.stormpath.shiro.realm.GroupCustomDataPermissionResolver;
import com.stormpath.shiro.realm.GroupPermissionResolver;
import com.stormpath.shiro.realm.GroupRoleResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;

public class ApplicationRealm
extends AuthorizingRealm {
    private Client client;
    private String applicationRestUrl;
    private GroupRoleResolver groupRoleResolver;
    private GroupPermissionResolver groupPermissionResolver;
    private AccountPermissionResolver accountPermissionResolver;
    private AccountRoleResolver accountRoleResolver;
    private Application application;

    public ApplicationRealm() {
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
        this.setGroupRoleResolver(new DefaultGroupRoleResolver());
        this.setGroupPermissionResolver(new GroupCustomDataPermissionResolver());
        this.setAccountPermissionResolver(new AccountCustomDataPermissionResolver());
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getApplicationRestUrl() {
        return this.applicationRestUrl;
    }

    public void setApplicationRestUrl(String applicationRestUrl) {
        this.applicationRestUrl = applicationRestUrl;
    }

    public GroupRoleResolver getGroupRoleResolver() {
        return this.groupRoleResolver;
    }

    public void setGroupRoleResolver(GroupRoleResolver groupRoleResolver) {
        this.groupRoleResolver = groupRoleResolver;
    }

    public GroupPermissionResolver getGroupPermissionResolver() {
        return this.groupPermissionResolver;
    }

    public void setGroupPermissionResolver(GroupPermissionResolver groupPermissionResolver) {
        this.groupPermissionResolver = groupPermissionResolver;
    }

    public AccountPermissionResolver getAccountPermissionResolver() {
        return this.accountPermissionResolver;
    }

    public void setAccountPermissionResolver(AccountPermissionResolver accountPermissionResolver) {
        this.accountPermissionResolver = accountPermissionResolver;
    }

    public AccountRoleResolver getAccountRoleResolver() {
        return this.accountRoleResolver;
    }

    public void setAccountRoleResolver(AccountRoleResolver accountRoleResolver) {
        this.accountRoleResolver = accountRoleResolver;
    }

    protected void onInit() {
        super.onInit();
        this.assertState();
    }

    private void assertState() {
        if (this.client == null) {
            throw new IllegalStateException("Stormpath SDK Client instance must be configured.");
        }
        if (this.applicationRestUrl == null) {
            throw new IllegalStateException("\n\nThis application's Stormpath REST URL must be configured.\n\n  You may get your application's Stormpath REST URL as shown here:\n\n http://www.stormpath.com/docs/application-rest-url\n\nCopy and paste the 'REST URL' value as the 'applicationRestUrl' property of this class.");
        }
    }

    protected final Application ensureApplicationReference() {
        if (this.application == null) {
            this.assertState();
            String href = this.getApplicationRestUrl();
            this.application = (Application)this.client.getDataStore().getResource(href, Application.class);
        }
        return this.application;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        PrincipalCollection principals;
        Account account;
        this.assertState();
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        AuthenticationRequest request = this.createAuthenticationRequest(token);
        Application application = this.ensureApplicationReference();
        try {
            account = application.authenticateAccount(request).getAccount();
        }
        catch (ResourceException e) {
            String msg = StringUtils.clean((String)e.getMessage());
            if (msg == null) {
                msg = StringUtils.clean((String)e.getDeveloperMessage());
            }
            if (msg == null) {
                msg = "Invalid login or password.";
            }
            throw new AuthenticationException(msg, (Throwable)e);
        }
        try {
            principals = this.createPrincipals(account);
        }
        catch (Exception e) {
            throw new AuthenticationException("Unable to obtain authenticated account properties.", (Throwable)e);
        }
        return new SimpleAuthenticationInfo(principals, null);
    }

    protected AuthenticationRequest createAuthenticationRequest(UsernamePasswordToken token) {
        String username = token.getUsername();
        char[] password = token.getPassword();
        String host = token.getHost();
        return new UsernamePasswordRequest(username, password, host);
    }

    protected PrincipalCollection createPrincipals(Account account) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("href", account.getHref());
        this.nullSafePut(props, "username", account.getUsername());
        this.nullSafePut(props, "email", account.getEmail());
        this.nullSafePut(props, "givenName", account.getGivenName());
        this.nullSafePut(props, "middleName", account.getMiddleName());
        this.nullSafePut(props, "surname", account.getSurname());
        ArrayList<Object> principals = new ArrayList<Object>(2);
        principals.add(account.getHref());
        principals.add(props);
        return new SimplePrincipalCollection(principals, this.getName());
    }

    private void nullSafePut(Map<String, String> props, String propName, String value) {
        if ((value = StringUtils.clean((String)value)) != null) {
            props.put(propName, value);
        }
    }

    protected String getAccountHref(PrincipalCollection principals) {
        Collection c = principals.fromRealm(this.getName());
        return (String)c.iterator().next();
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        this.assertState();
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        String href = this.getAccountHref(principals);
        Account account = (Account)this.getClient().getDataStore().getResource(href, Account.class);
        GroupList groups = account.getGroups();
        for (Group group : groups) {
            Set<String> groupRoles = this.resolveRoles(group);
            for (String roleName : groupRoles) {
                info.addRole(roleName);
            }
            Set<Permission> permissions = this.resolvePermissions(group);
            for (Permission permission : permissions) {
                info.addObjectPermission(permission);
            }
        }
        Set<String> accountRoles = this.resolveRoles(account);
        for (String roleName : accountRoles) {
            info.addRole(roleName);
        }
        Set<Permission> accountPermissions = this.resolvePermissions(account);
        for (Permission permission : accountPermissions) {
            info.addObjectPermission(permission);
        }
        if (CollectionUtils.isEmpty((Collection)info.getRoles()) && CollectionUtils.isEmpty((Collection)info.getObjectPermissions()) && CollectionUtils.isEmpty((Collection)info.getStringPermissions())) {
            return null;
        }
        return info;
    }

    private Set<Permission> resolvePermissions(Account account) {
        if (this.accountPermissionResolver != null) {
            return this.accountPermissionResolver.resolvePermissions(account);
        }
        return Collections.emptySet();
    }

    private Set<Permission> resolvePermissions(Group group) {
        if (this.groupPermissionResolver != null) {
            return this.groupPermissionResolver.resolvePermissions(group);
        }
        return Collections.emptySet();
    }

    private Set<String> resolveRoles(Group group) {
        if (this.groupRoleResolver != null) {
            return this.groupRoleResolver.resolveRoles(group);
        }
        return Collections.emptySet();
    }

    private Set<String> resolveRoles(Account account) {
        if (this.accountRoleResolver != null) {
            return this.accountRoleResolver.resolveRoles(account);
        }
        return Collections.emptySet();
    }
}

