/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.shiro.realm;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.shiro.authz.CustomDataPermissionsEditor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;
import org.apache.shiro.util.CollectionUtils;

public class CustomDataPermissionResolver {
    private String customDataFieldName = "apacheShiroPermissions";
    private PermissionResolver permissionResolver = new WildcardPermissionResolver();

    public String getCustomDataFieldName() {
        return this.customDataFieldName;
    }

    public void setCustomDataFieldName(String customDataFieldName) {
        this.customDataFieldName = customDataFieldName;
    }

    public PermissionResolver getPermissionResolver() {
        return this.permissionResolver;
    }

    public void setPermissionResolver(PermissionResolver permissionResolver) {
        this.permissionResolver = permissionResolver;
    }

    protected Set<String> getPermissionStrings(CustomData customData) {
        return new CustomDataPermissionsEditor(customData).setFieldName(this.getCustomDataFieldName()).getPermissionStrings();
    }

    protected Set<Permission> getPermissions(CustomData customData) {
        Set<String> permStrings = this.getPermissionStrings(customData);
        if (CollectionUtils.isEmpty(permStrings)) {
            return Collections.emptySet();
        }
        PermissionResolver permissionResolver = this.getPermissionResolver();
        HashSet<Permission> perms = new HashSet<Permission>(permStrings.size());
        for (String s : permStrings) {
            Permission perm = permissionResolver.resolvePermission(s);
            perms.add(perm);
        }
        return perms;
    }
}

