/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.shiro.realm;

import com.stormpath.sdk.group.Group;
import com.stormpath.shiro.realm.GroupRoleResolver;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.util.CollectionUtils;

public class DefaultGroupRoleResolver
implements GroupRoleResolver {
    private Set<Mode> modes = CollectionUtils.asSet((Object[])new Mode[]{Mode.HREF});

    public Set<Mode> getModes() {
        return this.modes;
    }

    public void setModes(Set<Mode> modes) {
        if (modes == null || modes.isEmpty()) {
            throw new IllegalArgumentException("modes property cannot be null or empty.");
        }
        this.modes = modes;
    }

    public Set<String> getModeNames() {
        HashSet<String> names = new HashSet<String>(this.modes.size());
        for (Mode mode : this.modes) {
            names.add(mode.name());
        }
        return names;
    }

    public void setModeNames(Set<String> modeNames) {
        if (modeNames == null || modeNames.isEmpty()) {
            throw new IllegalArgumentException("modeNames cannot be null or empty");
        }
        HashSet<Mode> modes = new HashSet<Mode>(CollectionUtils.size(modeNames));
        for (String name : modeNames) {
            modes.add(Mode.fromString(name));
        }
        this.setModes(modes);
    }

    @Override
    public Set<String> resolveRoles(Group group) {
        String name;
        String instanceId;
        HashSet<String> set = new HashSet<String>();
        Set<Mode> modes = this.getModes();
        String groupHref = group.getHref();
        if (groupHref == null) {
            throw new IllegalStateException("Group does not have an href property.  This should never happen.");
        }
        if (modes.contains((Object)Mode.HREF)) {
            set.add(groupHref);
        }
        if (modes.contains((Object)Mode.ID) && (instanceId = this.getInstanceId(groupHref)) != null) {
            set.add(instanceId);
        }
        if (modes.contains((Object)Mode.NAME) && (name = group.getName()) != null) {
            set.add(name);
        }
        return set;
    }

    private String getInstanceId(String href) {
        int i = href.lastIndexOf(47);
        if (i >= 0) {
            return href.substring(i + 1);
        }
        return null;
    }

    public static enum Mode {
        HREF,
        ID,
        NAME;


        public static Mode fromString(String name) {
            String upper = name.toUpperCase();
            for (Mode mode : Mode.values()) {
                if (!mode.name().equals(upper)) continue;
                return mode;
            }
            throw new IllegalArgumentException("There is no Mode name '" + name + "'");
        }
    }
}

