/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair;

import com.taobao.tair.DataEntryAbstract;
import com.taobao.tair.etc.TairUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DataEntry
extends DataEntryAbstract<Object>
implements Serializable {
    private static final long serialVersionUID = -3492001385938512871L;
    private static byte[] DEFAULT_DATA = new byte[29];
    private Object key;
    private int magic;
    private int checkSum;
    private int keySize;
    private int version;
    private int padSize;
    private int valueSize;
    private int flag;
    private int cdate;
    private int mdate;
    private int edate;
    public static final int TAIR_ITEM_FLAG_ADDCOUNT = 1;
    public static final int TAIR_ITEM_LOCKED = 8;

    public boolean isLocked() {
        return (this.flag & 8) != 0;
    }

    public int getExpriedDate() {
        return this.edate;
    }

    public int getCreateDate() {
        return this.cdate;
    }

    public int getModifyDate() {
        return this.mdate;
    }

    public DataEntry() {
    }

    public DataEntry(Object value) {
        this.value = value;
    }

    public DataEntry(Object key, Object value) {
        this.key = key;
        this.value = value;
    }

    public DataEntry(Object key, Object value, int version) {
        this.key = key;
        this.value = value;
        this.version = version;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void decodeMeta(ByteBuffer bytes) {
        this.magic = bytes.getShort();
        this.checkSum = bytes.getShort();
        this.keySize = bytes.getShort();
        this.version = bytes.getShort();
        this.padSize = bytes.getInt();
        this.valueSize = bytes.getInt();
        this.flag = bytes.get();
        this.cdate = bytes.getInt();
        this.mdate = bytes.getInt();
        this.edate = bytes.getInt();
    }

    public static void encodeMeta(ByteBuffer bytes) {
        bytes.put(DEFAULT_DATA);
    }

    public static void encodeMeta(ByteBuffer bytes, int flag) {
        bytes.put(DEFAULT_DATA);
        if (flag != 0) {
            bytes.putInt(bytes.position() - 16, flag);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("key: ").append(this.key);
        sb.append(", value: ").append(this.value);
        sb.append(", version: ").append(this.version).append("\n\t");
        sb.append("cdate: ").append(TairUtil.formatDate(this.cdate)).append("\n\t");
        sb.append("mdate: ").append(TairUtil.formatDate(this.mdate)).append("\n\t");
        sb.append("edate: ").append(this.edate > 0 ? TairUtil.formatDate(this.edate) : "NEVER").append("\n");
        return sb.toString();
    }

    static {
        Arrays.fill(DEFAULT_DATA, (byte)0);
    }
}

