/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultCode {
    private static final Log log = LogFactory.getLog(ResultCode.class);
    public static final Map<Integer, ResultCode> codeMap = new HashMap<Integer, ResultCode>();
    public static final ResultCode SUCCESS = ResultCode.createResultCode(0, "success");
    public static final ResultCode DATANOTEXSITS = ResultCode.createResultCode(1, "data not exist");
    public static final ResultCode CONNERROR = ResultCode.createResultCode(-1, "connection error or timeout");
    public static final ResultCode UNKNOW = ResultCode.createResultCode(-2, "unkonw error");
    public static final ResultCode SERVERERROR = ResultCode.createResultCode(-3999, "server error");
    public static final ResultCode VERERROR = ResultCode.createResultCode(-3997, "version error");
    public static final ResultCode TYPENOTMATCH = ResultCode.createResultCode(-3996, "type not match");
    public static final ResultCode PLUGINERROR = ResultCode.createResultCode(-3995, "plugin error");
    public static final ResultCode SERIALIZEERROR = ResultCode.createResultCode(-3994, "serialize error");
    public static final ResultCode ITEMEMPRY = ResultCode.createResultCode(-3993, "item empty");
    public static final ResultCode OUTOFRANGE = ResultCode.createResultCode(-3992, "item out of range");
    public static final ResultCode ITEMSIZEERROR = ResultCode.createResultCode(-3991, "item size error");
    public static final ResultCode SENDFAILED = ResultCode.createResultCode(-3990, "send packet failed");
    public static final ResultCode TIMEOUT = ResultCode.createResultCode(-3989, "timeout");
    public static final ResultCode DATAEXPIRED = ResultCode.createResultCode(-3988, "data expired");
    public static final ResultCode SERVERCANTWORK = ResultCode.createResultCode(-3987, "server can not work");
    public static final ResultCode WRITENOTONMASTER = ResultCode.createResultCode(-3986, "write not on master");
    public static final ResultCode DUPLICATEBUSY = ResultCode.createResultCode(-3985, "duplicate busy");
    public static final ResultCode MIGRATEBUSY = ResultCode.createResultCode(-3984, "migrate busy");
    public static final ResultCode INVALIDARG = ResultCode.createResultCode(-3982, "invalid argument");
    public static final ResultCode CANNT_OVERRIDE = ResultCode.createResultCode(-3981, "can not override");
    public static final ResultCode KEYTOLARGE = ResultCode.createResultCode(-5, "key length error");
    public static final ResultCode VALUETOLARGE = ResultCode.createResultCode(-6, "value length error");
    public static final ResultCode NSERROR = ResultCode.createResultCode(-7, "namsepace range error, should between 0 ~ 1023");
    public static final ResultCode PARTSUCC = ResultCode.createResultCode(-10, "partly success");
    public static final ResultCode COUNT_BOUNDS = ResultCode.createResultCode(-3980, "count reach bound");
    public static final ResultCode COUNT_ZERO = ResultCode.createResultCode(-3979, "count reach zero");
    public static final ResultCode COUNT_NOTFOUND = ResultCode.createResultCode(-3978, "count not exist");
    public static final ResultCode LOCK_EXIST = new ResultCode(-3975, "lock already exist");
    public static final ResultCode LOCK_NOT_EXIST = new ResultCode(-3974, "lock not exist");
    public static final ResultCode TARGET_NOT_NUMBER = ResultCode.createResultCode(-20001, "target not number");
    public static final ResultCode TARGET_NOT_INTEGER = ResultCode.createResultCode(-20002, "target not integer");
    public static final ResultCode TARGET_NOT_DOUBLE = ResultCode.createResultCode(-20003, "target not double");
    public static final ResultCode TARGET_ALREADY_EXIST = ResultCode.createResultCode(-20004, "target has exist");
    public static final ResultCode TARGET_RANGE_HAVE_NONE = ResultCode.createResultCode(-20005, "range_have none");
    public static final ResultCode TAIR_INCDECR_OVERFLOW = ResultCode.createResultCode(-20006, "data overflow");
    public static final ResultCode TAIR_DATA_LEN_LIMIT = ResultCode.createResultCode(-20007, "data len too long");
    public static final ResultCode TAIR_IS_NOT_SUPPORT = ResultCode.createResultCode(-20008, "not support");
    private int code = 0;
    private String message = null;

    private ResultCode(int code) {
        this.code = code;
    }

    private ResultCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private static ResultCode createResultCode(int code, String message) {
        ResultCode resultCode = new ResultCode(code, message);
        if (code == 1) {
            codeMap.put(-3998, resultCode);
        }
        codeMap.put(code, resultCode);
        log.debug((Object)("create ResultCode {code = " + String.valueOf(code) + ", message = " + message + "}"));
        return resultCode;
    }

    public static ResultCode valueOf(int code) {
        ResultCode resultCode = codeMap.get(code);
        if (resultCode == null) {
            return UNKNOW;
        }
        return resultCode;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.code >= 0;
    }

    public String toString() {
        return "code=" + this.code + ", msg=" + this.message;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ResultCode) {
            ResultCode rc = (ResultCode)obj;
            return rc.getCode() == this.code;
        }
        return false;
    }

    public int hashCode() {
        return this.code;
    }
}

