/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.comm;

import com.taobao.tair.comm.NamedThreadFactory;
import com.taobao.tair.comm.TairClient;
import com.taobao.tair.comm.TairClientProcessor;
import com.taobao.tair.comm.TairProtocolCodecFilter;
import com.taobao.tair.etc.TairClientException;
import com.taobao.tair.etc.TairUtil;
import com.taobao.tair.packet.PacketStreamer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public class TairClientFactory {
    private static final Log LOGGER = LogFactory.getLog(TairClientFactory.class);
    private static final int processorCount = Runtime.getRuntime().availableProcessors() + 1;
    private static final String CONNECTOR_THREADNAME = "TAIRCLIENT";
    private static final ThreadFactory CONNECTOR_TFACTORY = new NamedThreadFactory("TAIRCLIENT", false);
    private static final TairClientFactory factory = new TairClientFactory();
    private static final int MIN_CONN_TIMEOUT = 1000;
    private final SocketConnector ioConnector;
    private final ConcurrentHashMap<String, FutureTask<TairClient>> clients = new ConcurrentHashMap();

    public TairClientFactory() {
        this.ioConnector = new SocketConnector(processorCount, (Executor)Executors.newCachedThreadPool(CONNECTOR_TFACTORY));
    }

    public static TairClientFactory getSingleInstance() {
        return factory;
    }

    public void close() {
        for (FutureTask<TairClient> task : this.clients.values()) {
            if (!task.isDone() && task.cancel(true)) continue;
            TairClient client = null;
            try {
                client = task.get();
            }
            catch (InterruptedException e) {
                LOGGER.warn((Object)e);
            }
            catch (ExecutionException e) {
                LOGGER.warn((Object)e);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            client.close();
        }
        this.clients.clear();
    }

    public TairClient get(final String targetUrl, final int connectionTimeout, final PacketStreamer pstreamer) throws TairClientException {
        FutureTask<TairClient> task;
        String key = targetUrl;
        FutureTask<TairClient> existTask = null;
        existTask = this.clients.get(key);
        if (existTask == null && (existTask = this.clients.putIfAbsent(key, task = new FutureTask<TairClient>(new Callable<TairClient>(){

            @Override
            public TairClient call() throws Exception {
                return TairClientFactory.this.createClient(targetUrl, connectionTimeout, pstreamer);
            }
        }))) == null) {
            existTask = task;
            task.run();
        }
        try {
            return existTask.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException e) {
            this.clients.remove(key);
            throw e;
        }
        catch (ExecutionException e) {
            this.clients.remove(key);
            throw new TairClientException("create socket exception, target address is " + targetUrl, e);
        }
    }

    protected void removeClient(String key) {
        this.clients.remove(key);
    }

    private synchronized TairClient createClient(String targetUrl, int connectionTimeout, PacketStreamer pstreamer) throws Exception {
        SocketConnectorConfig cfg = new SocketConnectorConfig();
        cfg.setThreadModel(ThreadModel.MANUAL);
        if (connectionTimeout < 1000) {
            connectionTimeout = 1000;
        }
        cfg.setConnectTimeout(connectionTimeout / 1000);
        cfg.getSessionConfig().setTcpNoDelay(true);
        cfg.getFilterChain().addLast("objectserialize", (IoFilter)new TairProtocolCodecFilter(pstreamer));
        String address = TairUtil.getHost(targetUrl);
        int port = TairUtil.getPort(targetUrl);
        InetSocketAddress targetAddress = new InetSocketAddress(address, port);
        TairClientProcessor processor = new TairClientProcessor();
        ConnectFuture connectFuture = this.ioConnector.connect((SocketAddress)targetAddress, null, (IoHandler)processor, (IoServiceConfig)cfg);
        connectFuture.join();
        IoSession ioSession = connectFuture.getSession();
        if (ioSession == null || !ioSession.isConnected()) {
            throw new Exception("create tair connection error,targetaddress is " + targetUrl);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("create tair connection success,targetaddress is " + targetUrl));
        }
        TairClient client = new TairClient(this, ioSession, targetUrl);
        processor.setClient(client);
        processor.setFactory(this, targetUrl);
        return client;
    }
}

