/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.extend.packet.hset.request;

import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.packet.BasePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RequestHMsetPacket
extends BasePacket {
    private static final int HEADER_LEN = 17;
    private short namespace = 0;
    private short version = 0;
    private int expire = 0;
    private Object key = null;
    private Map<Object, Object> field_values = new HashMap<Object, Object>();
    private List<byte[]> bytefieldvalues = new ArrayList<byte[]>();

    public RequestHMsetPacket(Transcoder transcoder) {
        super(transcoder);
        this.pcode = 2109;
    }

    public RequestHMsetPacket() {
        this.pcode = 2109;
    }

    @Override
    public int encode() {
        byte[] keybytes = null;
        byte[] fieldbytes = null;
        byte[] valuebytes = null;
        if (this.key == null || this.field_values.isEmpty()) {
            return 3;
        }
        try {
            keybytes = this.transcoder.encode(this.key);
        }
        catch (Throwable e) {
            return 3;
        }
        if (keybytes == null) {
            return 3;
        }
        if (keybytes.length >= 1024) {
            return 1;
        }
        int fieldvalueslen = 0;
        Set<Map.Entry<Object, Object>> fvset = this.field_values.entrySet();
        for (Map.Entry<Object, Object> fv : fvset) {
            try {
                fieldbytes = this.transcoder.encode(fv.getKey());
                valuebytes = fv.getValue() instanceof Long || fv.getValue() instanceof Integer || fv.getValue() instanceof Short ? String.valueOf(fv.getValue()).getBytes() : this.transcoder.encode(fv.getValue());
            }
            catch (Throwable e) {
                return 3;
            }
            if (fieldbytes == null || valuebytes == null) {
                return 3;
            }
            if (fieldbytes.length >= 1000000 || valuebytes.length >= 1000000) {
                return 2;
            }
            this.bytefieldvalues.add(fieldbytes);
            fieldvalueslen += fieldbytes.length;
            this.bytefieldvalues.add(valuebytes);
            fieldvalueslen += valuebytes.length;
        }
        this.writePacketBegin(17 + keybytes.length + fieldvalueslen + 4 * this.bytefieldvalues.size());
        this.byteBuffer.put((byte)0);
        this.byteBuffer.putShort(this.namespace);
        this.byteBuffer.putShort(this.version);
        this.byteBuffer.putInt(this.expire);
        this.byteBuffer.putInt(keybytes.length);
        this.byteBuffer.put(keybytes);
        this.byteBuffer.putInt(this.bytefieldvalues.size());
        for (byte[] tfieldbytes : this.bytefieldvalues) {
            this.byteBuffer.putInt(tfieldbytes.length);
            this.byteBuffer.put(tfieldbytes);
        }
        this.writePacketEnd();
        return 0;
    }

    @Override
    public boolean decode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNamespace(short namespace) {
        this.namespace = namespace;
    }

    public short getNamespace() {
        return this.namespace;
    }

    @Override
    public void setVersion(short version) {
        this.version = version;
    }

    public short getVersion() {
        return this.version;
    }

    @Override
    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getExpire() {
        return this.expire;
    }

    @Override
    public void setKey(Object key) {
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    public void addFieldValue(Object field, Object value) {
        if (field == null || value == null) {
            return;
        }
        this.field_values.put(field, value);
    }

    public Object getValue(Object field) {
        if (field == null) {
            return null;
        }
        return this.field_values.get(field);
    }

    public void setValues(Map<Object, Object> field_values) {
        this.field_values = field_values;
    }

    public Map<Object, Object> getValues() {
        return this.field_values;
    }
}

