/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.impl;

import com.taobao.tair.DataEntry;
import com.taobao.tair.Result;
import com.taobao.tair.ResultCode;
import com.taobao.tair.TairManager;
import com.taobao.tair.comm.DefaultTranscoder;
import com.taobao.tair.comm.MultiSender;
import com.taobao.tair.comm.TairClient;
import com.taobao.tair.comm.TairClientFactory;
import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.etc.IncData;
import com.taobao.tair.etc.TairClientException;
import com.taobao.tair.etc.TairUtil;
import com.taobao.tair.impl.ConfigServer;
import com.taobao.tair.json.Json;
import com.taobao.tair.packet.BasePacket;
import com.taobao.tair.packet.RequestAddItemsPacket;
import com.taobao.tair.packet.RequestCommandCollection;
import com.taobao.tair.packet.RequestGetAndRemoveItemsPacket;
import com.taobao.tair.packet.RequestGetItemsCountPacket;
import com.taobao.tair.packet.RequestGetItemsPacket;
import com.taobao.tair.packet.RequestGetPacket;
import com.taobao.tair.packet.RequestIncDecPacket;
import com.taobao.tair.packet.RequestLockPacket;
import com.taobao.tair.packet.RequestPutPacket;
import com.taobao.tair.packet.RequestRemoveItemsPacket;
import com.taobao.tair.packet.RequestRemovePacket;
import com.taobao.tair.packet.ResponseGetItemsPacket;
import com.taobao.tair.packet.ResponseGetPacket;
import com.taobao.tair.packet.ResponseIncDecPacket;
import com.taobao.tair.packet.ReturnPacket;
import com.taobao.tair.packet.TairPacketStreamer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTairManager
implements TairManager {
    private static final Log log = LogFactory.getLog(DefaultTairManager.class);
    protected static String clientVersion = "TairClient 2.3.4.3";
    protected List<String> configServerList = null;
    protected String groupName = null;
    protected ConfigServer configServer = null;
    protected MultiSender multiSender = null;
    protected int timeout = 2000;
    protected int maxWaitThread = 100;
    protected TairPacketStreamer packetStreamer = null;
    protected Transcoder transcoder = null;
    protected int compressionThreshold = 0;
    protected String charset = null;
    protected String name = null;
    protected AtomicInteger failCounter = new AtomicInteger(0);
    protected TairClientFactory clientFactory = null;

    public DefaultTairManager() {
        this("DefaultTairManager", true);
    }

    public DefaultTairManager(String name, boolean sharedFactory) {
        this.name = name;
        this.clientFactory = sharedFactory ? TairClientFactory.getSingleInstance() : new TairClientFactory();
    }

    protected void updateConfigServer() {
        this.configServer.checkConfigVersion(0);
        this.failCounter.set(0);
    }

    public void init() {
        this.transcoder = new DefaultTranscoder(this.compressionThreshold, this.charset);
        this.packetStreamer = new TairPacketStreamer(this.transcoder);
        this.configServer = new ConfigServer(this.clientFactory, this.groupName, this.configServerList, this.packetStreamer);
        if (!this.configServer.retrieveConfigure()) {
            throw new RuntimeException(clientVersion + ": init config failed");
        }
        this.multiSender = new MultiSender(this.clientFactory, this.packetStreamer);
        log.warn((Object)(this.name + " [" + this.getVersion() + "] started..."));
    }

    public void close() {
        if (this.clientFactory != null) {
            this.clientFactory.close();
        }
    }

    private TairClient getClient(Object key, boolean isRead) {
        long address = this.configServer.getServer(this.transcoder.encode(key), isRead);
        if (address == 0L) {
            return null;
        }
        String host = TairUtil.idToAddress(address);
        if (host != null) {
            try {
                return this.clientFactory.get(host, this.timeout, this.packetStreamer);
            }
            catch (TairClientException e) {
                log.error((Object)("getClient failed " + host), (Throwable)e);
            }
        }
        return null;
    }

    private BasePacket sendRequest(Object key, BasePacket packet) {
        return this.sendRequest(key, packet, false);
    }

    protected BasePacket sendRequest(Object key, BasePacket packet, boolean isRead) {
        TairClient client = this.getClient(key, isRead);
        if (client == null) {
            int value = this.failCounter.incrementAndGet();
            if (value > 100) {
                this.configServer.checkConfigVersion(0);
                this.failCounter.set(0);
                log.warn((Object)"connection failed happened 100 times, sync configuration");
            }
            log.warn((Object)"conn is null ");
            return null;
        }
        BasePacket returnPacket = null;
        long startTime = System.currentTimeMillis();
        try {
            returnPacket = (BasePacket)client.invoke(packet, this.timeout);
        }
        catch (TairClientException e) {
            log.error((Object)("send request to " + client + " failed "), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        if (returnPacket == null) {
            if (this.failCounter.incrementAndGet() > 100) {
                this.configServer.checkConfigVersion(0);
                this.failCounter.set(0);
                log.warn((Object)"connection failed happened 100 times, sync configuration");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("key=" + key + ", timeout: " + this.timeout + ", used: " + (endTime - startTime) + " (ms), client: " + client));
        }
        return returnPacket;
    }

    @Override
    public Result<Integer> decr(int namespace, Serializable key, int value, int defaultValue, int expireTime) {
        if (value < 0) {
            return new Result<Integer>(ResultCode.ITEMSIZEERROR);
        }
        return this.addCount(namespace, key, -value, defaultValue, expireTime);
    }

    @Override
    public ResultCode delete(int namespace, Serializable key) {
        if (namespace < 0 || namespace > 1023) {
            return ResultCode.NSERROR;
        }
        if (key == null) {
            return ResultCode.SERIALIZEERROR;
        }
        RequestRemovePacket packet = new RequestRemovePacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.addKey(key);
        int ec = packet.encode();
        if (ec == 1) {
            return ResultCode.KEYTOLARGE;
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        if (returnPacket != null && returnPacket instanceof ReturnPacket) {
            rc = ResultCode.valueOf(((ReturnPacket)returnPacket).getCode());
        }
        return rc;
    }

    @Override
    public ResultCode invalid(int namespace, Serializable key) {
        return this.delete(namespace, key);
    }

    @Override
    public ResultCode minvalid(int namespace, List<? extends Object> keys) {
        return this.mdelete(namespace, keys);
    }

    @Override
    public Result<DataEntry> get(int namespace, Serializable key) {
        if (namespace < 0 || namespace > 1023) {
            return new Result<DataEntry>(ResultCode.NSERROR);
        }
        RequestGetPacket packet = new RequestGetPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.addKey(key);
        int ec = packet.encode();
        if (ec == 1) {
            return new Result<DataEntry>(ResultCode.KEYTOLARGE);
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet, true);
        if (returnPacket != null && returnPacket instanceof ResponseGetPacket) {
            ResponseGetPacket r = (ResponseGetPacket)returnPacket;
            DataEntry resultObject = null;
            List<DataEntry> entryList = r.getEntryList();
            rc = ResultCode.valueOf(r.getResultCode());
            if (rc == ResultCode.SUCCESS && entryList.size() > 0) {
                resultObject = entryList.get(0);
            }
            this.configServer.checkConfigVersion(r.getConfigVersion());
            return new Result<DataEntry>(rc, resultObject);
        }
        return new Result<DataEntry>(rc);
    }

    @Override
    public String getVersion() {
        return clientVersion;
    }

    @Override
    public Result<Integer> incr(int namespace, Serializable key, int value, int defaultValue, int expireTime) {
        if (value < 0) {
            return new Result<Integer>(ResultCode.ITEMSIZEERROR);
        }
        return this.addCount(namespace, key, value, defaultValue, expireTime);
    }

    @Override
    public ResultCode setCount(int namespace, Serializable key, int count) {
        return this.setCount(namespace, key, count, 0, 0);
    }

    @Override
    public ResultCode setCount(int namespace, Serializable key, int count, int version, int expireTime) {
        if (namespace < 0 || namespace > 1023) {
            return ResultCode.NSERROR;
        }
        RequestPutPacket packet = new RequestPutPacket(this.transcoder);
        IncData value = new IncData(count);
        packet.setNamespace((short)namespace);
        packet.setKey(key);
        packet.setData(value);
        packet.setVersion((short)version);
        packet.setExpired(expireTime);
        int ec = packet.encode(1);
        if (ec == 1) {
            return ResultCode.KEYTOLARGE;
        }
        if (ec == 2) {
            return ResultCode.VALUETOLARGE;
        }
        if (ec == 3) {
            return ResultCode.SERIALIZEERROR;
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        if (returnPacket != null && returnPacket instanceof ReturnPacket) {
            ReturnPacket r = (ReturnPacket)returnPacket;
            if (log.isDebugEnabled()) {
                log.debug((Object)("get return packet: " + returnPacket + ", code=" + r.getCode() + ", msg=" + r.getMsg()));
            }
            rc = ResultCode.valueOf(r.getCode());
            this.configServer.checkConfigVersion(r.getConfigVersion());
        }
        return rc;
    }

    private Result<Integer> addCount(int namespace, Serializable key, int value, int defaultValue, int expireTime) {
        if (namespace < 0 || namespace > 1023) {
            return new Result<Integer>(ResultCode.NSERROR);
        }
        RequestIncDecPacket packet = new RequestIncDecPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.setKey(key);
        packet.setCount(value);
        packet.setInitValue(defaultValue);
        packet.setExpireTime(expireTime);
        int ec = packet.encode();
        if (ec == 1) {
            return new Result<Integer>(ResultCode.KEYTOLARGE);
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        if (returnPacket != null) {
            if (returnPacket instanceof ResponseIncDecPacket) {
                ResponseIncDecPacket r = (ResponseIncDecPacket)returnPacket;
                rc = ResultCode.SUCCESS;
                this.configServer.checkConfigVersion(r.getConfigVersion());
                return new Result<Integer>(rc, r.getValue());
            }
            if (returnPacket instanceof ReturnPacket) {
                ReturnPacket rp = (ReturnPacket)returnPacket;
                rc = ResultCode.valueOf(rp.getCode());
                this.configServer.checkConfigVersion(rp.getConfigVersion());
            }
        }
        return new Result<Integer>(rc);
    }

    @Override
    public ResultCode mdelete(int namespace, List<? extends Object> keys) {
        if (namespace < 0 || namespace > 1023) {
            return ResultCode.NSERROR;
        }
        RequestCommandCollection rcc = new RequestCommandCollection();
        for (Object object : keys) {
            long address = this.configServer.getServer(this.transcoder.encode(object), false);
            if (address == 0L) continue;
            RequestRemovePacket packet = (RequestRemovePacket)rcc.findRequest(address);
            if (packet == null) {
                packet = new RequestRemovePacket(this.transcoder);
                packet.setNamespace((short)namespace);
                packet.addKey(object);
                rcc.addRequest(address, packet);
                continue;
            }
            packet.addKey(object);
        }
        for (BasePacket basePacket : rcc.getRequestCommandMap().values()) {
            RequestGetPacket rp = (RequestGetPacket)basePacket;
            int ec = rp.encode();
            if (ec != 1) continue;
            log.error((Object)"key too larget: ");
            return ResultCode.KEYTOLARGE;
        }
        ResultCode rc = ResultCode.CONNERROR;
        boolean bl = this.multiSender.sendRequest(rcc, this.timeout);
        if (bl) {
            int maxConfigVersion = 0;
            rc = ResultCode.SUCCESS;
            for (BasePacket rp : rcc.getResultList()) {
                ResultCode drc;
                if (!(rp instanceof ReturnPacket)) continue;
                ReturnPacket returnPacket = (ReturnPacket)rp;
                returnPacket.decode();
                if (returnPacket.getConfigVersion() > maxConfigVersion) {
                    maxConfigVersion = returnPacket.getConfigVersion();
                }
                if ((drc = ResultCode.valueOf(returnPacket.getCode())).isSuccess()) continue;
                log.debug((Object)("mdelete not return success, result code: " + ResultCode.valueOf(returnPacket.getCode())));
                rc = ResultCode.PARTSUCC;
            }
            this.configServer.checkConfigVersion(maxConfigVersion);
        } else if (this.failCounter.incrementAndGet() > 100) {
            this.configServer.checkConfigVersion(0);
            this.failCounter.set(0);
            log.warn((Object)"connection failed happened 100 times, sync configuration");
        }
        return rc;
    }

    @Override
    public Result<List<DataEntry>> mget(int namespace, List<? extends Object> keys) {
        if (namespace < 0 || namespace > 1023) {
            return new Result<List<DataEntry>>(ResultCode.NSERROR);
        }
        RequestCommandCollection rcc = new RequestCommandCollection();
        for (Object object : keys) {
            long address = this.configServer.getServer(this.transcoder.encode(object), true);
            if (address == 0L) continue;
            RequestGetPacket packet = (RequestGetPacket)rcc.findRequest(address);
            if (packet == null) {
                packet = new RequestGetPacket(this.transcoder);
                packet.setNamespace((short)namespace);
                packet.addKey(object);
                rcc.addRequest(address, packet);
                continue;
            }
            packet.addKey(object);
        }
        int reqSize = 0;
        for (BasePacket p : rcc.getRequestCommandMap().values()) {
            RequestGetPacket rp = (RequestGetPacket)p;
            reqSize += rp.getKeyList().size();
            int ec = rp.encode();
            if (ec != 1) continue;
            log.error((Object)"key too larget: ");
            return new Result<List<DataEntry>>(ResultCode.KEYTOLARGE);
        }
        boolean bl = this.multiSender.sendRequest(rcc, this.timeout);
        if (!bl) {
            if (this.failCounter.incrementAndGet() > 100) {
                this.configServer.checkConfigVersion(0);
                this.failCounter.set(0);
                log.warn((Object)"connection failed happened 100 times, sync configuration");
            }
            return new Result<List<DataEntry>>(ResultCode.CONNERROR);
        }
        ArrayList<DataEntry> results = new ArrayList<DataEntry>();
        ResultCode rc = ResultCode.SUCCESS;
        ResponseGetPacket resp = null;
        int maxConfigVersion = 0;
        for (BasePacket bp : rcc.getResultList()) {
            if (bp instanceof ResponseGetPacket) {
                resp = (ResponseGetPacket)bp;
                resp.decode();
                results.addAll(resp.getEntryList());
                if (resp.getConfigVersion() <= maxConfigVersion) continue;
                maxConfigVersion = resp.getConfigVersion();
                continue;
            }
            log.warn((Object)("receive wrong packet type: " + bp));
        }
        this.configServer.checkConfigVersion(maxConfigVersion);
        if (results.size() == 0) {
            rc = ResultCode.DATANOTEXSITS;
        } else if (results.size() != reqSize) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("mget partly success: request key size: " + reqSize + ", get " + results.size()));
            }
            rc = ResultCode.PARTSUCC;
        }
        return new Result<List<DataEntry>>(rc, results);
    }

    @Override
    public ResultCode put(int namespace, Serializable key, Serializable value) {
        return this.put(namespace, key, value, 0, 0);
    }

    @Override
    public ResultCode put(int namespace, Serializable key, Serializable value, int version) {
        return this.put(namespace, key, value, version, 0);
    }

    @Override
    public ResultCode put(int namespace, Serializable key, Serializable value, int version, int expireTime) {
        if (namespace < 0 || namespace > 1023) {
            return ResultCode.NSERROR;
        }
        if (expireTime < 0) {
            return ResultCode.INVALIDARG;
        }
        RequestPutPacket packet = new RequestPutPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.setKey(key);
        packet.setData(value);
        packet.setVersion((short)version);
        packet.setExpired(expireTime);
        int ec = packet.encode();
        if (ec == 1) {
            return ResultCode.KEYTOLARGE;
        }
        if (ec == 2) {
            return ResultCode.VALUETOLARGE;
        }
        if (ec == 3) {
            return ResultCode.SERIALIZEERROR;
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        if (returnPacket != null && returnPacket instanceof ReturnPacket) {
            ReturnPacket r = (ReturnPacket)returnPacket;
            if (log.isDebugEnabled()) {
                log.debug((Object)("get return packet: " + returnPacket + ", code=" + r.getCode() + ", msg=" + r.getMsg()));
            }
            rc = ResultCode.valueOf(r.getCode());
            this.configServer.checkConfigVersion(r.getConfigVersion());
        }
        return rc;
    }

    @Override
    public ResultCode lock(int namespace, Serializable key) {
        return this.doLock(namespace, key, 2, "lock");
    }

    @Override
    public ResultCode unlock(int namespace, Serializable key) {
        return this.doLock(namespace, key, 3, "unlock");
    }

    @Override
    public Result<List<Object>> mlock(int namespace, List<? extends Object> keys) {
        return this.doMLock(namespace, keys, 2, "mlock", null);
    }

    @Override
    public Result<List<Object>> mlock(int namespace, List<? extends Object> keys, Map<Object, ResultCode> failKeysMap) {
        return this.doMLock(namespace, keys, 2, "mlock", failKeysMap);
    }

    @Override
    public Result<List<Object>> munlock(int namespace, List<? extends Object> keys) {
        return this.doMLock(namespace, keys, 3, "munlock", null);
    }

    @Override
    public Result<List<Object>> munlock(int namespace, List<? extends Object> keys, Map<Object, ResultCode> failKeysMap) {
        return this.doMLock(namespace, keys, 3, "munlock", failKeysMap);
    }

    private ResultCode doLock(int namespace, Serializable key, int lockType, String descStr) {
        if (namespace < 0 || namespace > 1023) {
            return ResultCode.NSERROR;
        }
        RequestLockPacket packet = new RequestLockPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.setKey(key);
        packet.setLockType(lockType);
        int ec = packet.encode();
        if (ec == 1) {
            return ResultCode.KEYTOLARGE;
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        if (returnPacket != null && returnPacket instanceof ReturnPacket) {
            rc = ResultCode.valueOf(((ReturnPacket)returnPacket).getCode());
        } else if (this.failCounter.incrementAndGet() > 100) {
            this.configServer.checkConfigVersion(0);
            this.failCounter.set(0);
            log.warn((Object)"connection failed happened 100 times, sync configuration");
        }
        return rc;
    }

    private Result<List<Object>> doMLock(int namespace, List<? extends Object> keys, int lockType, String descStr, Map<Object, ResultCode> failKeysMap) {
        int n;
        if (namespace < 0 || namespace > 1023) {
            return new Result<List<Object>>(ResultCode.NSERROR);
        }
        if (failKeysMap != null) {
            failKeysMap.clear();
        }
        ArrayList sucList = null;
        HashSet<Object> uniqueKeys = new HashSet<Object>();
        for (Object object : keys) {
            uniqueKeys.add(object);
        }
        int sucRespSize = 0;
        boolean bl = false;
        for (Object e : uniqueKeys) {
            int retCode;
            RequestLockPacket packet = new RequestLockPacket(this.transcoder);
            packet.setNamespace((short)namespace);
            packet.setLockType(lockType);
            packet.setKey(e);
            int ec = packet.encode();
            if (ec == 1) {
                log.error((Object)"key too larget");
                if (failKeysMap == null) continue;
                failKeysMap.put(e, ResultCode.KEYTOLARGE);
                continue;
            }
            BasePacket returnPacket = this.sendRequest(e, packet);
            if (returnPacket != null && returnPacket instanceof ReturnPacket) {
                if (((ReturnPacket)returnPacket).getConfigVersion() > n) {
                    n = ((ReturnPacket)returnPacket).getConfigVersion();
                }
                retCode = ((ReturnPacket)returnPacket).getCode();
            } else {
                retCode = ResultCode.CONNERROR.getCode();
                log.warn((Object)("receive wrong packet type: " + returnPacket));
                if (this.failCounter.incrementAndGet() > 100) {
                    this.configServer.checkConfigVersion(0);
                    this.failCounter.set(0);
                    log.warn((Object)"connection failed happened 100 times, sync configuration");
                }
            }
            if (retCode == ResultCode.SUCCESS.getCode()) {
                if (sucList == null) {
                    sucList = new ArrayList();
                }
                sucList.add(e);
                ++sucRespSize;
                continue;
            }
            if (failKeysMap == null) continue;
            failKeysMap.put(e, ResultCode.valueOf(retCode));
        }
        this.configServer.checkConfigVersion(n);
        ResultCode rc = null;
        if (sucRespSize == uniqueKeys.size()) {
            rc = ResultCode.SUCCESS;
        } else {
            if (log.isDebugEnabled()) {
                log.error((Object)(descStr + "partly success: request key size: " + uniqueKeys.size() + ", fail " + (uniqueKeys.size() - sucRespSize)));
            }
            rc = ResultCode.PARTSUCC;
        }
        return new Result<Object>(rc, sucList);
    }

    @Override
    public ResultCode addItems(int namespace, Serializable key, List<? extends Object> items, int maxCount, int version, int expireTime) {
        if (namespace < 0 || namespace > 1023) {
            return ResultCode.NSERROR;
        }
        if (maxCount <= 0 || expireTime < 0) {
            return ResultCode.INVALIDARG;
        }
        RequestAddItemsPacket packet = new RequestAddItemsPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.setKey(key);
        packet.setData(items);
        packet.setVersion((short)version);
        packet.setExpired(expireTime);
        packet.setMaxCount(maxCount);
        int ec = packet.encode();
        if (ec == 1) {
            return ResultCode.KEYTOLARGE;
        }
        if (ec == 2) {
            return ResultCode.VALUETOLARGE;
        }
        if (ec == 3) {
            return ResultCode.SERIALIZEERROR;
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        if (returnPacket != null && returnPacket instanceof ReturnPacket) {
            ReturnPacket r = (ReturnPacket)returnPacket;
            if (log.isDebugEnabled()) {
                log.debug((Object)("get return packet: " + returnPacket + ", code=" + r.getCode() + ", msg=" + r.getMsg()));
            }
            rc = r.getCode() == 0 ? ResultCode.SUCCESS : (r.getCode() == 2 ? ResultCode.VERERROR : ResultCode.SERVERERROR);
            this.configServer.checkConfigVersion(r.getConfigVersion());
        }
        return rc;
    }

    @Override
    public Result<DataEntry> getAndRemove(int namespace, Serializable key, int offset, int count) {
        if (namespace < 0 || namespace > 1023) {
            return new Result<DataEntry>(ResultCode.NSERROR);
        }
        if (count <= 0) {
            return new Result<DataEntry>(ResultCode.INVALIDARG);
        }
        RequestGetAndRemoveItemsPacket packet = new RequestGetAndRemoveItemsPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.addKey(key);
        packet.setCount(count);
        packet.setOffset(offset);
        packet.setType(4);
        int ec = packet.encode();
        if (ec == 1) {
            return new Result<DataEntry>(ResultCode.KEYTOLARGE);
        }
        if (ec == 2) {
            return new Result<DataEntry>(ResultCode.VALUETOLARGE);
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        DataEntry entry = null;
        if (returnPacket != null && returnPacket instanceof ResponseGetItemsPacket) {
            ResponseGetItemsPacket r = (ResponseGetItemsPacket)returnPacket;
            List<DataEntry> entryList = r.getEntryList();
            rc = ResultCode.valueOf(r.getResultCode());
            if (rc.isSuccess() && entryList.size() > 0) {
                entry = entryList.get(0);
                try {
                    entry.setValue(Json.deSerialize((byte[])entry.getValue()));
                }
                catch (Throwable e1) {
                    log.error((Object)"ITEM SERIALIZEERROR", e1);
                    rc = ResultCode.SERIALIZEERROR;
                }
            }
            this.configServer.checkConfigVersion(r.getConfigVersion());
        }
        return new Result<Object>(rc, entry);
    }

    @Override
    public Result<DataEntry> getItems(int namespace, Serializable key, int offset, int count) {
        if (namespace < 0 || namespace > 1023) {
            return new Result<DataEntry>(ResultCode.NSERROR);
        }
        if (count <= 0) {
            return new Result<DataEntry>(ResultCode.INVALIDARG);
        }
        RequestGetItemsPacket packet = new RequestGetItemsPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.addKey(key);
        packet.setCount(count);
        packet.setOffset(offset);
        packet.setType(4);
        int ec = packet.encode();
        if (ec == 1) {
            return new Result<DataEntry>(ResultCode.KEYTOLARGE);
        }
        if (ec == 2) {
            return new Result<DataEntry>(ResultCode.VALUETOLARGE);
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        DataEntry entry = null;
        if (returnPacket != null && returnPacket instanceof ResponseGetItemsPacket) {
            ResponseGetItemsPacket r = (ResponseGetItemsPacket)returnPacket;
            List<DataEntry> entryList = r.getEntryList();
            rc = ResultCode.valueOf(r.getResultCode());
            if (rc.isSuccess() && entryList.size() > 0) {
                entry = entryList.get(0);
                try {
                    entry.setValue(Json.deSerialize((byte[])entry.getValue()));
                }
                catch (Throwable e1) {
                    log.error((Object)"ITEM SERIALIZEERROR", e1);
                    rc = ResultCode.SERIALIZEERROR;
                }
            }
            this.configServer.checkConfigVersion(r.getConfigVersion());
        }
        return new Result<Object>(rc, entry);
    }

    @Override
    public ResultCode removeItems(int namespace, Serializable key, int offset, int count) {
        if (namespace < 0 || namespace > 1023) {
            return ResultCode.NSERROR;
        }
        if (count <= 0) {
            return ResultCode.INVALIDARG;
        }
        RequestRemoveItemsPacket packet = new RequestRemoveItemsPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.addKey(key);
        packet.setCount(count);
        packet.setOffset(offset);
        int ec = packet.encode();
        if (ec == 1) {
            return ResultCode.KEYTOLARGE;
        }
        if (ec == 2) {
            return ResultCode.VALUETOLARGE;
        }
        ResultCode rc = ResultCode.CONNERROR;
        BasePacket returnPacket = this.sendRequest(key, packet);
        if (returnPacket != null && returnPacket instanceof ReturnPacket) {
            ReturnPacket r = (ReturnPacket)returnPacket;
            rc = ResultCode.valueOf(r.getCode());
            this.configServer.checkConfigVersion(r.getConfigVersion());
        }
        return rc;
    }

    @Override
    public Result<Integer> getItemCount(int namespace, Serializable key) {
        if (namespace < 0 || namespace > 1023) {
            return new Result<Integer>(ResultCode.NSERROR);
        }
        RequestGetItemsCountPacket packet = new RequestGetItemsCountPacket(this.transcoder);
        packet.setNamespace((short)namespace);
        packet.addKey(key);
        int ec = packet.encode();
        if (ec == 1) {
            return new Result<Integer>(ResultCode.KEYTOLARGE);
        }
        if (ec == 2) {
            return new Result<Integer>(ResultCode.VALUETOLARGE);
        }
        ResultCode rc = ResultCode.SUCCESS;
        BasePacket returnPacket = this.sendRequest(key, packet);
        int count = 0;
        if (returnPacket != null && returnPacket instanceof ReturnPacket) {
            ReturnPacket r = (ReturnPacket)returnPacket;
            count = ((ReturnPacket)returnPacket).getCode();
            if (count < 0) {
                rc = ResultCode.valueOf(count);
            }
            this.configServer.checkConfigVersion(r.getConfigVersion());
        }
        return new Result<Integer>(rc, count);
    }

    @Override
    public Map<String, String> getStat(int qtype, String groupName, long serverId) {
        Map<String, String> temp = this.configServer.retrieveStat(qtype, groupName, serverId);
        return temp;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        if (compressionThreshold <= 1024) {
            log.warn((Object)("compress threshold can not bigger than max key length[1024], you provided:[" + compressionThreshold + "]"));
        } else {
            this.compressionThreshold = compressionThreshold;
        }
    }

    public List<String> getConfigServerList() {
        return this.configServerList;
    }

    public void setConfigServerList(List<String> configServerList) {
        this.configServerList = configServerList;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getMaxWaitThread() {
        return this.maxWaitThread;
    }

    public void setMaxWaitThread(int maxWaitThread) {
        this.maxWaitThread = maxWaitThread;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return this.name + " " + this.getVersion();
    }

    public ConfigServer getConfigServer() {
        return this.configServer;
    }
}

