/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.packet;

import com.taobao.tair.DataEntry;
import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.json.Json;
import com.taobao.tair.packet.RequestPutPacket;
import java.util.List;

public class RequestAddItemsPacket
extends RequestPutPacket {
    protected int maxCount;
    protected List<? extends Object> data;

    public RequestAddItemsPacket(Transcoder transcoder) {
        super(transcoder);
        this.pcode = 1400;
    }

    @Override
    public int encode() {
        byte[] keyByte = this.transcoder.encode(this.key);
        byte[] dataByte = Json.serialize(this.data);
        if (dataByte == null) {
            return 3;
        }
        if (keyByte.length >= 1024) {
            return 1;
        }
        if (dataByte.length >= 1000000) {
            return 2;
        }
        this.writePacketBegin(keyByte.length + dataByte.length);
        this.byteBuffer.put((byte)0);
        this.byteBuffer.putShort(this.namespace);
        this.byteBuffer.putShort(this.version);
        this.byteBuffer.putInt(this.expired);
        this.fillMetas();
        DataEntry.encodeMeta(this.byteBuffer);
        this.byteBuffer.putInt(keyByte.length);
        this.byteBuffer.put(keyByte);
        this.fillMetas();
        DataEntry.encodeMeta(this.byteBuffer);
        this.byteBuffer.putInt(dataByte.length);
        this.byteBuffer.put(dataByte);
        this.byteBuffer.putInt(this.maxCount);
        this.writePacketEnd();
        return 0;
    }

    @Override
    public boolean decode() {
        throw new UnsupportedOperationException();
    }

    public void setData(List<? extends Object> data) {
        this.data = data;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }
}

