/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.internal.PropagationFields;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapPropagationFields<K, V>
extends PropagationFields<K, V> {
    volatile Map<K, V> values;

    protected MapPropagationFields() {
    }

    protected MapPropagationFields(Map<K, V> parent) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        this.values = Collections.unmodifiableMap(parent);
    }

    protected MapPropagationFields(MapPropagationFields<K, V> parent) {
        this.values = parent.values;
    }

    @Override
    public V get(K key) {
        Map<K, V> values = this.values;
        return values != null ? (V)values.get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(PropagationFields.FieldConsumer<K, V> fieldConsumer) {
        MapPropagationFields mapPropagationFields = this;
        synchronized (mapPropagationFields) {
            Map<K, V> values = this.values;
            if (values == null) {
                return;
            }
            for (Map.Entry<K, V> entry : values.entrySet()) {
                V value = entry.getValue();
                if (value == null) continue;
                fieldConsumer.accept(entry.getKey(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(K key, V value) {
        MapPropagationFields mapPropagationFields = this;
        synchronized (mapPropagationFields) {
            Map<K, V> values = this.values;
            if (values == null) {
                values = new LinkedHashMap();
                values.put(key, value);
            } else {
                if (value.equals(values.get(key))) {
                    return;
                }
                values = new LinkedHashMap<K, V>(values);
                values.put(key, value);
            }
            this.values = Collections.unmodifiableMap(values);
        }
    }

    @Override
    public boolean isEmpty() {
        Map<K, V> values = this.values;
        return values == null || values.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void putAllIfAbsent(PropagationFields parent) {
        if (!(parent instanceof MapPropagationFields)) {
            return;
        }
        MapPropagationFields mapParent = (MapPropagationFields)parent;
        Map<K, V> parentValues = mapParent.values;
        if (parentValues == null) {
            return;
        }
        MapPropagationFields mapPropagationFields = this;
        synchronized (mapPropagationFields) {
            if (this.values == null) {
                this.values = parentValues;
                return;
            }
        }
        for (Map.Entry entry : parentValues.entrySet()) {
            if (this.values.containsKey(entry.getKey())) continue;
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final Map<K, V> toMap() {
        Map<K, V> values = this.values;
        if (values == null) {
            return Collections.emptyMap();
        }
        return values;
    }

    public int hashCode() {
        Map<K, V> values = this.values;
        return values == null ? 0 : values.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapPropagationFields)) {
            return false;
        }
        MapPropagationFields that = (MapPropagationFields)o;
        Map<K, V> values = this.values;
        Map<K, V> thatValues = that.values;
        return values == null ? thatValues == null : values.equals(thatValues);
    }
}

